/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.Vector2fExpression;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;

@EditorTypes(value={Constant.class, Reference.class, Uniform.class})
public abstract class Transform2DExpression
extends ObjectExpression<Transform2D> {

    public static class Uniform
    extends Transform2DExpression {
        @Editable
        public Vector2fExpression translation = new Vector2fExpression.Constant();
        @Editable
        public FloatExpression rotation = new FloatExpression.Constant();
        @Editable
        public FloatExpression scale = new FloatExpression.Constant(1.0f);

        @Override
        public ObjectExpression.Evaluator<Transform2D> createEvaluator(Scope scope) {
            final ObjectExpression.Evaluator teval = this.translation.createEvaluator(scope);
            final FloatExpression.Evaluator reval = this.rotation.createEvaluator(scope);
            final FloatExpression.Evaluator seval = this.scale.createEvaluator(scope);
            return new ObjectExpression.Evaluator<Transform2D>(){
                protected Transform2D _result = new Transform2D();

                @Override
                public Transform2D evaluate() {
                    return this._result.set((Vector2f)teval.evaluate(), reval.evaluate(), seval.evaluate());
                }
            };
        }

        @Override
        public void invalidate() {
            this.translation.invalidate();
            this.rotation.invalidate();
            this.scale.invalidate();
        }
    }

    public static class Reference
    extends Transform2DExpression {
        @Editable
        public String name = "";
        @Editable(step=0.01)
        public Transform2D defvalue = new Transform2D();

        @Override
        public ObjectExpression.Evaluator<Transform2D> createEvaluator(Scope scope) {
            final Transform2D value = ScopeUtil.resolve(scope, this.name, this.defvalue);
            return new ObjectExpression.Evaluator<Transform2D>(){

                @Override
                public Transform2D evaluate() {
                    return value;
                }
            };
        }
    }

    public static class Constant
    extends Transform2DExpression {
        @Editable(step=0.01)
        public Transform2D value = new Transform2D();

        @Override
        public ObjectExpression.Evaluator<Transform2D> createEvaluator(Scope scope) {
            return new ObjectExpression.Evaluator<Transform2D>(){

                @Override
                public Transform2D evaluate() {
                    return Constant.this.value;
                }
            };
        }
    }
}

