/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.threerings.openal.Log;
import com.threerings.openal.ResourceStream;
import com.threerings.openal.SoundManager;
import com.threerings.openal.Stream;
import java.io.IOException;

public class StackedStream
extends ResourceStream {
    protected String _stack;
    protected int _level = -1;

    public StackedStream(SoundManager soundmgr, String file, boolean loop, String stack) throws IOException {
        super(soundmgr, file, loop);
        this._stack = stack;
    }

    public String getStack() {
        return this._stack;
    }

    public int getLevel() {
        return this._level;
    }

    public void push(float interval, boolean current) {
        if (this._level > -1) {
            Log.log.warning((Object)"Can't push stream already on the stack", new Object[]{"level", this._level});
            return;
        }
        int top = this.getTop();
        if (top > -1 && !current) {
            for (Stream stream : this._soundmgr.getStreams()) {
                if (!this.sameStack(stream) || ((StackedStream)stream).getLevel() != top) continue;
                if (interval > 0.0f) {
                    stream.fadeOut(interval, false);
                    continue;
                }
                stream.stop();
            }
        }
        this._level = top;
        if (top == -1 || !current) {
            ++this._level;
        }
        if (interval > 0.0f) {
            this.fadeIn(interval);
        } else {
            this.play();
        }
    }

    public void pop(float interval) {
        if (this._level == -1) {
            Log.log.warning((Object)"Can't pop stream not on the stack", new Object[0]);
            return;
        }
        if (interval > 0.0f) {
            this.fadeOut(interval, true);
        } else {
            this.dispose();
        }
        int oldLevel = this._level;
        this._level = -1;
        int top = this.getTop();
        if (top > -1 && top < oldLevel) {
            for (Stream stream : this._soundmgr.getStreams()) {
                if (!this.sameStack(stream) || ((StackedStream)stream).getLevel() != top || stream._fadeMode == Stream.FadeMode.OUT_DISPOSE) continue;
                if (interval > 0.0f) {
                    stream.fadeIn(interval);
                    continue;
                }
                stream.play();
            }
        }
    }

    protected boolean sameStack(Stream other) {
        if (other instanceof StackedStream) {
            String stack = ((StackedStream)other).getStack();
            return this._stack == null ? stack == null : this._stack.equals(stack);
        }
        return false;
    }

    protected int getTop() {
        int top = -1;
        for (Stream stream : this._soundmgr.getStreams()) {
            if (!this.sameStack(stream)) continue;
            top = Math.max(top, ((StackedStream)stream).getLevel());
        }
        return top;
    }
}

