/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.compositor.config;

import com.google.common.collect.Maps;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Executor;
import com.threerings.expr.Scope;
import com.threerings.opengl.compositor.Compositor;
import com.threerings.opengl.compositor.Dependency;
import com.threerings.opengl.compositor.RenderQueue;
import com.threerings.opengl.geometry.config.GeometryConfig;
import com.threerings.opengl.material.Surface;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.state.ColorMaskState;
import com.threerings.opengl.renderer.state.DepthState;
import com.threerings.opengl.renderer.state.StencilState;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL11;

@EditorTypes(value={Clear.class, RenderQueues.class, RenderQuad.class})
public abstract class StepConfig
extends DeepObject
implements Exportable {
    public boolean isSupported(GlContext ctx, boolean fallback) {
        return true;
    }

    public abstract Executor createExecutor(GlContext var1, Scope var2);

    public static class RenderQuad
    extends StepConfig {
        @Editable(nullable=true)
        public ConfigReference<MaterialConfig> material;
        @Editable(min=1.0, hgroup="d")
        public int divisionsX = 1;
        @Editable(min=1.0, hgroup="d")
        public int divisionsY = 1;

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            MaterialConfig config = ctx.getConfigManager().getConfig(MaterialConfig.class, this.material);
            return config != null && config.getTechnique(ctx, null) != null;
        }

        @Override
        public Executor createExecutor(final GlContext ctx, Scope scope) {
            MaterialConfig config = ctx.getConfigManager().getConfig(MaterialConfig.class, this.material);
            final HashMap dependencies = Maps.newHashMap();
            final RenderQueue.Group group = new RenderQueue.Group(ctx);
            final Surface surface = new Surface(ctx, scope, GeometryConfig.getQuad(this.divisionsX, this.divisionsY), config, group);
            return new Executor(){

                @Override
                public void execute() {
                    Renderer renderer = ctx.getRenderer();
                    renderer.setMatrixMode(5889);
                    GL11.glPushMatrix();
                    GL11.glLoadIdentity();
                    Compositor compositor = ctx.getCompositor();
                    Map<Dependency, Dependency> odeps = compositor.getDependencies();
                    compositor.setDependencies(dependencies);
                    surface.composite();
                    compositor.enqueueEnqueueables();
                    group.sortQueues();
                    group.renderQueues();
                    group.clearQueues();
                    compositor.clearDependencies();
                    compositor.setDependencies(odeps);
                    renderer.setMatrixMode(5889);
                    GL11.glPopMatrix();
                }
            };
        }
    }

    public static class RenderQueues
    extends StepConfig {
        @Editable
        public String queueType = "normal";
        @Editable(hgroup="p")
        public int minPriority = Integer.MIN_VALUE;
        @Editable(hgroup="p")
        public int maxPriority = Integer.MAX_VALUE;

        @Override
        public Executor createExecutor(final GlContext ctx, Scope scope) {
            return new Executor(){

                @Override
                public void execute() {
                    ctx.getCompositor().getGroup().renderQueues(RenderQueues.this.queueType, RenderQueues.this.minPriority, RenderQueues.this.maxPriority);
                }
            };
        }
    }

    public static class Clear
    extends StepConfig {
        @Editable
        public Color color = new Color();
        @Editable
        public Depth depth = new Depth();
        @Editable
        public Stencil stencil = new Stencil();

        @Override
        public Executor createExecutor(final GlContext ctx, Scope scope) {
            return new Executor(){

                @Override
                public void execute() {
                    Renderer renderer = ctx.getRenderer();
                    int bits = 0;
                    if (Clear.this.color.clear) {
                        bits |= 0x4000;
                        renderer.setClearColor(Clear.this.color.value);
                        renderer.setState(ColorMaskState.ALL);
                    }
                    if (Clear.this.depth.clear) {
                        bits |= 0x100;
                        renderer.setClearDepth(Clear.this.depth.value);
                        renderer.setState(DepthState.TEST_WRITE);
                    }
                    if (Clear.this.stencil.clear) {
                        bits |= 0x400;
                        renderer.setClearStencil(Clear.this.stencil.value);
                        renderer.setState(StencilState.DISABLED);
                    }
                    if (bits != 0) {
                        GL11.glClear((int)bits);
                    }
                }
            };
        }

        public static class Stencil
        extends DeepObject
        implements Exportable {
            @Editable(hgroup="c")
            public boolean clear = true;
            @Editable(min=0.0, hgroup="c")
            public int value;
        }

        public static class Depth
        extends DeepObject
        implements Exportable {
            @Editable(hgroup="c")
            public boolean clear = true;
            @Editable(min=0.0, max=1.0, step=0.01, hgroup="c")
            public float value = 1.0f;
        }

        public static class Color
        extends DeepObject
        implements Exportable {
            @Editable(hgroup="c")
            public boolean clear = true;
            @Editable(mode="alpha", hgroup="c")
            public Color4f value = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }
}

