/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.opengl.renderer.DisplayList;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.shape.Shape;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;
import org.lwjgl.opengl.GL11;

@EditorTypes(value={Point.class, Segment.class, Rectangle.class, Circle.class, Capsule.class, Polygon.class, Compound.class, Global.class, TransformedShape.class})
public abstract class ShapeConfig
extends DeepObject
implements Exportable,
Streamable {
    @DeepOmit
    protected transient Shape _shape;
    @DeepOmit
    protected transient Box _bounds;
    @DeepOmit
    protected transient SoftReference<DisplayList> _solidList;
    @DeepOmit
    protected transient SoftReference<DisplayList> _outlineList;
    protected static final int CIRCLE_SEGMENTS = 16;
    protected static final float CIRCLE_INCREMENT = 0.3926991f;

    public Shape getShape() {
        if (this._shape == null) {
            this._shape = this.createShape();
        }
        return this._shape;
    }

    public Box getBounds() {
        if (this._bounds == null) {
            Rect rect = this.getShape().getBounds();
            Vector2f min = rect.getMinimumExtent();
            Vector2f max = rect.getMaximumExtent();
            this._bounds = new Box();
            this._bounds.getMinimumExtent().set(min.x, min.y, 0.0f);
            this._bounds.getMaximumExtent().set(max.x, max.y, 0.0f);
        }
        return this._bounds;
    }

    public DisplayList getList(GlContext ctx, boolean outline) {
        DisplayList list;
        SoftReference<DisplayList> ref = outline ? this._outlineList : this._solidList;
        DisplayList displayList = list = ref == null ? null : ref.get();
        if (list == null) {
            list = new DisplayList(ctx.getRenderer());
            ref = new SoftReference<DisplayList>(list);
            if (outline) {
                this._outlineList = ref;
            } else {
                this._solidList = ref;
            }
            list.begin();
            this.draw(outline);
            list.end();
        }
        return list;
    }

    public void invalidate() {
        this._shape = null;
        this._bounds = null;
        this._outlineList = null;
        this._solidList = null;
    }

    protected abstract Shape createShape();

    protected abstract void draw(boolean var1);

    public static class TransformedShape
    extends ShapeConfig {
        @Editable
        public ShapeConfig shape = new Point();
        @Editable(step=0.01)
        public Transform2D transform = new Transform2D();
        @DeepOmit
        protected transient Shape _shape;

        @Override
        public Shape getShape() {
            if (this._shape == null) {
                this._shape = this.shape.getShape().transform(this.transform);
            }
            return this._shape;
        }

        @Override
        public void invalidate() {
            this.shape.invalidate();
            this._shape = null;
        }

        @Override
        protected Shape createShape() {
            return this.shape.getShape().transform(this.transform);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void draw(boolean outline) {
            this.transform.update(2);
            Vector2f translation = this.transform.getTranslation();
            float rotation = this.transform.getRotation();
            float scale = this.transform.getScale();
            GL11.glPushMatrix();
            try {
                GL11.glTranslatef((float)translation.x, (float)translation.y, (float)0.0f);
                GL11.glRotatef((float)FloatMath.toDegrees(rotation), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                this.shape.draw(outline);
            }
            finally {
                GL11.glPopMatrix();
            }
        }
    }

    public static class Global
    extends ShapeConfig {
        @Override
        protected Shape createShape() {
            return com.threerings.tudey.shape.Global.getShape();
        }

        @Override
        protected void draw(boolean outline) {
        }
    }

    public static class None
    extends ShapeConfig {
        @Override
        protected Shape createShape() {
            return new com.threerings.tudey.shape.None(Vector2f.ZERO);
        }

        @Override
        protected void draw(boolean outline) {
            GL11.glBegin((int)0);
            GL11.glVertex2f((float)0.0f, (float)0.0f);
            GL11.glEnd();
        }
    }

    public static class Compound
    extends ShapeConfig {
        @Editable
        public TransformedShape[] shapes = new TransformedShape[0];

        @Override
        public void invalidate() {
            super.invalidate();
            for (TransformedShape tshape : this.shapes) {
                tshape.invalidate();
            }
        }

        @Override
        protected Shape createShape() {
            Shape[] tshapes = new Shape[this.shapes.length];
            for (int ii = 0; ii < this.shapes.length; ++ii) {
                tshapes[ii] = this.shapes[ii].getShape();
            }
            return new com.threerings.tudey.shape.Compound(tshapes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void draw(boolean outline) {
            for (TransformedShape tshape : this.shapes) {
                Transform2D transform = tshape.transform;
                transform.update(2);
                Vector2f translation = transform.getTranslation();
                float rotation = transform.getRotation();
                float scale = transform.getScale();
                GL11.glPushMatrix();
                try {
                    GL11.glTranslatef((float)translation.x, (float)translation.y, (float)0.0f);
                    GL11.glRotatef((float)FloatMath.toDegrees(rotation), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glScalef((float)scale, (float)scale, (float)scale);
                    tshape.shape.draw(outline);
                }
                finally {
                    GL11.glPopMatrix();
                }
            }
        }
    }

    public static class Vertex
    extends DeepObject
    implements Exportable,
    Streamable {
        @Editable(column=true)
        public float x;
        @Editable(column=true)
        public float y;

        public Vector2f createVector() {
            return new Vector2f(this.x, this.y);
        }
    }

    public static class Polygon
    extends ShapeConfig {
        @Editable(editor="table")
        public Vertex[] vertices = new Vertex[0];

        @Override
        protected Shape createShape() {
            Vector2f[] vectors = new Vector2f[this.vertices.length];
            for (int ii = 0; ii < this.vertices.length; ++ii) {
                vectors[ii] = this.vertices[ii].createVector();
            }
            return new com.threerings.tudey.shape.Polygon(vectors);
        }

        @Override
        protected void draw(boolean outline) {
            GL11.glBegin((int)(outline ? 2 : 9));
            for (Vertex vertex : this.vertices) {
                GL11.glVertex2f((float)vertex.x, (float)vertex.y);
            }
            GL11.glEnd();
        }
    }

    public static class Capsule
    extends ShapeConfig {
        @Editable(min=0.0, step=0.01, hgroup="c")
        public float radius = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="c")
        public float length = 1.0f;

        @Override
        protected Shape createShape() {
            float hlength = this.length * 0.5f;
            return new com.threerings.tudey.shape.Capsule(new Vector2f(-hlength, 0.0f), new Vector2f(hlength, 0.0f), this.radius);
        }

        @Override
        protected void draw(boolean outline) {
            float angle;
            int ii;
            float hlength = this.length * 0.5f;
            GL11.glBegin((int)(outline ? 2 : 9));
            int nn = 8;
            for (ii = 0; ii <= nn; ++ii) {
                angle = (float)ii * 0.3926991f + 1.5707964f;
                GL11.glVertex2f((float)(FloatMath.cos(angle) * this.radius - hlength), (float)(FloatMath.sin(angle) * this.radius));
            }
            nn = 8;
            for (ii = 0; ii <= nn; ++ii) {
                angle = (float)ii * 0.3926991f - 1.5707964f;
                GL11.glVertex2f((float)(FloatMath.cos(angle) * this.radius + hlength), (float)(FloatMath.sin(angle) * this.radius));
            }
            GL11.glEnd();
        }
    }

    public static class Circle
    extends ShapeConfig {
        @Editable(min=0.0, step=0.01)
        public float radius = 1.0f;

        @Override
        protected Shape createShape() {
            return new com.threerings.tudey.shape.Circle(Vector2f.ZERO, this.radius);
        }

        @Override
        protected void draw(boolean outline) {
            GL11.glBegin((int)(outline ? 2 : 9));
            for (int ii = 0; ii < 16; ++ii) {
                float angle = (float)ii * 0.3926991f;
                GL11.glVertex2f((float)(FloatMath.cos(angle) * this.radius), (float)(FloatMath.sin(angle) * this.radius));
            }
            GL11.glEnd();
        }
    }

    public static class Rectangle
    extends ShapeConfig {
        @Editable(min=0.0, step=0.01, hgroup="r")
        public float width = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="r")
        public float height = 1.0f;

        @Override
        protected Shape createShape() {
            float hwidth = this.width * 0.5f;
            float hheight = this.height * 0.5f;
            return new com.threerings.tudey.shape.Polygon(new Vector2f(-hwidth, -hheight), new Vector2f(hwidth, -hheight), new Vector2f(hwidth, hheight), new Vector2f(-hwidth, hheight));
        }

        @Override
        protected void draw(boolean outline) {
            float hwidth = this.width * 0.5f;
            float hheight = this.height * 0.5f;
            GL11.glBegin((int)(outline ? 2 : 7));
            GL11.glVertex2f((float)(-hwidth), (float)(-hheight));
            GL11.glVertex2f((float)hwidth, (float)(-hheight));
            GL11.glVertex2f((float)hwidth, (float)hheight);
            GL11.glVertex2f((float)(-hwidth), (float)hheight);
            GL11.glEnd();
        }
    }

    public static class Segment
    extends ShapeConfig {
        @Editable(min=0.0, step=0.01)
        public float length = 1.0f;

        @Override
        protected Shape createShape() {
            float hlength = this.length * 0.5f;
            return new com.threerings.tudey.shape.Segment(new Vector2f(-hlength, 0.0f), new Vector2f(hlength, 0.0f));
        }

        @Override
        protected void draw(boolean outline) {
            float hlength = this.length * 0.5f;
            GL11.glBegin((int)1);
            GL11.glVertex2f((float)(-hlength), (float)0.0f);
            GL11.glVertex2f((float)hlength, (float)0.0f);
            GL11.glEnd();
        }
    }

    public static class Point
    extends ShapeConfig {
        @Override
        protected Shape createShape() {
            return new com.threerings.tudey.shape.Point(Vector2f.ZERO);
        }

        @Override
        protected void draw(boolean outline) {
            GL11.glBegin((int)0);
            GL11.glVertex2f((float)0.0f, (float)0.0f);
            GL11.glEnd();
        }
    }
}

