/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.swing.Spacer;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.CollectionUtil;
import com.samskivert.util.RunAnywhere;
import com.threerings.config.ConfigManager;
import com.threerings.config.tools.ConfigEditor;
import com.threerings.crowd.client.PlaceView;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorMessageBundle;
import com.threerings.editor.tools.BatchValidateDialog;
import com.threerings.export.BinaryExporter;
import com.threerings.export.BinaryImporter;
import com.threerings.export.Exporter;
import com.threerings.export.XMLExporter;
import com.threerings.export.XMLImporter;
import com.threerings.expr.Scoped;
import com.threerings.math.FloatMath;
import com.threerings.math.Ray3D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.media.image.ImageUtil;
import com.threerings.opengl.GlCanvasTool;
import com.threerings.opengl.Log;
import com.threerings.opengl.camera.CameraHandler;
import com.threerings.opengl.camera.MouseOrbiter;
import com.threerings.opengl.camera.OrbitCameraHandler;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.util.Grid;
import com.threerings.opengl.util.SimpleTransformable;
import com.threerings.swing.PrintStreamDialog;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.client.sprite.Sprite;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.AreaDefiner;
import com.threerings.tudey.tools.Arrow;
import com.threerings.tudey.tools.EditorGrid;
import com.threerings.tudey.tools.EditorTool;
import com.threerings.tudey.tools.EntryEdit;
import com.threerings.tudey.tools.Eraser;
import com.threerings.tudey.tools.Eyedropper;
import com.threerings.tudey.tools.GlobalEditor;
import com.threerings.tudey.tools.GroundBrush;
import com.threerings.tudey.tools.Layers;
import com.threerings.tudey.tools.LoadingWindow;
import com.threerings.tudey.tools.Mover;
import com.threerings.tudey.tools.Notepad;
import com.threerings.tudey.tools.Palette;
import com.threerings.tudey.tools.PathDefiner;
import com.threerings.tudey.tools.Placer;
import com.threerings.tudey.tools.Selector;
import com.threerings.tudey.tools.TileBrush;
import com.threerings.tudey.tools.TudeyTool;
import com.threerings.tudey.tools.WallBrush;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.EntryManipulator;
import com.threerings.tudey.util.TudeySceneMetrics;
import com.threerings.util.ToolUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.lwjgl.opengl.GL11;

public class SceneEditor
extends TudeyTool
implements EntryManipulator,
TudeySceneModel.Observer,
KeyEventDispatcher,
MouseListener,
ClipboardOwner {
    public static final Predicate<Object> TILE_ENTRY_FILTER = Predicates.instanceOf(TudeySceneModel.TileEntry.class);
    public static final Predicate<Object> PLACEABLE_ENTRY_FILTER = Predicates.instanceOf(TudeySceneModel.PlaceableEntry.class);
    public static final Predicate<Object> DEFAULT_ENTRY_FILTER = Predicates.and((Predicate)Predicates.instanceOf(TudeySceneModel.Entry.class), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(TudeySceneModel.GlobalEntry.class)));
    public static final Function<TudeySceneModel.Entry, Object> ENTRY_TO_KEY = new Function<TudeySceneModel.Entry, Object>(){

        public Object apply(TudeySceneModel.Entry entry) {
            return entry.getKey();
        }
    };
    protected File _initScene;
    protected UndoManager _undomgr;
    protected UndoableEditSupport _undoSupport;
    protected int _editId;
    protected JMenuItem _revert;
    protected JMenuItem _exportSelection;
    protected Action _undo;
    protected Action _redo;
    protected Action _cut;
    protected Action _copy;
    protected Action _paste;
    protected Action _delete;
    protected JMenu _recents;
    protected JMenuItem _rotateCW;
    protected JMenuItem _rotateCCW;
    protected JMenuItem _raise;
    protected JMenuItem _lower;
    protected JMenuItem _saveToPalette;
    protected JFileChooser _chooser;
    protected JFileChooser _exportChooser;
    protected JFileChooser _selectionChooser;
    protected JSplitPane _pane;
    protected int _divsize;
    protected boolean _compassEnabled;
    protected boolean _gridEnabled;
    protected boolean _testing;
    protected JToolBar _toolbar;
    protected JToggleButton _markers;
    protected JToggleButton _light;
    protected JToggleButton _fog;
    protected JToggleButton _sound;
    protected JToggleButton _control;
    protected JPanel _epanel;
    protected JPanel _opanel;
    protected Map<String, EditorTool> _tools = Maps.newHashMap();
    protected Arrow _arrow;
    protected Selector _selector;
    protected Mover _mover;
    protected Placer _placer;
    protected PathDefiner _pathDefiner;
    protected AreaDefiner _areaDefiner;
    protected GlobalEditor _globalEditor;
    protected TileBrush _tileBrush;
    protected GroundBrush _groundBrush;
    protected WallBrush _wallBrush;
    protected Palette _palette;
    protected JSplitPane _layerSplit;
    protected int _layerDividerPos;
    protected Layers _layers = new Layers(this);
    protected EditorTool _activeTool;
    protected File _file;
    protected TudeySceneModel _scene;
    protected TudeySceneView _view;
    protected int _sceneId;
    @Scoped
    protected boolean _markersVisible = _prefs.getBoolean("markersVisible", true);
    @Scoped
    protected boolean _lightingEnabled = _prefs.getBoolean("lightingEnabled", true);
    @Scoped
    protected boolean _fogEnabled = _prefs.getBoolean("fogEnabled", true);
    @Scoped
    protected boolean _soundEnabled = _prefs.getBoolean("soundEnabled", true);
    @Scoped
    protected boolean _controlEnabled = _prefs.getBoolean("controlEnabled", false);
    protected EditorGrid _grid;
    protected SimpleTransformable _origin;
    protected boolean _shiftDown;
    protected boolean _controlDown;
    protected boolean _altDown;
    protected boolean _firstButtonDown;
    protected boolean _secondButtonDown;
    protected boolean _thirdButtonDown;
    protected TudeySceneModel.Entry[] _selection = new TudeySceneModel.Entry[0];
    protected Vector2f _selectionPivot;
    protected Ray3D _pick = new Ray3D();
    protected Vector3f _pt = new Vector3f();
    protected static Preferences _prefs = Preferences.userNodeForPackage(SceneEditor.class);
    protected static List<String> _recentFiles = Lists.newArrayList((Iterable)Splitter.on((char)'\n').omitEmptyStrings().split((CharSequence)_prefs.get("recent_files", "")));
    protected static final int MAX_RECENT_FILES = 6;
    protected static final Dimension TOOL_BUTTON_SIZE = new Dimension(28, 28);

    public static void main(String[] args) throws Exception {
        new SceneEditor(args.length > 0 ? args[0] : null).startup();
    }

    public SceneEditor(String scene) {
        super("scene");
        if (RunAnywhere.isMacOS()) {
            this.setupMacSupport();
        }
        this._frame.setDefaultCloseOperation(0);
        this._initScene = scene == null ? null : new File(scene);
        this.updateTitle();
        this._undoSupport = new UndoableEditSupport();
        this._undomgr = new UndoManager();
        this._undoSupport.addUndoableEditListener(this._undomgr);
        this._undomgr.setLimit(10000);
        this._undoSupport.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent event) {
                SceneEditor.this.updateUndoActions();
            }
        });
        JMenuBar menubar = new JMenuBar();
        this._frame.setJMenuBar(menubar);
        JMenu file = this.createMenu("file", 70);
        menubar.add(file);
        file.add(this.createMenuItem("new", 78, 78));
        file.add(this.createMenuItem("open", 79, 79));
        this._recents = new JMenu(this._msgs.get("m.recent"));
        file.add(this._recents);
        file.addSeparator();
        file.add(this.createMenuItem("save", 83, 83));
        file.add(this.createMenuItem("save_as", 65, 65));
        this._revert = this.createMenuItem("revert", 82, 82);
        file.add(this._revert);
        this._revert.setEnabled(false);
        file.addSeparator();
        file.add(this.createMenuItem("import", 73, -1));
        file.add(this.createMenuItem("export", 69, -1));
        file.addSeparator();
        file.add(this.createMenuItem("import_selection", 77, -1));
        this._exportSelection = this.createMenuItem("export_selection", 88, -1);
        file.add(this._exportSelection);
        this._exportSelection.setEnabled(false);
        file.addSeparator();
        file.add(this.createMenuItem("test", 84, 66));
        file.addSeparator();
        file.add(this.createMenuItem("quit", 81, 81));
        JMenu edit = this.createMenu("edit", 69);
        menubar.add(edit);
        this._undo = this.createAction("undo", 85, 90);
        edit.add(this._undo);
        this._undo.setEnabled(false);
        this._redo = this.createAction("redo", 82, 89);
        edit.add(this._redo);
        this._redo.setEnabled(false);
        edit.addSeparator();
        this._cut = this.createAction("cut", 84, 88);
        edit.add(new JMenuItem(this._cut));
        this._cut.setEnabled(false);
        this._copy = this.createAction("copy", 67, 67);
        edit.add(new JMenuItem(this._copy));
        this._copy.setEnabled(false);
        this._paste = this.createAction("paste", 80, 86);
        edit.add(new JMenuItem(this._paste));
        this._paste.setEnabled(false);
        this._delete = this.createAction("delete", 68, 127, 0);
        edit.add(new JMenuItem(this._delete));
        this._delete.setEnabled(false);
        edit.addSeparator();
        this._rotateCW = this.createMenuItem("rotate_ccw", 79, 37);
        edit.add(this._rotateCW);
        this._rotateCW.setEnabled(false);
        this._rotateCCW = this.createMenuItem("rotate_cw", 69, 39);
        edit.add(this._rotateCCW);
        this._rotateCCW.setEnabled(false);
        edit.addSeparator();
        this._raise = this.createMenuItem("raise", 65, 38);
        edit.add(this._raise);
        this._raise.setEnabled(false);
        this._lower = this.createMenuItem("lower", 76, 40);
        edit.add(this._lower);
        this._lower.setEnabled(false);
        edit.addSeparator();
        this._saveToPalette = this.createMenuItem("save_to_palette", 86, 76);
        edit.add(this._saveToPalette);
        this._saveToPalette.setEnabled(false);
        edit.addSeparator();
        edit.add(this.createMenuItem("validate_refs", 73, -1));
        edit.add(this.createMenuItem("delete_errors", 69, -1));
        edit.addSeparator();
        edit.add(this.createMenuItem("configs", 78, 71));
        edit.add(this.createMenuItem("resources", 83, 69));
        edit.add(this.createMenuItem("preferences", 70, 80));
        JMenu view = this.createMenu("view", 86);
        menubar.add(view);
        this._showGrid = this.createCheckBoxMenuItem("grid", 71, 68);
        view.add(this._showGrid);
        this._showGrid.setSelected(true);
        this._showCompass = this.createCheckBoxMenuItem("compass", 79, 77);
        view.add(this._showCompass);
        this._showCompass.setSelected(true);
        this._showStats = this.createCheckBoxMenuItem("stats", 83, 84);
        view.add(this._showStats);
        view.addSeparator();
        view.add(this.createMenuItem("refresh", 70, 70));
        view.addSeparator();
        view.add(this.createMenuItem("raise_grid", 82, 38, 0));
        view.add(this.createMenuItem("lower_grid", 76, 40, 0));
        view.addSeparator();
        view.add(this.createMenuItem("reorient", 73, 73));
        view.add(this.createMenuItem("recenter", 67, 67));
        view.addSeparator();
        view.add(this.createMenuItem("prev_layer", 80, 38, 8));
        view.add(this.createMenuItem("next_layer", 78, 40, 8));
        JMenu tools = this.createMenu("tools", 84);
        menubar.add(tools);
        tools.add(this.createMenuItem("batch_validate", 66, -1));
        tools.add(this.createMenuItem("save_snapshot", 123, -1));
        this._chooser = new JFileChooser(_prefs.get("scene_dir", null));
        this._chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null || file.getAbsolutePath() == null) {
                    return false;
                }
                return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".dat") || file.getAbsolutePath().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return SceneEditor.this._msgs.get("m.scene_files");
            }
        });
        this._exportChooser = new JFileChooser(_prefs.get("scene_export_dir", null));
        this._exportChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null || file.getAbsolutePath() == null) {
                    return false;
                }
                return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return SceneEditor.this._msgs.get("m.xml_files");
            }
        });
        this._selectionChooser = new JFileChooser(_prefs.get("selection_dir", null));
        this._selectionChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                return file.isDirectory() || file.toString().toLowerCase().endsWith(".dat") || file.toString().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return SceneEditor.this._msgs.get("m.selection_files");
            }
        });
        this._toolbar.setLayout((LayoutManager)new HGroupLayout(GroupLayout.STRETCH));
        this._toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._toolbar.setFloatable(false);
        this._toolbar.setRollover(true);
        JButton save = this.createIconButton("save");
        this._toolbar.add((Component)save, GroupLayout.FIXED);
        save.setPressedIcon(this.createIcon("save_click"));
        this._toolbar.add((Component)new Spacer(80, 1), GroupLayout.FIXED);
        this._markers = this.createToggleButton("markers");
        this._toolbar.add((Component)this._markers, GroupLayout.FIXED);
        this._markers.setSelected(!this._markersVisible);
        this._light = this.createToggleButton("light");
        this._toolbar.add((Component)this._light, GroupLayout.FIXED);
        this._light.setSelected(!this._lightingEnabled);
        this._fog = this.createToggleButton("fog");
        this._toolbar.add((Component)this._fog, GroupLayout.FIXED);
        this._fog.setSelected(!this._fogEnabled);
        this._sound = this.createToggleButton("sound");
        this._toolbar.add((Component)this._sound, GroupLayout.FIXED);
        this._sound.setSelected(!this._soundEnabled);
        this._control = this.createToggleButton("control");
        this._toolbar.add((Component)this._control, GroupLayout.FIXED);
        this._control.setSelected(!this._controlEnabled);
        this.bindAction(this._control, 87, 0, "control");
        this._toolbar.add((Component)new Spacer(1, 1));
        this._toolbar.add((Component)this.createIconButton("raise_grid"), GroupLayout.FIXED);
        this._toolbar.add((Component)this.createIconButton("lower_grid"), GroupLayout.FIXED);
        this._epanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._epanel.setPreferredSize(new Dimension(350, 1));
        JPanel outer = new JPanel();
        this._epanel.add((Component)outer, GroupLayout.FIXED);
        ButtonGroup tgroup = new ButtonGroup();
        JPanel tpanel = new JPanel(new GridLayout(0, 7, 5, 5));
        outer.add(tpanel);
        this._arrow = new Arrow(this);
        this.addTool(tpanel, tgroup, "arrow", this._arrow);
        this._selector = new Selector(this);
        this.addTool(tpanel, tgroup, "selector", this._selector);
        this._mover = new Mover(this);
        this.addTool(tpanel, tgroup, "mover", this._mover);
        this._placer = new Placer(this);
        this.addTool(tpanel, tgroup, "placer", this._placer);
        this._pathDefiner = new PathDefiner(this);
        this.addTool(tpanel, tgroup, "path_definer", this._pathDefiner);
        this._areaDefiner = new AreaDefiner(this);
        this.addTool(tpanel, tgroup, "area_definer", this._areaDefiner);
        this._globalEditor = new GlobalEditor(this, this._layers);
        this.addTool(tpanel, tgroup, "global_editor", this._globalEditor);
        this._tileBrush = new TileBrush(this);
        this.addTool(tpanel, tgroup, "tile_brush", this._tileBrush);
        this._groundBrush = new GroundBrush(this);
        this.addTool(tpanel, tgroup, "ground_brush", this._groundBrush);
        this._wallBrush = new WallBrush(this);
        this.addTool(tpanel, tgroup, "wall_brush", this._wallBrush);
        this._palette = new Palette(this);
        this.addTool(tpanel, tgroup, "palette", this._palette);
        this.addTool(tpanel, tgroup, "eyedropper", new Eyedropper(this));
        this.addTool(tpanel, tgroup, "eraser", new Eraser(this));
        this.addTool(tpanel, tgroup, "notepad", new Notepad(this));
        this._opanel = GroupLayout.makeVStretchBox((int)5);
        this._tools.put("layers", this._layers);
        this._layerSplit = new JSplitPane(0, this._layers, this._opanel);
        this._epanel.add(this._layerSplit);
        this._layerSplit.setBorder(BorderFactory.createEmptyBorder());
        this.setActiveTool(this._arrow);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this._canvas.addMouseListener(this);
    }

    protected void setupMacSupport() {
        Application app = Application.getApplication();
        if (app == null) {
            return;
        }
        app.removeAboutMenuItem();
        app.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void handleQuit(ApplicationEvent event) {
                event.setHandled(false);
                SceneEditor.this.shutdown();
            }
        });
    }

    public TudeySceneView getView() {
        return this._view;
    }

    public EditorGrid getGrid() {
        return this._grid;
    }

    public boolean isShiftDown() {
        return this._shiftDown;
    }

    public boolean isSpecialDown() {
        return this.isControlDown() || this.isAltDown();
    }

    public boolean isControlDown() {
        return this._controlDown || this._control.isSelected();
    }

    public boolean isAltDown() {
        return this._altDown;
    }

    public boolean isFirstButtonDown() {
        return this._firstButtonDown;
    }

    public boolean isSecondButtonDown() {
        return this._secondButtonDown;
    }

    public boolean isThirdButtonDown() {
        return this._thirdButtonDown;
    }

    public void clearSelection() {
        this.setSelection(new TudeySceneModel.Entry[0]);
    }

    public Predicate<TudeySceneModel.Entry> getLayerPredicate() {
        return new Predicate<TudeySceneModel.Entry>(){

            public boolean apply(TudeySceneModel.Entry entry) {
                return SceneEditor.this._layers.getSelectedLayer() == SceneEditor.this._scene.getLayer(entry.getKey());
            }
        };
    }

    public Predicate<TudeySceneModel.Entry> getVisiblePredicate() {
        final List<Boolean> vis = this._layers.getLayerVisibility();
        return new Predicate<TudeySceneModel.Entry>(){

            public boolean apply(TudeySceneModel.Entry entry) {
                return (Boolean)vis.get(SceneEditor.this._scene.getLayer(entry.getKey()));
            }
        };
    }

    public void select(TudeySceneModel.Entry ... selection) {
        if (selection.length > 1) {
            this.setActiveTool(this._selector);
        } else if (selection.length > 0) {
            this.setActiveTool(this._arrow);
            this._arrow.edit(selection[0]);
            return;
        }
        this.setSelection(selection);
    }

    public void setSelection(TudeySceneModel.Entry ... selection) {
        EntrySprite sprite;
        for (TudeySceneModel.Entry entry : this._selection) {
            sprite = this._view.getEntrySprite(entry.getKey());
            if (sprite == null) continue;
            sprite.setSelected(false);
        }
        this._selection = selection;
        for (TudeySceneModel.Entry entry : selection) {
            sprite = this._view.getEntrySprite(entry.getKey());
            if (sprite != null) {
                sprite.setSelected(true);
                continue;
            }
            Log.log.warning((Object)"Missing sprite for selected entry.", new Object[]{"entry", entry});
        }
        this._selectionPivot = null;
        boolean enable = selection.length > 0;
        this._exportSelection.setEnabled(enable);
        this._cut.setEnabled(enable);
        this._copy.setEnabled(enable);
        this._delete.setEnabled(enable);
        this._rotateCW.setEnabled(enable);
        this._rotateCCW.setEnabled(enable);
        this._raise.setEnabled(enable);
        this._lower.setEnabled(enable);
        this._saveToPalette.setEnabled(enable);
    }

    public TudeySceneModel.Entry[] getSelection() {
        return this._selection;
    }

    public boolean isSelected(TudeySceneModel.Entry entry) {
        return this.getSelectionIndex(entry) != -1;
    }

    public void editMouseEntry() {
        TudeySceneModel.Entry entry = this.getMouseEntry(DEFAULT_ENTRY_FILTER);
        if (entry != null) {
            this.setActiveTool(this._arrow);
            this._arrow.edit(entry);
        }
    }

    public void deleteMouseEntry() {
        this.deleteMouseEntry(DEFAULT_ENTRY_FILTER);
    }

    public void deleteMouseEntry(Predicate<? super TudeySceneModel.Entry> filter) {
        TudeySceneModel.Entry entry = this.getMouseEntry(filter);
        if (entry != null) {
            this.removeEntries(entry.getKey());
        }
    }

    public void useMouseEntry() {
        TudeySceneModel.Entry entry = this.getMouseEntry();
        if (entry instanceof TudeySceneModel.PlaceableEntry) {
            this.setActiveTool(this._placer);
            TudeySceneModel.PlaceableEntry pentry = (TudeySceneModel.PlaceableEntry)entry;
            this._placer.setReference(pentry.placeable);
            pentry.transform.update(1);
            this._placer.setAngle(pentry.transform.getRotation().getRotationZ());
        } else if (entry instanceof TudeySceneModel.AreaEntry) {
            this.setActiveTool(this._areaDefiner);
            this._areaDefiner.setReference(((TudeySceneModel.AreaEntry)entry).area);
        } else if (entry instanceof TudeySceneModel.PathEntry) {
            this.setActiveTool(this._pathDefiner);
            this._pathDefiner.setReference(((TudeySceneModel.PathEntry)entry).path);
        } else if (entry instanceof TudeySceneModel.TileEntry) {
            this.setActiveTool(this._tileBrush);
            TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
            this._tileBrush.setReference(tentry.tile);
            this._tileBrush.setRotation(tentry.rotation);
        }
    }

    public TudeySceneModel.Entry getMouseEntry() {
        return this.getMouseEntry(DEFAULT_ENTRY_FILTER);
    }

    public TudeySceneModel.Entry getMouseEntry(Predicate<? super TudeySceneModel.Entry> filter) {
        if (!this.getMouseRay(this._pick)) {
            return null;
        }
        final Predicate pred = Predicates.and(this.getLayerPredicate(), filter);
        System.out.println("_view=" + this._view.toString());
        EntrySprite sprite = (EntrySprite)this._view.getIntersection(this._pick, this._pt, (Predicate<? super Sprite>)new Predicate<Sprite>(){

            public boolean apply(Sprite sprite) {
                return sprite instanceof EntrySprite && pred.apply((Object)((EntrySprite)sprite).getEntry());
            }
        });
        return sprite == null ? null : sprite.getEntry();
    }

    public void moveSelection() {
        this.removeAndMove(this._selection);
    }

    public void removeAndMove(TudeySceneModel.Entry ... entries) {
        this.incrementEditId();
        this.removeEntries(Arrays.asList(entries));
        this.move(entries);
    }

    public void move(TudeySceneModel.Entry ... entries) {
        this.setActiveTool(this._mover);
        this._mover.move(entries);
    }

    public void incrementEditId() {
        ++this._editId;
    }

    public void overwriteEntries(TudeySceneModel.Entry ... entries) {
        HashSet toRemoveKeys = Sets.newHashSet();
        ArrayList temp = Lists.newArrayList();
        for (TudeySceneModel.Entry entry : entries) {
            if (!(entry instanceof TudeySceneModel.TileEntry)) continue;
            TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
            TileConfig.Original config = tentry.getConfig(this.getConfigManager());
            Rectangle region = new Rectangle();
            tentry.getRegion(config, region);
            this._scene.getTileEntries(region, temp);
            toRemoveKeys.addAll(Collections2.transform((Collection)temp, ENTRY_TO_KEY));
            temp.clear();
        }
        this.removeEntries(toRemoveKeys.toArray());
        this.addEntries(entries);
    }

    @Override
    public void addEntries(TudeySceneModel.Entry ... entries) {
        if (entries.length == 0) {
            return;
        }
        for (TudeySceneModel.Entry entry : entries) {
            if (!(entry instanceof TudeySceneModel.TileEntry)) continue;
            this.clearPaint((TudeySceneModel.TileEntry)entry);
            this._layers.setSelectedLayer(0);
        }
        this._undoSupport.postEdit(new EntryEdit(this._scene, this._editId, this._layers.getSelectedLayer(), entries, new TudeySceneModel.Entry[0], new Object[0]));
    }

    @Override
    public void updateEntries(TudeySceneModel.Entry ... entries) {
        if (entries.length == 0) {
            return;
        }
        for (TudeySceneModel.Entry entry : entries) {
            if (!(entry instanceof TudeySceneModel.TileEntry)) continue;
            this.clearPaint((TudeySceneModel.TileEntry)this._scene.getEntry(entry.getKey()));
            this.clearPaint((TudeySceneModel.TileEntry)entry);
            this._layers.setSelectedLayer(0);
        }
        this._undoSupport.postEdit(new EntryEdit(this._scene, this._editId, this._layers.getSelectedLayer(), new TudeySceneModel.Entry[0], entries, new Object[0]));
    }

    @Override
    public void removeEntries(Object ... keys) {
        if (keys.length == 0) {
            return;
        }
        for (Object key : keys) {
            if (!(key instanceof Coord)) continue;
            this.clearPaint((TudeySceneModel.TileEntry)this._scene.getEntry(key));
            this._layers.setSelectedLayer(0);
        }
        this._undoSupport.postEdit(new EntryEdit(this._scene, this._editId, this._layers.getSelectedLayer(), new TudeySceneModel.Entry[0], new TudeySceneModel.Entry[0], keys));
    }

    @Override
    public void removeEntries(Collection<? extends TudeySceneModel.Entry> coll) {
        this.removeEntries(Collections2.transform(coll, ENTRY_TO_KEY).toArray());
    }

    @Override
    public void setPaint(Rectangle region, TudeySceneModel.Paint paint) {
        this._undoSupport.postEdit(new EntryEdit(this._scene, this._editId, this._layers.getSelectedLayer(), region, paint));
    }

    @Override
    public void entryAdded(TudeySceneModel.Entry entry) {
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        int idx = this.getSelectionIndex(oentry);
        if (idx != -1) {
            this._selection[idx] = nentry;
        }
    }

    @Override
    public void entryRemoved(TudeySceneModel.Entry oentry) {
        int idx = this.getSelectionIndex(oentry);
        if (idx != -1) {
            this.setSelection((TudeySceneModel.Entry[])ArrayUtil.splice((Object[])this._selection, (int)idx, (int)1));
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean pressed;
        int id = event.getID();
        if (id == 401) {
            pressed = true;
        } else if (id == 402) {
            pressed = false;
        } else {
            return false;
        }
        switch (event.getKeyCode()) {
            case 16: {
                this._shiftDown = pressed;
                break;
            }
            case 17: {
                this._controlDown = pressed;
                break;
            }
            case 18: {
                this._altDown = pressed;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        TudeySceneModel.Entry entry;
        if (this.mouseCameraEnabled() && event.getButton() == 1 && event.getClickCount() == 2) {
            this.editMouseEntry();
        }
        if (this._testing && event.getButton() == 3 && this.getMouseRay(this._pick) && (entry = this.getMouseEntry()) != null) {
            Rect result = new Rect();
            entry.getBounds(this._cfgmgr, result);
            System.out.println("editor:" + this._pick + "," + result.getCenter() + "," + this._pt);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if ((event.getModifiersEx() & 0x200) != 0) {
            this.useMouseEntry();
        }
        switch (event.getButton()) {
            case 1: {
                this._firstButtonDown = true;
                break;
            }
            case 2: {
                this._secondButtonDown = true;
                break;
            }
            case 3: {
                this._thirdButtonDown = true;
            }
        }
        this.incrementEditId();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        switch (event.getButton()) {
            case 1: {
                this._firstButtonDown = false;
                break;
            }
            case 2: {
                this._secondButtonDown = false;
                break;
            }
            case 3: {
                this._thirdButtonDown = false;
            }
        }
        this.incrementEditId();
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this._paste.setEnabled(false);
    }

    @Override
    public ConfigManager getConfigManager() {
        return this._scene == null ? this._cfgmgr : this._scene.getConfigManager();
    }

    @Override
    public void setPlaceView(PlaceView view) {
        super.setPlaceView(view);
        this._testing = true;
        if (this._activeTool != null) {
            this._activeTool.deactivate();
        }
        this._frame.getJMenuBar().setVisible(false);
        this._divsize = this._pane.getDividerSize();
        this._gridEnabled = this._showGrid.isSelected();
        this._showGrid.setSelected(false);
        this._compassEnabled = this._showCompass.isSelected();
        this._showCompass.setSelected(false);
        this._pane.setDividerSize(0);
        this._toolbar.setVisible(false);
        this._epanel.setVisible(false);
        SwingUtil.refresh((JComponent)((JComponent)this._frame.getContentPane()));
    }

    @Override
    public void clearPlaceView(PlaceView view) {
        this.setView(this._view);
        this._testing = false;
        if (this._activeTool != null) {
            this._activeTool.activate();
        }
        this._frame.getJMenuBar().setVisible(true);
        this._pane.setDividerSize(this._divsize);
        this._showGrid.setSelected(this._gridEnabled);
        this._showCompass.setSelected(this._compassEnabled);
        this._toolbar.setVisible(true);
        this._epanel.setVisible(true);
        this._pane.resetToPreferredSizes();
        SwingUtil.refresh((JComponent)((JComponent)this._frame.getContentPane()));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        EditorTool tool = this._tools.get(action);
        if (tool != null) {
            this.setActiveTool(tool);
            return;
        }
        if (action.equals("new")) {
            if (this.saveWarning("clear the scene")) {
                this.newScene();
            }
        } else if (action.equals("open")) {
            if (this.saveWarning("open a new scene")) {
                this.open();
            }
        } else if (action.equals("save")) {
            if (this._file != null) {
                this.save(this._file);
            } else {
                this.save();
            }
        } else if (action.equals("save_as")) {
            this.save();
        } else if (action.equals("revert")) {
            if (this.saveWarning("revert to the last saved version")) {
                this.open(this._file);
            }
        } else if (action.equals("import")) {
            this.importScene();
        } else if (action.equals("export")) {
            this.exportScene();
        } else if (action.equals("import_selection")) {
            this.importSelection();
        } else if (action.equals("export_selection")) {
            this.exportSelection();
        } else if (action.equals("test")) {
            this.testScene();
        } else if (action.equals("undo")) {
            this._undomgr.undo();
            this.updateUndoActions();
        } else if (action.equals("redo")) {
            this._undomgr.redo();
            this.updateUndoActions();
        } else if (action.equals("cut")) {
            this.copySelection();
            this.deleteSelection();
        } else if (action.equals("copy")) {
            this.copySelection();
        } else if (action.equals("paste")) {
            Transferable contents = this._frame.getToolkit().getSystemClipboard().getContents(this);
            TudeySceneModel.Entry[] selection = (TudeySceneModel.Entry[])ToolUtil.getWrappedTransferData(contents);
            if (selection != null) {
                this.move(selection);
            }
        } else if (action.equals("delete")) {
            this.deleteSelection();
        } else if (action.equals("rotate_ccw")) {
            this.rotateSelection(1);
        } else if (action.equals("rotate_cw")) {
            this.rotateSelection(-1);
        } else if (action.equals("raise")) {
            this.raiseSelection(1);
        } else if (action.equals("lower")) {
            this.raiseSelection(-1);
        } else if (action.equals("save_to_palette")) {
            this.setActiveTool(this._palette);
            this._palette.add(this._selection);
        } else if (action.equals("validate_refs")) {
            this.validateReferences();
        } else if (action.equals("delete_errors")) {
            this.deleteErrors();
        } else if (action.equals("configs")) {
            new ConfigEditor(this._msgmgr, this._scene.getConfigManager(), this._colorpos).setVisible(true);
        } else if (action.equals("raise_grid")) {
            this._grid.setElevation(this._grid.getElevation() + 1);
        } else if (action.equals("lower_grid")) {
            this._grid.setElevation(this._grid.getElevation() - 1);
        } else if (action.equals("reorient")) {
            ((OrbitCameraHandler)this._camhand).getCoords().set(TudeySceneMetrics.getDefaultCameraConfig().coords);
        } else if (action.equals("next_layer")) {
            this._layers.selectLayer(true);
        } else if (action.equals("prev_layer")) {
            this._layers.selectLayer(false);
        } else if (action.equals("markers")) {
            this._markersVisible = !this._markers.isSelected();
            _prefs.putBoolean("markersVisible", this._markersVisible);
            this.wasUpdated();
        } else if (action.equals("light")) {
            this._lightingEnabled = !this._light.isSelected();
            _prefs.putBoolean("lightingEnabled", this._lightingEnabled);
            this.wasUpdated();
        } else if (action.equals("fog")) {
            this._fogEnabled = !this._fog.isSelected();
            _prefs.putBoolean("fogEnabled", this._fogEnabled);
            this.wasUpdated();
        } else if (action.equals("sound")) {
            this._soundEnabled = !this._sound.isSelected();
            _prefs.putBoolean("soundEnabled", this._soundEnabled);
            this.wasUpdated();
        } else if (action.equals("control")) {
            this._controlEnabled = !this._control.isSelected();
            _prefs.putBoolean("controlEnabled", this._controlEnabled);
            this.wasUpdated();
        } else if (action.equals("batch_validate")) {
            new BatchValidateDialog(this, this._frame, _prefs){

                @Override
                protected boolean validate(String path, PrintStream out) throws Exception {
                    TudeySceneModel model = (TudeySceneModel)new BinaryImporter(new FileInputStream(SceneEditor.this._rsrcmgr.getResourceFile(path))).readObject();
                    model.getConfigManager().init("scene", SceneEditor.this._cfgmgr);
                    return model.validateReferences(path, out);
                }
            }.setVisible(true);
        } else if (action.equals("save_snapshot")) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            File file = new File("./snapshot", "viewer_" + fmt.format(new Date()) + ".png");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                ImageIO.write((RenderedImage)this.createSnapshot(true), "png", file);
                Log.log.info((Object)"write snapshot.", new Object[]{"file", file});
            }
            catch (IOException e) {
                Log.log.warning((Object)"Failed to write snapshot.", new Object[]{"file", file, e});
            }
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void shutdown() {
        if (this.saveWarning("quit")) {
            super.shutdown();
        }
    }

    @Override
    protected JComponent createCanvasContainer() {
        JPanel ccont = new JPanel(new BorderLayout());
        this._toolbar = new JToolBar();
        ccont.add((Component)this._toolbar, "North");
        ccont.add(this._canvas, "Center");
        this._epanel = GroupLayout.makeVStretchBox((int)5);
        this._pane = new JSplitPane(1, true, ccont, this._epanel);
        this._canvas.setMinimumSize(new Dimension(1, 1));
        this._canvas.setPreferredSize(new Dimension(1, 1));
        this._pane.setResizeWeight(1.0);
        this._pane.setOneTouchExpandable(true);
        JPanel bcomp = this._canvas instanceof JComponent ? (JComponent)this._canvas : ccont;
        this.bindAction(bcomp, 38, 0, "raise_grid");
        this.bindAction(bcomp, 40, 0, "lower_grid");
        return this._pane;
    }

    @Override
    protected Grid createGrid() {
        this._grid = new EditorGrid(this);
        return this._grid;
    }

    @Override
    protected GlCanvasTool.CanvasToolPrefs createEditablePrefs() {
        return new SceneEditorPrefs(_prefs);
    }

    @Override
    protected CameraHandler createCameraHandler() {
        return new OrbitCameraHandler(this);
    }

    @Override
    protected void didInit() {
        super.didInit();
        this._view = new TudeySceneView(this){

            @Override
            protected Window maybeCreateLoadingWindow(TudeySceneModel model) {
                return new LoadingWindow(this._ctx, this);
            }

            @Override
            public void wasRemoved() {
                this._ctx.getRoot().removeWindow(this._inputWindow);
                if (this._loadingWindow != null) {
                    this._ctx.getRoot().removeWindow(this._loadingWindow);
                    this._loadingWindow = null;
                }
                if (this._ctrl != null) {
                    this._ctrl.wasRemoved();
                }
                this._scene.clearEffects();
            }

            @Override
            protected OrbitCameraHandler createCameraHandler() {
                OrbitCameraHandler camhand = new OrbitCameraHandler(this._ctx){

                    @Override
                    public void updatePosition() {
                        this._target.z = SceneEditor.this._grid.getZ();
                        super.updatePosition();
                    }
                };
                new MouseOrbiter(camhand, true){

                    @Override
                    public void mouseDragged(MouseEvent event) {
                        if (SceneEditor.this.mouseCameraEnabled()) {
                            super.mouseDragged(event);
                        } else {
                            super.mouseMoved(event);
                        }
                    }

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent event) {
                        if (SceneEditor.this.mouseCameraEnabled()) {
                            super.mouseWheelMoved(event);
                        }
                    }
                }.addTo(SceneEditor.this._canvas);
                return camhand;
            }

            @Override
            protected int getMergeGranularity() {
                return 0;
            }
        };
        this.setView(this._view);
        for (EditorTool tool : this._tools.values()) {
            tool.init();
        }
        this._origin = new SimpleTransformable(this, "Opaque", 0, false, 2){

            @Override
            protected void draw() {
                float z = SceneEditor.this._grid.getZ() + 0.01f;
                GL11.glBegin((int)1);
                GL11.glVertex3f((float)-1.0f, (float)0.0f, (float)z);
                GL11.glVertex3f((float)1.0f, (float)0.0f, (float)z);
                GL11.glVertex3f((float)0.0f, (float)-1.0f, (float)z);
                GL11.glVertex3f((float)0.0f, (float)1.0f, (float)z);
                GL11.glEnd();
            }
        };
        this._origin.getStates()[2] = ColorState.getInstance(Color4f.RED);
        if (this._initScene != null) {
            this.open(this._initScene);
        } else {
            this.newScene();
        }
    }

    @Override
    protected void updateView(float elapsed) {
        super.updateView(elapsed);
        if (!this._testing) {
            this._activeTool.tick(elapsed);
            this._grid.tick(elapsed);
        }
    }

    @Override
    protected void compositeView() {
        super.compositeView();
        if (this._showGrid.isSelected()) {
            this._origin.composite();
        }
        if (!this._testing) {
            this._activeTool.composite();
        }
    }

    protected void addTool(JPanel tpanel, ButtonGroup tgroup, String name, EditorTool tool) {
        JToggleButton button = this.createToggleButton(name);
        tpanel.add(button);
        tgroup.add(button);
        this._tools.put(name, tool);
        tool.setButton(button);
    }

    protected JButton createIconButton(String name) {
        JButton button = new JButton(this.createIcon(name));
        button.setMinimumSize(TOOL_BUTTON_SIZE);
        button.setMaximumSize(TOOL_BUTTON_SIZE);
        button.setPreferredSize(TOOL_BUTTON_SIZE);
        button.setActionCommand(name);
        button.addActionListener(this);
        return button;
    }

    protected JToggleButton createToggleButton(String name) {
        JToggleButton button = new JToggleButton(this.createIcon(name));
        button.setSelectedIcon(this.createIcon(name + "_select"));
        button.setMinimumSize(TOOL_BUTTON_SIZE);
        button.setMaximumSize(TOOL_BUTTON_SIZE);
        button.setPreferredSize(TOOL_BUTTON_SIZE);
        button.setActionCommand(name);
        button.addActionListener(this);
        return button;
    }

    protected ImageIcon createIcon(String name) {
        BufferedImage image;
        try {
            image = this._rsrcmgr.getImageResource("media/tudey/" + name + ".png");
        }
        catch (IOException e) {
            Log.log.warning((Object)"Error loading image.", new Object[]{"name", name, e});
            image = ImageUtil.createErrorImage((int)24, (int)24);
        }
        return new ImageIcon(image);
    }

    protected void setActiveTool(EditorTool tool) {
        boolean forceBase;
        boolean hideLayers;
        if (this._activeTool == tool) {
            return;
        }
        if (this._activeTool != null) {
            this._activeTool.deactivate();
            this._opanel.remove(this._activeTool);
        }
        if ((this._activeTool = tool) != null) {
            this._opanel.add(this._activeTool);
            this._activeTool.activate();
        }
        if (hideLayers = tool instanceof Notepad) {
            if (this._layers.isVisible()) {
                this._layerDividerPos = this._layerSplit.getDividerLocation();
                this._layers.setVisible(false);
            }
        } else {
            this._layers.setVisible(true);
            if (this._layerDividerPos != 0) {
                this._layerSplit.setDividerLocation(this._layerDividerPos);
            }
        }
        boolean bl = forceBase = tool == this._tileBrush || tool == this._groundBrush || tool == this._wallBrush;
        if (forceBase) {
            this._layers.setSelectedLayer(0);
        }
        SwingUtil.refresh((JComponent)this._opanel);
    }

    protected void bindAction(final JComponent comp, int keyCode, int modifiers, final String action) {
        comp.getInputMap().put(KeyStroke.getKeyStroke(keyCode, modifiers), action);
        comp.getActionMap().put(action, new AbstractAction(action){

            @Override
            public void actionPerformed(ActionEvent event) {
                SceneEditor.this.actionPerformed(new ActionEvent(comp, 1001, action));
            }
        });
    }

    protected boolean mouseCameraEnabled() {
        return !this._testing && (this._activeTool.allowsMouseCamera() || this.isControlDown());
    }

    protected void newScene() {
        this.setScene(new TudeySceneModel());
        this.setFile(null);
    }

    protected void open() {
        if (this._chooser.showOpenDialog(this._frame) == 0) {
            this.open(this._chooser.getSelectedFile());
        }
        _prefs.put("scene_dir", this._chooser.getCurrentDirectory().toString());
    }

    protected void open(File file) {
        try {
            if (file.toString().endsWith(".dat") || file.toString().indexOf(".") < 0) {
                BinaryImporter in = new BinaryImporter(new FileInputStream(file));
                this.setScene((TudeySceneModel)in.readObject());
                in.close();
            } else if (file.toString().endsWith(".xml")) {
                XMLImporter in = new XMLImporter(new FileInputStream(file));
                this.setScene((TudeySceneModel)in.readObject());
                in.close();
            }
            this.setFile(file);
        }
        catch (IOException e) {
            Log.log.warning((Object)("Failed to open scene [file=" + file + "]."), new Object[]{e});
        }
    }

    protected void save() {
        if (this._chooser.showSaveDialog(this._frame) == 0) {
            this.save(this._chooser.getSelectedFile());
        }
        _prefs.put("scene_dir", this._chooser.getCurrentDirectory().toString());
    }

    protected void save(File file) {
        Exporter out = null;
        try {
            if (file != null) {
                out = file.getName().endsWith(".xml") ? new XMLExporter(new FileOutputStream(file)) : new BinaryExporter(new FileOutputStream(file));
            } else {
                return;
            }
            ++this._scene.version;
            out.writeObject(this._scene);
            out.close();
            this.setFile(file);
            this._scene.setDirty(false);
        }
        catch (IOException e) {
            Log.log.warning((Object)("Failed to save scene [file=" + file + "]."), new Object[]{e});
        }
    }

    protected void importScene() {
        if (this._exportChooser.showOpenDialog(this._frame) == 0) {
            File file = this._exportChooser.getSelectedFile();
            try {
                XMLImporter in = new XMLImporter(new FileInputStream(file));
                this.setScene((TudeySceneModel)in.readObject());
                in.close();
                this.setFile(null);
            }
            catch (IOException e) {
                Log.log.warning((Object)("Failed to import scene [file=" + file + "]."), new Object[]{e});
            }
        }
        _prefs.put("scene_export_dir", this._exportChooser.getCurrentDirectory().toString());
    }

    protected void setScene(TudeySceneModel scene) {
        if (this._scene != null) {
            this._scene.removeObserver(this);
        }
        this._scene = scene;
        this._scene.addObserver(this);
        this._scene.init(this._cfgmgr);
        this._view.setSceneModel(this._scene);
        for (EditorTool tool : this._tools.values()) {
            tool.sceneChanged(scene);
        }
        this.clearSelection();
        this._undomgr.discardAllEdits();
        this.updateUndoActions();
    }

    protected void updateUndoActions() {
        this._undo.setEnabled(this._undomgr.canUndo());
        this._redo.setEnabled(this._undomgr.canRedo());
    }

    protected void exportScene() {
        if (this._exportChooser.showSaveDialog(this._frame) == 0) {
            File file = this._exportChooser.getSelectedFile();
            try {
                XMLExporter out = new XMLExporter(new FileOutputStream(file));
                out.writeObject(this._scene);
                out.close();
            }
            catch (IOException e) {
                Log.log.warning((Object)("Failed to export scene [file=" + file + "]."), new Object[]{e});
            }
        }
        _prefs.put("scene_export_dir", this._exportChooser.getCurrentDirectory().toString());
    }

    protected void importSelection() {
        if (this._selectionChooser.showOpenDialog(this._frame) == 0) {
            File file = this._selectionChooser.getSelectedFile();
            try {
                if (file.toString().endsWith(".dat")) {
                    BinaryImporter in = new BinaryImporter(new FileInputStream(file));
                    this.move((TudeySceneModel.Entry[])in.readObject());
                    in.close();
                } else if (file.toString().endsWith(".xml")) {
                    XMLImporter in = new XMLImporter(new FileInputStream(file));
                    this.move((TudeySceneModel.Entry[])in.readObject());
                    in.close();
                }
            }
            catch (IOException e) {
                Log.log.warning((Object)("Failed to import selection [file=" + file + "]."), new Object[]{e});
            }
        }
        _prefs.put("selection_dir", this._selectionChooser.getCurrentDirectory().toString());
    }

    protected void exportSelection() {
        if (this._selectionChooser.showSaveDialog(this._frame) == 0) {
            File file = this._selectionChooser.getSelectedFile();
            try {
                BinaryExporter out = new BinaryExporter(new FileOutputStream(file));
                out.writeObject(this._selection);
                out.close();
            }
            catch (IOException e) {
                Log.log.warning((Object)("Failed to export selection [file=" + file + "]."), new Object[]{e});
            }
        }
        _prefs.put("selection_dir", this._selectionChooser.getCurrentDirectory().toString());
    }

    protected void setFile(File file) {
        this._file = file;
        this._revert.setEnabled(file != null);
        this.updateTitle();
        if (file != null) {
            String name = file.getPath();
            _recentFiles.remove(name);
            _recentFiles.add(0, name);
            CollectionUtil.limit(_recentFiles, (int)6);
            _prefs.put("recent_files", Joiner.on((char)'\n').join(_recentFiles));
        }
        this._recents.removeAll();
        for (String recent : _recentFiles) {
            final File recentFile = new File(recent);
            AbstractAction action = new AbstractAction(recentFile.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SceneEditor.this.open(recentFile);
                }
            };
            action.putValue("ShortDescription", recentFile.getPath());
            this._recents.add(new JMenuItem(action));
        }
    }

    protected void updateTitle() {
        String title = this._msgs.get("m.title");
        if (this._file != null) {
            title = title + ": " + this._file;
        }
        this._frame.setTitle(title);
    }

    protected void testScene() {
        TudeySceneModel scene = this._scene.clone();
        scene.init(this._scene.getConfigManager());
        ArrayList toRemove = Lists.newArrayList();
        List<Boolean> visibility = this._layers.getLayerVisibility();
        for (TudeySceneModel.Entry entry : scene.getEntries()) {
            Object key = entry.getKey();
            if (visibility.get(scene.getLayer(key)).booleanValue()) continue;
            toRemove.add(key);
        }
        for (TudeySceneModel.Entry key : toRemove) {
            scene.removeEntry(key);
        }
        scene.sceneId = ++this._sceneId;
        this._server.getSceneRepository().setSceneModel(scene);
        this._scenedir.moveTo(this._sceneId);
    }

    protected void deleteSelection() {
        this.incrementEditId();
        this.removeEntries(Arrays.asList(this._selection));
    }

    protected void rotateSelection(int amount) {
        if (this._selectionPivot == null) {
            Rect bounds = new Rect();
            Rect ebounds = new Rect();
            boolean tiles = false;
            for (TudeySceneModel.Entry entry : this._selection) {
                tiles |= entry instanceof TudeySceneModel.TileEntry;
                entry.getBounds(this.getConfigManager(), ebounds);
                bounds.addLocal(ebounds);
            }
            Vector2f center = bounds.getCenter();
            if (tiles) {
                Vector2f ci = new Vector2f(Math.round(center.x), Math.round(center.y));
                Vector2f cm = new Vector2f(FloatMath.floor(center.x) + 0.5f, FloatMath.floor(center.y) + 0.5f);
                center = center.distance(ci) < center.distance(cm) ? ci : cm;
            }
            this._selectionPivot = center;
        }
        float rotation = 1.5707964f * (float)amount;
        Vector2f translation = this._selectionPivot.subtract(this._selectionPivot.rotate(rotation));
        Transform2D xform = new Transform2D(translation, rotation);
        Vector2f opivot = this._selectionPivot;
        this.transformSelection(new Transform3D(xform));
        this._selectionPivot = opivot;
    }

    protected void raiseSelection(int amount) {
        Transform3D xform = new Transform3D(1);
        xform.getTranslation().z = TudeySceneMetrics.getTileZ(amount);
        this.transformSelection(xform);
        this._grid.setElevation(this._grid.getElevation() + amount);
    }

    protected void transformSelection(Transform3D xform) {
        this.incrementEditId();
        ArrayList removes = Lists.newArrayList();
        ArrayList updates = Lists.newArrayList();
        ArrayList overwrites = Lists.newArrayList();
        TudeySceneModel.Entry[] oselection = this._selection;
        TudeySceneModel.Entry[] nselection = new TudeySceneModel.Entry[oselection.length];
        for (int ii = 0; ii < oselection.length; ++ii) {
            TudeySceneModel.Entry oentry = oselection[ii];
            TudeySceneModel.Entry nentry = nselection[ii] = (TudeySceneModel.Entry)oentry.clone();
            nentry.transform(this.getConfigManager(), xform);
            Object okey = oentry.getKey();
            Object nkey = nentry.getKey();
            if (!okey.equals(nkey)) {
                removes.add(okey);
                overwrites.add(nentry);
                continue;
            }
            updates.add(nentry);
        }
        this.removeEntries(removes.toArray());
        this.updateEntries(updates.toArray(new TudeySceneModel.Entry[updates.size()]));
        this.overwriteEntries(overwrites.toArray(new TudeySceneModel.Entry[overwrites.size()]));
        this.setSelection(nselection);
    }

    protected void copySelection() {
        TudeySceneModel.Entry[] selection = new TudeySceneModel.Entry[this._selection.length];
        for (int ii = 0; ii < this._selection.length; ++ii) {
            selection[ii] = (TudeySceneModel.Entry)this._selection[ii].clone();
        }
        Clipboard clipboard = this._frame.getToolkit().getSystemClipboard();
        clipboard.setContents(new ToolUtil.WrappedTransfer(selection), this);
        this._paste.setEnabled(true);
    }

    protected void validateReferences() {
        PrintStreamDialog dialog = new PrintStreamDialog((Frame)this._frame, this._msgs.get("m.validate_refs"), this._msgs.get("m.ok"));
        this._scene.validateReferences("", dialog.getPrintStream());
        dialog.maybeShow();
    }

    protected void deleteErrors() {
        this.incrementEditId();
        Collection<TudeySceneModel.Entry> toProcess = this._selection.length > 0 ? Arrays.asList(this._selection) : this._scene.getEntries();
        Predicate<TudeySceneModel.Entry> isInvalid = new Predicate<TudeySceneModel.Entry>(){

            public boolean apply(TudeySceneModel.Entry entry) {
                return !entry.isValid(SceneEditor.this.getConfigManager());
            }
        };
        this.removeEntries(Collections2.filter(toProcess, (Predicate)isInvalid));
    }

    protected int getSelectionIndex(TudeySceneModel.Entry entry) {
        Object key = entry.getKey();
        for (int ii = 0; ii < this._selection.length; ++ii) {
            if (!this._selection[ii].getKey().equals(key)) continue;
            return ii;
        }
        return -1;
    }

    protected void clearPaint(TudeySceneModel.TileEntry entry) {
        if (entry == null) {
            return;
        }
        TileConfig.Original config = entry.getConfig(this.getConfigManager());
        Rectangle region = new Rectangle();
        entry.getRegion(config, region);
        this.setPaint(region, null);
    }

    protected boolean saveWarning(String message) {
        if (this._scene == null || !this._scene.isDirty()) {
            return true;
        }
        int option = JOptionPane.showOptionDialog(this._frame, "Discard unsaved changes and " + message + "?", "Discard changes?", -1, 2, null, new Object[]{"Cancel", "Save First", "Discard Changes"}, "Cancel");
        switch (option) {
            default: {
                return false;
            }
            case 1: {
                if (this._file != null) {
                    this.save(this._file);
                    return true;
                }
                this.save();
                return false;
            }
            case 2: 
        }
        return true;
    }

    @EditorMessageBundle(value="editor.default")
    protected class SceneEditorPrefs
    extends GlCanvasTool.CanvasToolPrefs {
        public SceneEditorPrefs(Preferences prefs) {
            super(prefs);
        }

        @Editable(weight=8.0)
        public void setDebugRegions(boolean debug) {
            this._prefs.putBoolean("debug_regions", debug);
        }

        @Editable
        public boolean getDebugRegions() {
            return this._prefs.getBoolean("debug_regions", false);
        }
    }
}

