/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.util.StringUtil;
import com.threerings.editor.Introspector;
import com.threerings.editor.swing.editors.PanelArrayListEditor;
import com.threerings.util.MessageBundle;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class EnumPanelArrayListEditor
extends PanelArrayListEditor {
    @Override
    protected void updatePanel(PanelArrayListEditor.EntryPanel panel, Object value) {
        JComboBox box = ((EnumEntryPanel)panel).getBox();
        box.setSelectedIndex(this.getValues().indexOf(value));
    }

    @Override
    protected void addPanel(Object value) {
        this._panels.add((Component)((Object)new EnumEntryPanel(value)));
    }

    protected List<Enum> getValues() {
        return Arrays.asList((Enum[])this.getEnumType().getEnumConstants());
    }

    protected Class<?> getEnumType() {
        Class<?> ctype = this._property.getComponentType();
        if (ctype.isArray()) {
            ctype = ctype.getComponentType();
        }
        return ctype;
    }

    protected void boxUpdated(JComboBox box) {
        int idx = this._panels.getComponentZOrder(box.getParent().getParent());
        this.setValue(idx, this.getValues().get(box.getSelectedIndex()));
        this.fireStateChanged(true);
    }

    protected class EnumEntryPanel
    extends PanelArrayListEditor.EntryPanel {
        protected JComboBox _box;

        public EnumEntryPanel(Object value) {
            super(EnumPanelArrayListEditor.this, value);
        }

        public JComboBox getBox() {
            return this._box;
        }

        @Override
        public String getMousePath(Point pt) {
            return "";
        }

        @Override
        protected JPanel createPanel(Object value) {
            JPanel panel = new JPanel((LayoutManager)new VGroupLayout(GroupLayout.NONE, GroupLayout.CONSTRAIN, 5, GroupLayout.TOP));
            final MessageBundle msgs = EnumPanelArrayListEditor.this._msgmgr.getBundle(Introspector.getMessageBundle(EnumPanelArrayListEditor.this.getEnumType()));
            List<Enum> values = EnumPanelArrayListEditor.this.getValues();
            Object[] labels = Lists.transform(values, (Function)new Function<Enum, String>(){

                public String apply(Enum value) {
                    return EnumEntryPanel.this.getLabel(value, msgs);
                }
            }).toArray();
            this._box = new JComboBox<Object>(labels);
            panel.add(this._box);
            this._box.setSelectedIndex(values.indexOf(value));
            this._box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EnumPanelArrayListEditor.this.boxUpdated((JComboBox)event.getSource());
                }
            });
            return panel;
        }

        protected String getLabel(Enum value, MessageBundle msgs) {
            if (value == null) {
                return EnumPanelArrayListEditor.this._msgs.get("m.none");
            }
            String key = "m." + StringUtil.toUSLowerCase((String)value.name());
            return msgs.exists(key) ? msgs.get(key) : value.toString();
        }
    }
}

