/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.editor.swing.BasePropertyEditor;
import com.threerings.editor.swing.DraggableSpinner;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.util.MessageBundle;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Vector2fPanel
extends BasePropertyEditor
implements ChangeListener {
    protected Mode _mode;
    protected float _scale;
    protected JSpinner[] _spinners;

    public Vector2fPanel(MessageBundle msgs, Mode mode, float step, float scale) {
        this._msgs = msgs;
        this._mode = mode;
        this._scale = scale;
        this.setLayout((LayoutManager)new VGroupLayout(GroupLayout.NONE, GroupLayout.STRETCH, 5, GroupLayout.TOP));
        this.setBackground(null);
        this._spinners = new JSpinner[this._mode == Mode.NORMALIZED ? 1 : 2];
        if (this._mode == Mode.CARTESIAN) {
            this._spinners[0] = this.addSpinnerPanel("x", -3.4028235E38f, Float.MAX_VALUE, step);
            this._spinners[1] = this.addSpinnerPanel("y", -3.4028235E38f, Float.MAX_VALUE, step);
        } else {
            this._spinners[0] = this.addSpinnerPanel("angle", -180.0f, 180.0f, 1.0f);
            if (this._mode != Mode.NORMALIZED) {
                this._spinners[1] = this.addSpinnerPanel("length", 0.0f, Float.MAX_VALUE, step);
            }
        }
    }

    public void setValue(Vector2f value) {
        float v2;
        float v1;
        if (this._mode == Mode.CARTESIAN) {
            v1 = value.x / this._scale;
            v2 = value.y;
        } else {
            v2 = value.length();
            v1 = v2 > 1.0E-4f ? FloatMath.toDegrees(FloatMath.atan2(value.y, value.x)) : 0.0f;
        }
        this._spinners[0].setValue(Float.valueOf(v1));
        if (this._spinners.length >= 2) {
            this._spinners[1].setValue(Float.valueOf(v2 / this._scale));
        }
    }

    public Vector2f getValue() {
        float v2;
        float v1 = ((Number)this._spinners[0].getValue()).floatValue();
        float f = v2 = this._spinners.length < 2 ? 1.0f : ((Number)this._spinners[1].getValue()).floatValue() * this._scale;
        if (this._mode == Mode.CARTESIAN) {
            return new Vector2f(v1 * this._scale, v2);
        }
        float angle = FloatMath.toRadians(v1);
        return new Vector2f(FloatMath.cos(angle) * v2, FloatMath.sin(angle) * v2);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireStateChanged();
    }

    protected JSpinner addSpinnerPanel(String name, float min, float max, float step) {
        JPanel panel = new JPanel();
        panel.setBackground(null);
        this.add(panel);
        panel.add(new JLabel(this.getLabel(name) + ":"));
        DraggableSpinner spinner = new DraggableSpinner(Float.valueOf(0.0f), min == -3.4028235E38f ? null : Float.valueOf(min), max == Float.MAX_VALUE ? null : Float.valueOf(max), Float.valueOf(step));
        panel.add(spinner);
        spinner.addChangeListener(this);
        return spinner;
    }

    public static enum Mode {
        CARTESIAN,
        POLAR,
        NORMALIZED;

    }
}

