/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.samskivert.util.IntListUtil;
import com.threerings.export.Exportable;
import com.threerings.export.Importer;
import com.threerings.tudey.util.Coord;
import com.threerings.util.DeepObject;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CoordIntMap
extends AbstractMap<Coord, Integer>
implements Exportable {
    protected int _granularity;
    protected int _empty;
    protected HashMap<Coord, Cell> _cells = new HashMap();
    protected transient int _mask;
    protected transient int _size;
    protected transient int _modcount;
    protected transient Coord _coord = new Coord();

    public CoordIntMap() {
        this(3);
    }

    public CoordIntMap(int granularity) {
        this(granularity, -1);
    }

    public CoordIntMap(int granularity, int empty) {
        this._granularity = granularity;
        this._empty = empty;
        this.initTransientFields();
    }

    public int get(int x, int y) {
        Cell cell = this.getCell(x, y);
        return cell == null ? this._empty : cell.get(x & this._mask, y & this._mask);
    }

    public int put(int x, int y, int value) {
        int ovalue;
        if (value == this._empty) {
            return this.remove(x, y);
        }
        this._coord.set(x >> this._granularity, y >> this._granularity);
        Cell cell = this._cells.get(this._coord);
        if (cell == null) {
            cell = new Cell();
            this._cells.put(this._coord.clone(), cell);
        }
        if ((ovalue = cell.put(x & this._mask, y & this._mask, value)) == this._empty) {
            ++this._size;
        }
        return ovalue;
    }

    public int setBits(int x, int y, int bits) {
        int ovalue;
        if (bits == 0) {
            return this.get(x, y);
        }
        this._coord.set(x >> this._granularity, y >> this._granularity);
        Cell cell = this._cells.get(this._coord);
        if (cell == null) {
            cell = new Cell();
            this._cells.put(this._coord.clone(), cell);
        }
        if ((ovalue = cell.setBits(x & this._mask, y & this._mask, bits)) == this._empty) {
            ++this._size;
        }
        return ovalue;
    }

    public int remove(int x, int y) {
        this._coord.set(x >> this._granularity, y >> this._granularity);
        Cell cell = this._cells.get(this._coord);
        if (cell == null) {
            return this._empty;
        }
        int ovalue = cell.remove(x & this._mask, y & this._mask);
        if (ovalue != this._empty) {
            --this._size;
            if (cell.size() == 0) {
                this._cells.remove(this._coord);
            }
        }
        return ovalue;
    }

    public boolean containsKey(int x, int y) {
        Cell cell = this.getCell(x, y);
        return cell != null && cell.get(x & this._mask, y & this._mask) != this._empty;
    }

    public boolean containsValue(int value) {
        for (Cell cell : this._cells.values()) {
            if (!cell.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public void readFields(Importer in) throws IOException {
        in.defaultReadFields();
        this.initTransientFields();
        for (Cell cell : this._cells.values()) {
            this._size += cell.size();
        }
    }

    public Set<CoordIntEntry> coordIntEntrySet() {
        return new AbstractSet<CoordIntEntry>(){

            @Override
            public Iterator<CoordIntEntry> iterator() {
                return new Iterator<CoordIntEntry>(){
                    protected Iterator<Map.Entry<Coord, Cell>> _cit;
                    protected Map.Entry<Coord, Cell> _centry;
                    protected int _idx;
                    protected int _count;
                    protected int _omodcount;
                    protected CoordIntEntry _dummy;
                    {
                        this._cit = CoordIntMap.this._cells.entrySet().iterator();
                        this._omodcount = CoordIntMap.this._modcount;
                        this._dummy = new CoordIntEntry();
                    }

                    @Override
                    public boolean hasNext() {
                        this.checkConcurrentModification();
                        return this._count < CoordIntMap.this._size;
                    }

                    @Override
                    public CoordIntEntry next() {
                        this.checkConcurrentModification();
                        if (this._centry == null) {
                            this._centry = this._cit.next();
                        }
                        while (true) {
                            int[] values = this._centry.getValue().getValues();
                            while (this._idx < values.length) {
                                int value = values[this._idx];
                                if (value != CoordIntMap.this._empty) {
                                    Coord coord = this._centry.getKey();
                                    this._dummy.getKey().set(coord.x << CoordIntMap.this._granularity | this._idx & CoordIntMap.this._mask, coord.y << CoordIntMap.this._granularity | this._idx >> CoordIntMap.this._granularity);
                                    this._dummy._values = values;
                                    this._dummy._idx = this._idx++;
                                    ++this._count;
                                    return this._dummy;
                                }
                                ++this._idx;
                            }
                            this._centry = this._cit.next();
                            this._idx = 0;
                        }
                    }

                    @Override
                    public void remove() {
                        this.checkConcurrentModification();
                        Cell cell = this._centry.getValue();
                        cell.remove(this._idx);
                        if (cell.size() == 0) {
                            this._cit.remove();
                            this._centry = null;
                            this._idx = 0;
                        }
                        --CoordIntMap.this._size;
                        --this._count;
                        this._omodcount = CoordIntMap.this._modcount;
                    }

                    protected void checkConcurrentModification() {
                        if (CoordIntMap.this._modcount != this._omodcount) {
                            throw new ConcurrentModificationException();
                        }
                    }
                };
            }

            @Override
            public int size() {
                return CoordIntMap.this._size;
            }
        };
    }

    @Override
    public Set<Map.Entry<Coord, Integer>> entrySet() {
        Set<Map.Entry<Coord, Integer>> cset;
        Set<Map.Entry<Coord, Integer>> set = cset = this.coordIntEntrySet();
        return set;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof Coord)) {
            return false;
        }
        Coord coord = (Coord)key;
        return this.containsKey(coord.x, coord.y);
    }

    @Override
    public boolean containsValue(Object value) {
        return value instanceof Integer && this.containsValue((Integer)value);
    }

    @Override
    public Integer get(Object key) {
        if (!(key instanceof Coord)) {
            return null;
        }
        Coord coord = (Coord)key;
        int value = this.get(coord.x, coord.y);
        return value == this._empty ? null : Integer.valueOf(value);
    }

    @Override
    public Integer put(Coord key, Integer value) {
        int ovalue = this.put(key.x, key.y, value);
        return ovalue == this._empty ? null : Integer.valueOf(ovalue);
    }

    @Override
    public Integer remove(Object key) {
        if (!(key instanceof Coord)) {
            return null;
        }
        Coord coord = (Coord)key;
        int ovalue = this.remove(coord.x, coord.y);
        return ovalue == this._empty ? null : Integer.valueOf(ovalue);
    }

    @Override
    public void clear() {
        this._cells.clear();
        this._size = 0;
        ++this._modcount;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    protected void initTransientFields() {
        this._mask = (1 << this._granularity) - 1;
    }

    protected Cell getCell(int x, int y) {
        this._coord.set(x >> this._granularity, y >> this._granularity);
        return this._cells.get(this._coord);
    }

    protected class Cell
    extends DeepObject
    implements Exportable {
        protected int[] _values;
        protected transient int _size;

        public Cell() {
            this._values = new int[1 << CoordIntMap.this._granularity << CoordIntMap.this._granularity];
            Arrays.fill(this._values, CoordIntMap.this._empty);
        }

        public int[] getValues() {
            return this._values;
        }

        public boolean containsValue(int value) {
            return IntListUtil.contains((int[])this._values, (int)value);
        }

        public int get(int x, int y) {
            return this._values[y << CoordIntMap.this._granularity | x];
        }

        public int put(int x, int y, int nvalue) {
            int idx = y << CoordIntMap.this._granularity | x;
            int ovalue = this._values[idx];
            this._values[idx] = nvalue;
            if (ovalue == CoordIntMap.this._empty) {
                ++this._size;
            }
            ++CoordIntMap.this._modcount;
            return ovalue;
        }

        public int setBits(int x, int y, int bits) {
            int idx = y << CoordIntMap.this._granularity | x;
            int ovalue = this._values[idx];
            int n = idx;
            this._values[n] = this._values[n] | bits;
            if (ovalue == CoordIntMap.this._empty) {
                ++this._size;
            }
            ++CoordIntMap.this._modcount;
            return ovalue;
        }

        public int remove(int x, int y) {
            int idx = y << CoordIntMap.this._granularity | x;
            int ovalue = this._values[idx];
            if (ovalue != CoordIntMap.this._empty) {
                this._values[idx] = CoordIntMap.this._empty;
                --this._size;
                ++CoordIntMap.this._modcount;
            }
            return ovalue;
        }

        public void remove(int idx) {
            this._values[idx] = CoordIntMap.this._empty;
            --this._size;
            ++CoordIntMap.this._modcount;
        }

        public int size() {
            return this._size;
        }

        public void readFields(Importer in) throws IOException {
            in.defaultReadFields();
            for (int value : this._values) {
                if (value == CoordIntMap.this._empty) continue;
                ++this._size;
            }
        }
    }

    public static class CoordIntEntry
    implements Map.Entry<Coord, Integer> {
        protected Coord _key = new Coord();
        protected int[] _values;
        protected int _idx;

        public int setIntValue(int value) {
            int ovalue = this._values[this._idx];
            this._values[this._idx] = value;
            return ovalue;
        }

        public int getIntValue() {
            return this._values[this._idx];
        }

        @Override
        public Coord getKey() {
            return this._key;
        }

        @Override
        public Integer getValue() {
            return this.getIntValue();
        }

        @Override
        public Integer setValue(Integer value) {
            return this.setIntValue(value);
        }

        public String toString() {
            return this.getKey().toString() + ": " + this.getValue().toString();
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof CoordIntEntry)) {
                return false;
            }
            CoordIntEntry oentry = (CoordIntEntry)other;
            return this._key.equals(oentry._key) && this.getIntValue() == oentry.getIntValue();
        }

        @Override
        public int hashCode() {
            return this._key.hashCode() ^ this.getIntValue();
        }
    }
}

