/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.threerings.opengl.renderer.Batch;
import com.threerings.opengl.renderer.BufferObject;
import com.threerings.opengl.renderer.DisplayList;
import com.threerings.opengl.renderer.Program;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Shader;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.renderer.TextureUnit;
import com.threerings.opengl.renderer.state.ArrayState;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.renderer.state.ShaderState;
import com.threerings.opengl.renderer.state.TextureState;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GLContext;

public class SimpleBatch
extends Batch {
    protected RenderState[] _states;
    protected DrawCommand _command;

    public static DrawElements createDrawBufferElements(int mode, int start, int end, int count, int type, long offset) {
        if (GLContext.getCapabilities().OpenGL12) {
            return new DrawBufferRangeElements(mode, start, end, count, type, offset);
        }
        return new DrawBufferElements(mode, count, type, offset);
    }

    public static DrawElements createDrawShortElements(int mode, int start, int end, ShortBuffer indices) {
        if (GLContext.getCapabilities().OpenGL12) {
            return new DrawShortRangeElements(mode, start, end, indices);
        }
        return new DrawShortElements(mode, indices);
    }

    public SimpleBatch(RenderState[] states, DrawCommand command) {
        this._states = states;
        this._command = command;
        this.updateKey();
    }

    public RenderState[] getStates() {
        return this._states;
    }

    public DrawCommand getCommand() {
        return this._command;
    }

    public void updateKey() {
        BufferObject buffer;
        ShaderState sstate;
        TextureState tstate = (TextureState)this._states[14];
        TextureUnit[] units = tstate == null ? null : tstate.getUnits();
        int textures = units == null ? 0 : units.length;
        int size = 2 + textures + 1 + 1;
        if (this.key == null || this.key.length != size) {
            this.key = new int[size];
        }
        Program program = (sstate = (ShaderState)this._states[12]) == null ? null : sstate.getProgram();
        Shader vertexShader = program == null ? null : program.getVertexShader();
        Shader fragmentShader = program == null ? null : program.getFragmentShader();
        int idx = 0;
        this.key[idx++] = vertexShader == null ? 0 : vertexShader.getId();
        this.key[idx++] = fragmentShader == null ? 0 : fragmentShader.getId();
        for (int ii = 0; ii < textures; ++ii) {
            Texture texture = units[ii] == null ? null : units[ii].texture;
            this.key[idx++] = texture == null ? 0 : texture.getId();
        }
        this.key[idx++] = -1;
        ArrayState astate = (ArrayState)this._states[1];
        BufferObject bufferObject = buffer = astate == null ? null : astate.getElementArrayBuffer();
        this.key[idx++] = buffer != null ? buffer.getId() : (this._command instanceof CallList ? ((CallList)this._command).getList().getId() : 0);
    }

    @Override
    public boolean draw(Renderer renderer) {
        renderer.setStates(this._states);
        return this._command.call();
    }

    @Override
    public int getPrimitiveCount() {
        return this._command.getPrimitiveCount();
    }

    @Override
    public SimpleBatch clone() {
        SimpleBatch obatch = (SimpleBatch)super.clone();
        obatch._states = (RenderState[])this._states.clone();
        return obatch;
    }

    protected static int sizeof(int type) {
        switch (type) {
            default: {
                return 1;
            }
            case 5123: {
                return 2;
            }
            case 5125: 
        }
        return 4;
    }

    protected static int getPrimitiveCount(int mode, int count) {
        switch (mode) {
            case 0: 
            case 2: {
                return count;
            }
            case 1: {
                return count / 2;
            }
            case 3: {
                return count - 1;
            }
            case 4: {
                return count / 3;
            }
            case 5: 
            case 6: {
                return count - 2;
            }
            case 7: {
                return count / 4;
            }
            case 8: {
                return count / 2 - 1;
            }
            case 9: {
                return 1;
            }
        }
        return 0;
    }

    public static class DrawShortRangeElements
    extends DrawRangeElements {
        protected ShortBuffer _indices;

        public DrawShortRangeElements(int mode, int start, int end, ShortBuffer indices) {
            super(mode, start, end);
            this._indices = indices;
        }

        @Override
        public void setLimits(int offset, int length) {
            this._indices.limit(offset + length).position(offset);
        }

        @Override
        public boolean call() {
            GL12.glDrawRangeElements((int)this._mode, (int)this._start, (int)this._end, (ShortBuffer)this._indices);
            return false;
        }

        @Override
        public int getPrimitiveCount() {
            return SimpleBatch.getPrimitiveCount(this._mode, this._indices.remaining());
        }
    }

    public static class DrawBufferRangeElements
    extends DrawRangeElements {
        protected int _count;
        protected int _type;
        protected long _offset;

        public DrawBufferRangeElements(int mode, int start, int end, int count, int type, long offset) {
            super(mode, start, end);
            this._count = count;
            this._type = type;
            this._offset = offset;
        }

        @Override
        public void setLimits(int offset, int length) {
            this._count = length;
            this._offset = offset * SimpleBatch.sizeof(this._type);
        }

        @Override
        public boolean call() {
            GL12.glDrawRangeElements((int)this._mode, (int)this._start, (int)this._end, (int)this._count, (int)this._type, (long)this._offset);
            return false;
        }

        @Override
        public int getPrimitiveCount() {
            return SimpleBatch.getPrimitiveCount(this._mode, this._count);
        }
    }

    public static abstract class DrawRangeElements
    extends DrawElements {
        protected int _start;
        protected int _end;

        public DrawRangeElements(int mode, int start, int end) {
            super(mode);
            this.setRange(start, end);
        }

        @Override
        public void setRange(int start, int end) {
            this._start = start;
            this._end = end;
        }
    }

    public static class DrawShortElements
    extends DrawElements {
        protected ShortBuffer _indices;

        public DrawShortElements(int mode, ShortBuffer indices) {
            super(mode);
            this._indices = indices;
        }

        @Override
        public void setLimits(int offset, int length) {
            this._indices.limit(offset + length).position(offset);
        }

        @Override
        public boolean call() {
            GL11.glDrawElements((int)this._mode, (ShortBuffer)this._indices);
            return false;
        }

        @Override
        public int getPrimitiveCount() {
            return SimpleBatch.getPrimitiveCount(this._mode, this._indices.remaining());
        }
    }

    public static class DrawBufferElements
    extends DrawElements {
        protected int _count;
        protected int _type;
        protected long _offset;

        public DrawBufferElements(int mode, int count, int type, long offset) {
            super(mode);
            this._count = count;
            this._type = type;
            this._offset = offset;
        }

        @Override
        public void setLimits(int offset, int length) {
            this._count = length;
            this._offset = offset * SimpleBatch.sizeof(this._type);
        }

        @Override
        public boolean call() {
            GL11.glDrawElements((int)this._mode, (int)this._count, (int)this._type, (long)this._offset);
            return false;
        }

        @Override
        public int getPrimitiveCount() {
            return SimpleBatch.getPrimitiveCount(this._mode, this._count);
        }
    }

    public static abstract class DrawElements
    extends DrawCommand {
        protected int _mode;

        public DrawElements(int mode) {
            this._mode = mode;
        }

        public abstract void setLimits(int var1, int var2);

        public void setRange(int start, int end) {
        }
    }

    public static class DrawArrays
    extends DrawCommand {
        protected int _mode;
        protected int _first;
        protected int _count;

        public DrawArrays(int mode, int first, int count) {
            this._mode = mode;
            this._first = first;
            this._count = count;
        }

        @Override
        public boolean call() {
            GL11.glDrawArrays((int)this._mode, (int)this._first, (int)this._count);
            return false;
        }

        @Override
        public int getPrimitiveCount() {
            return SimpleBatch.getPrimitiveCount(this._mode, this._count);
        }
    }

    public static class CallList
    extends DrawCommand {
        protected DisplayList _list;
        protected boolean _modifiesColorState;
        protected int _primitiveCount;

        public CallList(DisplayList list, boolean modifiesColorState, int primitiveCount) {
            this._list = list;
            this._modifiesColorState = modifiesColorState;
            this._primitiveCount = primitiveCount;
        }

        public DisplayList getList() {
            return this._list;
        }

        @Override
        public boolean call() {
            this._list.call();
            return this._modifiesColorState;
        }

        @Override
        public int getPrimitiveCount() {
            return this._primitiveCount;
        }
    }

    public static abstract class DrawCommand {
        public abstract boolean call();

        public abstract int getPrimitiveCount();
    }
}

