/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.camera;

import com.threerings.math.FloatMath;
import com.threerings.math.Quaternion;
import com.threerings.math.SphereCoords;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.camera.Camera;
import com.threerings.opengl.camera.CameraHandler;
import com.threerings.opengl.util.GlContext;

public class OrbitCameraHandler
extends CameraHandler {
    protected Vector3f _target = new Vector3f();
    protected SphereCoords _coords = new SphereCoords(0.0f, 0.7853982f, 10.0f);
    protected float _minElevation = 0.19634955f;
    protected float _maxElevation = 1.5707964f;
    protected float _minDistance = 2.0f;
    protected float _maxDistance = 50.0f;
    protected Vector3f _pan = new Vector3f();

    public OrbitCameraHandler(GlContext ctx) {
        super(ctx);
    }

    public OrbitCameraHandler(GlContext ctx, Camera camera, boolean matchRenderSurface) {
        super(ctx, camera, matchRenderSurface);
    }

    public Vector3f getTarget() {
        return this._target;
    }

    public SphereCoords getCoords() {
        return this._coords;
    }

    public void orbit(float azimuth, float elevation) {
        this._coords.azimuth += azimuth;
        this._coords.elevation = FloatMath.clamp(this._coords.elevation + elevation, this._minElevation, this._maxElevation);
    }

    public void zoom(float distance) {
        this._coords.distance = FloatMath.clamp(this._coords.distance + distance, this._minDistance, this._maxDistance);
    }

    public void pan(float x, float y) {
        Quaternion rot = this._camera.getWorldTransform().getRotation();
        this._target.addLocal(rot.transformLocal(this._pan.set(x, y, 0.0f)));
    }

    public void panXY(float x, float y) {
        float cosa = FloatMath.cos(this._coords.azimuth);
        float sina = FloatMath.sin(this._coords.azimuth);
        this._target.addLocal(x * cosa - y * sina, x * sina + y * cosa, 0.0f);
    }

    public void setCoordLimits(float minElevation, float maxElevation, float minDistance, float maxDistance) {
        this._minElevation = minElevation;
        this._maxElevation = maxElevation;
        this._minDistance = minDistance;
        this._maxDistance = maxDistance;
    }

    @Override
    public Vector3f getViewerTranslation() {
        return this._target;
    }

    @Override
    protected void getTransform(Transform3D transform) {
        float ce = FloatMath.cos(this._coords.elevation);
        transform.getTranslation().set(FloatMath.sin(this._coords.azimuth) * ce, -FloatMath.cos(this._coords.azimuth) * ce, FloatMath.sin(this._coords.elevation)).multLocal(this._coords.distance).addLocal(this._target);
        transform.getRotation().fromAnglesXZ(1.5707964f - this._coords.elevation, this._coords.azimuth);
    }
}

