/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;

public final class Ray3D {
    protected Vector3f _origin = new Vector3f();
    protected Vector3f _direction = new Vector3f();

    public Ray3D(Vector3f origin, Vector3f direction) {
        this.set(origin, direction);
    }

    public Ray3D(Ray3D other) {
        this.set(other);
    }

    public Ray3D() {
    }

    public Vector3f getOrigin() {
        return this._origin;
    }

    public Vector3f getDirection() {
        return this._direction;
    }

    public Ray3D transformLocal(Transform3D transform) {
        return this.transform(transform, this);
    }

    public Ray3D transform(Transform3D transform) {
        return this.transform(transform, new Ray3D());
    }

    public Ray3D transform(Transform3D transform, Ray3D result) {
        transform.transformPoint(this._origin, result._origin);
        transform.transformVector(this._direction, result._direction).normalizeLocal();
        return result;
    }

    public Ray3D set(Ray3D other) {
        return this.set(other.getOrigin(), other.getDirection());
    }

    public Ray3D set(Vector3f origin, Vector3f direction) {
        this._origin.set(origin);
        this._direction.set(direction);
        return this;
    }

    public String toString() {
        return "[origin=" + this._origin + ", direction=" + this._direction + "]";
    }
}

