/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.swing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Tuple;
import com.threerings.ClydeLog;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigGroupListener;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.config.ManagedConfig;
import com.threerings.config.swing.ConfigTreeNode;
import com.threerings.export.util.SerializableWrapper;
import com.threerings.util.ChangeBlock;
import com.threerings.util.ToolUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ConfigTree
extends JTree
implements ConfigGroupListener<ManagedConfig>,
ConfigUpdateListener<ManagedConfig> {
    protected ConfigGroup<ManagedConfig>[] _groups;
    protected Set<String> _expanded = Sets.newHashSet();
    protected ChangeBlock _block = new ChangeBlock();
    protected ManagedConfig _lconfig;
    protected Predicate<? super ManagedConfig> _filter;
    protected String _lastFilterSelectedPath;
    protected static Preferences _prefs = Preferences.userNodeForPackage(ConfigTree.class);
    protected static final DataFlavor LOCAL_NODE_TRANSFER_FLAVOR = ToolUtil.createLocalFlavor(NodeTransfer.class);
    protected static final DataFlavor[] NODE_TRANSFER_FLAVORS = new DataFlavor[]{LOCAL_NODE_TRANSFER_FLAVOR, ToolUtil.SERIALIZED_WRAPPED_FLAVOR};

    public ConfigTree(ConfigGroup ... groups) {
        this(groups, false);
    }

    public ConfigTree(ConfigGroup group, boolean editable) {
        this(new ConfigGroup[]{group}, editable);
    }

    public void setFilter(Predicate<? super ManagedConfig> filter) {
        if (filter == null) {
            filter = Predicates.alwaysTrue();
        }
        if (!filter.equals(this._filter)) {
            this._filter = filter;
            this.updateFiltered();
        }
    }

    public void dispose() {
        for (ConfigGroup<ManagedConfig> group : this._groups) {
            group.removeListener(this);
        }
        if (this._lconfig != null) {
            this._lconfig.removeListener(this);
            this._lconfig = null;
        }
    }

    public Transferable createClipboardTransferable() {
        ConfigTreeNode node = this.getSelectedNode();
        return node == null ? null : new NodeTransfer(node, true);
    }

    public ConfigTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        return path == null ? null : (ConfigTreeNode)path.getLastPathComponent();
    }

    public void setSelectedNode(String name) {
        if (name == null) {
            this.clearSelection();
            return;
        }
        ConfigTreeNode node = ((ConfigTreeNode)this.getModel().getRoot()).getNode(name);
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectedConfigChanged() {
        if (!this._block.enter()) {
            return;
        }
        try {
            this.getSelectedNode().getConfig().wasUpdated();
        }
        finally {
            this._block.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configAdded(ConfigEvent<ManagedConfig> event) {
        if (!this._block.enter()) {
            return;
        }
        try {
            ManagedConfig config = event.getConfig();
            if (!this._filter.apply((Object)config)) {
                return;
            }
            ConfigTreeNode root = (ConfigTreeNode)this.getModel().getRoot();
            Tuple<ConfigTreeNode, ConfigTreeNode> point = root.getInsertionPoint(config, config.getName());
            if (((ConfigTreeNode)point.right).getParent() != null) {
                ((ConfigTreeNode)point.right).incrementCount();
            } else {
                ((DefaultTreeModel)this.getModel()).insertNodeInto((MutableTreeNode)point.right, (MutableTreeNode)point.left, ((ConfigTreeNode)point.left).getInsertionIndex((ConfigTreeNode)point.right));
            }
        }
        finally {
            this._block.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configRemoved(ConfigEvent<ManagedConfig> event) {
        if (!this._block.enter()) {
            return;
        }
        try {
            String name = event.getConfig().getName();
            ConfigTreeNode node = ((ConfigTreeNode)this.getModel().getRoot()).getNode(name);
            if (node != null) {
                if (node.decrementCount() == 0) {
                    if (!this.isEditable()) {
                        while (node.getSiblingCount() == 1 && node.getLevel() > 1) {
                            node = (ConfigTreeNode)node.getParent();
                        }
                    }
                    ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
                }
            } else {
                ClydeLog.log.warning((Object)("Missing config node [name=" + name + "]."), new Object[0]);
            }
        }
        finally {
            this._block.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configUpdated(ConfigEvent<ManagedConfig> event) {
        if (!this._block.enter()) {
            return;
        }
        try {
            this.selectedConfigUpdated();
        }
        finally {
            this._block.leave();
        }
    }

    protected ConfigTree(ConfigGroup[] groups, boolean editable) {
        ConfigGroup[] mgroups = groups;
        this._groups = mgroups;
        this.setModel(new DefaultTreeModel(new ConfigTreeNode(null, null), true){

            @Override
            public void valueForPathChanged(TreePath path, Object newValue) {
                TreePath selection = ConfigTree.this.getSelectionPath();
                String name = ((String)newValue).trim();
                ConfigTreeNode node = (ConfigTreeNode)path.getLastPathComponent();
                ConfigTreeNode parent = (ConfigTreeNode)node.getParent();
                this.removeNodeFromParent(node);
                node.setUserObject(parent.findNameForChild(name));
                this.insertNodeInto(node, parent, parent.getInsertionIndex(node));
                node.expandPaths(ConfigTree.this);
                ConfigTree.this.setSelectionPath(selection);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent, int index) {
                super.insertNodeInto(child, parent, index);
                if (!ConfigTree.this._block.enter()) {
                    return;
                }
                try {
                    ((ConfigTreeNode)child).addConfigs(ConfigTree.this._groups[0]);
                }
                finally {
                    ConfigTree.this._block.leave();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeNodeFromParent(MutableTreeNode node) {
                ConfigTreeNode ctnode = (ConfigTreeNode)node;
                if (ConfigTree.this.removeExpanded(ctnode)) {
                    ConfigTree.this.writeExpanded();
                }
                super.removeNodeFromParent(node);
                if (!ConfigTree.this._block.enter()) {
                    return;
                }
                try {
                    ctnode.removeConfigs(ConfigTree.this._groups[0]);
                }
                finally {
                    ConfigTree.this._block.leave();
                }
            }
        });
        this.setRootVisible(false);
        this.setEditable(editable);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                ManagedConfig config;
                ConfigTreeNode node = ConfigTree.this.getSelectedNode();
                ManagedConfig managedConfig = config = node == null ? null : node.getConfig();
                if (ConfigTree.this._lconfig != null) {
                    ConfigTree.this._lconfig.removeListener(ConfigTree.this);
                }
                if ((ConfigTree.this._lconfig = config) != null) {
                    ConfigTree.this._lconfig.addListener(ConfigTree.this);
                }
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                ConfigTreeNode node = (ConfigTreeNode)event.getPath().getLastPathComponent();
                node.setExpanded(true);
                if (!ConfigTree.this.isFiltered()) {
                    ConfigTree.this.addExpanded(node.getName());
                }
                node.expandPaths(ConfigTree.this);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                ConfigTreeNode node = (ConfigTreeNode)event.getPath().getLastPathComponent();
                node.setExpanded(false);
                if (!ConfigTree.this.isFiltered()) {
                    ConfigTree.this.removeExpanded(node.getName());
                }
            }
        });
        this.setDragEnabled(true);
        this.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent comp) {
                return ConfigTree.this.isEditable() ? 2 : 1;
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] flavors) {
                return ConfigTree.this.isEditable() && ListUtil.contains((Object[])flavors, (Object)ToolUtil.SERIALIZED_WRAPPED_FLAVOR);
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                ConfigTreeNode node;
                Object data;
                if (!this.canImport(comp, t.getTransferDataFlavors())) {
                    return false;
                }
                boolean local = t.isDataFlavorSupported(LOCAL_NODE_TRANSFER_FLAVOR);
                try {
                    data = t.getTransferData(local ? LOCAL_NODE_TRANSFER_FLAVOR : ToolUtil.SERIALIZED_WRAPPED_FLAVOR);
                }
                catch (Exception e) {
                    ClydeLog.log.warning((Object)"Failure importing data.", new Object[]{e});
                    return false;
                }
                ConfigTreeNode onode = null;
                if (local) {
                    NodeTransfer transfer = (NodeTransfer)data;
                    node = transfer.cnode;
                    onode = transfer.onode;
                } else {
                    if (!((data = ((SerializableWrapper)data).getObject()) instanceof ConfigTreeNode)) {
                        return false;
                    }
                    node = (ConfigTreeNode)data;
                }
                if (!node.verifyConfigClass(ConfigTree.this._groups[0].getConfigClass())) {
                    return false;
                }
                ConfigTreeNode snode = ConfigTree.this.getSelectedNode();
                ConfigTreeNode parent = (ConfigTreeNode)ConfigTree.this.getModel().getRoot();
                if (snode != null && snode.getParent() != null) {
                    ConfigTreeNode configTreeNode = parent = snode.getAllowsChildren() ? snode : (ConfigTreeNode)snode.getParent();
                }
                if (onode == parent || onode != null && onode.getParent() == parent) {
                    return false;
                }
                node = node.clone();
                String name = (String)node.getUserObject();
                node.setUserObject(parent.findNameForChild(name));
                if (onode != null && onode.getRoot() == parent.getRoot()) {
                    ((DefaultTreeModel)ConfigTree.this.getModel()).removeNodeFromParent(onode);
                }
                ((DefaultTreeModel)ConfigTree.this.getModel()).insertNodeInto(node, parent, parent.getInsertionIndex(node));
                node.expandPaths(ConfigTree.this);
                ConfigTree.this.setSelectionPath(new TreePath(node.getPath()));
                return true;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                ConfigTreeNode node = ConfigTree.this.getSelectedNode();
                return node == null ? null : new NodeTransfer(node, false);
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
                ConfigTreeNode onode;
                if (action == 2 && (onode = ((NodeTransfer)data).onode).getParent() != null) {
                    ((DefaultTreeModel)ConfigTree.this.getModel()).removeNodeFromParent(onode);
                }
            }
        });
        for (ConfigGroup<ManagedConfig> group : this._groups) {
            group.addListener(this);
        }
        this.readExpanded();
        this.setFilter(null);
        this.pruneExpanded();
    }

    protected void updateFiltered() {
        ConfigTreeNode newSelect;
        ConfigTreeNode selected = this.getSelectedNode();
        if (selected != null) {
            this._lastFilterSelectedPath = selected.getName();
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        ConfigTreeNode root = new ConfigTreeNode(null, null);
        model.setRoot(root);
        for (ConfigGroup<ManagedConfig> group : this._groups) {
            for (ManagedConfig config : Iterables.filter(group.getConfigs(), this._filter)) {
                root.insertConfig(config, config.getName());
            }
        }
        model.reload();
        root.setExpanded(true);
        if (this._expanded.isEmpty()) {
            root.expandPaths(this, 1);
        } else if (this.isFiltered()) {
            root.expandPaths(this, Integer.MAX_VALUE);
        } else {
            for (String name : this._expanded) {
                ConfigTreeNode node = root.getNode(name);
                if (node == null) continue;
                node.setExpanded(true);
            }
            root.expandPaths(this);
        }
        if (this._lastFilterSelectedPath != null && (newSelect = root.getNode(this._lastFilterSelectedPath)) != null) {
            TreePath path = new TreePath(newSelect.getPath());
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    protected boolean isFiltered() {
        return this._filter != Predicates.alwaysTrue();
    }

    protected void selectedConfigUpdated() {
    }

    protected void addExpanded(String name) {
        if (this._expanded.add(name)) {
            this.writeExpanded();
        }
    }

    protected boolean removeExpanded(ConfigTreeNode node) {
        boolean changed = this._expanded.remove(node.getName());
        int nn = node.getChildCount();
        for (int ii = 0; ii < nn; ++ii) {
            changed |= this.removeExpanded((ConfigTreeNode)node.getChildAt(ii));
        }
        return changed;
    }

    protected void removeExpanded(String name) {
        if (this._expanded.remove(name)) {
            this.writeExpanded();
        }
    }

    protected void readExpanded() {
        String names = _prefs.get(this._groups[0].getName() + ".expanded", null);
        if (names != null) {
            this._expanded.addAll(Arrays.asList(StringUtil.parseStringArray((String)names)));
        }
    }

    protected void pruneExpanded() {
        Preconditions.checkState((this._filter == Predicates.alwaysTrue() ? 1 : 0) != 0);
        ConfigTreeNode root = (ConfigTreeNode)this.getModel().getRoot();
        Iterator<String> it = this._expanded.iterator();
        while (it.hasNext()) {
            if (null != root.getNode(it.next())) continue;
            it.remove();
        }
    }

    protected void writeExpanded() {
        String group = this._groups[0].getName();
        Object[] names = (String[])Iterables.toArray(this._expanded, String.class);
        String value = StringUtil.joinEscaped((String[])names);
        if (value.length() > 8192) {
            ClydeLog.log.warning((Object)"Too many expanded paths to store in preferences, trimming.", new Object[]{"group", group, "length", value.length()});
            Arrays.sort(names, Ordering.natural().onResultOf((Function)new Function<String, Integer>(){

                public Integer apply(String s) {
                    return Collections.frequency(Lists.charactersOf((String)s), Character.valueOf('/'));
                }
            }));
            while ((value = StringUtil.joinEscaped((String[])(names = (String[])ArrayUtil.splice((Object[])names, (int)(names.length - 1))))).length() > 8192) {
            }
        }
        _prefs.put(group + ".expanded", value);
    }

    protected static class NodeTransfer
    implements Transferable {
        public ConfigTreeNode onode;
        public ConfigTreeNode cnode;

        public NodeTransfer(ConfigTreeNode onode, boolean clipboard) {
            this.onode = clipboard ? null : onode;
            this.cnode = onode.clone();
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return NODE_TRANSFER_FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ListUtil.contains((Object[])NODE_TRANSFER_FLAVORS, (Object)flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return flavor.equals(LOCAL_NODE_TRANSFER_FLAVOR) ? this : new SerializableWrapper(this.cnode);
        }
    }
}

