/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.samskivert.util.StringUtil;
import com.threerings.export.Encodable;
import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.FloatBuffer;

public final class Vector2f
implements Encodable,
Streamable {
    public static final Vector2f UNIT_X = new Vector2f(1.0f, 0.0f);
    public static final Vector2f UNIT_Y = new Vector2f(0.0f, 1.0f);
    public static final Vector2f ZERO = new Vector2f(0.0f, 0.0f);
    public static final Vector2f MIN_VALUE = new Vector2f(-3.4028235E38f, -3.4028235E38f);
    public static final Vector2f MAX_VALUE = new Vector2f(Float.MAX_VALUE, Float.MAX_VALUE);
    public float x;
    public float y;

    public Vector2f(float x, float y) {
        this.set(x, y);
    }

    public Vector2f(float[] values) {
        this.set(values);
    }

    public Vector2f(Vector2f other) {
        this.set(other);
    }

    public Vector2f() {
    }

    public float dot(Vector2f other) {
        return this.dot(other.x, other.y);
    }

    public float dot(float otherX, float otherY) {
        return this.x * otherX + this.y * otherY;
    }

    public Vector2f negateLocal() {
        return this.negate(this);
    }

    public Vector2f negate() {
        return this.negate(new Vector2f());
    }

    public Vector2f negate(Vector2f result) {
        return result.set(-this.x, -this.y);
    }

    public Vector2f normalizeLocal() {
        return this.normalize(this);
    }

    public Vector2f normalize() {
        return this.normalize(new Vector2f());
    }

    public Vector2f normalize(Vector2f result) {
        return this.mult(1.0f / this.length(), result);
    }

    public float angle(Vector2f other) {
        float cos = this.dot(other) / (this.length() * other.length());
        return cos >= 1.0f ? 0.0f : FloatMath.acos(cos);
    }

    public float direction(Vector2f other) {
        return FloatMath.atan2(other.y - this.y, other.x - this.x);
    }

    public float length() {
        return FloatMath.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float distance(Vector2f other) {
        return FloatMath.sqrt(this.distanceSquared(other));
    }

    public float distanceSquared(Vector2f other) {
        float dx = this.x - other.x;
        float dy = this.y - other.y;
        return dx * dx + dy * dy;
    }

    public Vector2f multLocal(float v) {
        return this.mult(v, this);
    }

    public Vector2f mult(float v) {
        return this.mult(v, new Vector2f());
    }

    public Vector2f mult(float v, Vector2f result) {
        return result.set(this.x * v, this.y * v);
    }

    public Vector2f multLocal(Vector2f other) {
        return this.mult(other, this);
    }

    public Vector2f mult(Vector2f other) {
        return this.mult(other, new Vector2f());
    }

    public Vector2f mult(Vector2f other, Vector2f result) {
        return result.set(this.x * other.x, this.y * other.y);
    }

    public Vector2f addLocal(Vector2f other) {
        return this.add(other, this);
    }

    public Vector2f add(Vector2f other) {
        return this.add(other, new Vector2f());
    }

    public Vector2f add(Vector2f other, Vector2f result) {
        return this.add(other.x, other.y, result);
    }

    public Vector2f subtractLocal(Vector2f other) {
        return this.subtract(other, this);
    }

    public Vector2f subtract(Vector2f other) {
        return this.subtract(other, new Vector2f());
    }

    public Vector2f subtract(Vector2f other, Vector2f result) {
        return this.add(-other.x, -other.y, result);
    }

    public Vector2f addLocal(float x, float y) {
        return this.add(x, y, this);
    }

    public Vector2f add(float x, float y) {
        return this.add(x, y, new Vector2f());
    }

    public Vector2f add(float x, float y, Vector2f result) {
        return result.set(this.x + x, this.y + y);
    }

    public Vector2f addScaledLocal(Vector2f other, float v) {
        return this.addScaled(other, v, this);
    }

    public Vector2f addScaled(Vector2f other, float v) {
        return this.addScaled(other, v, new Vector2f());
    }

    public Vector2f addScaled(Vector2f other, float v, Vector2f result) {
        return result.set(this.x + other.x * v, this.y + other.y * v);
    }

    public Vector2f rotateLocal(float angle) {
        return this.rotate(angle, this);
    }

    public Vector2f rotate(float angle) {
        return this.rotate(angle, new Vector2f());
    }

    public Vector2f rotate(float angle, Vector2f result) {
        float sina = FloatMath.sin(angle);
        float cosa = FloatMath.cos(angle);
        return result.set(this.x * cosa - this.y * sina, this.x * sina + this.y * cosa);
    }

    public Vector2f rotateAndAdd(float angle, Vector2f add, Vector2f result) {
        float sina = FloatMath.sin(angle);
        float cosa = FloatMath.cos(angle);
        return result.set(this.x * cosa - this.y * sina + add.x, this.x * sina + this.y * cosa + add.y);
    }

    public Vector2f rotateScaleAndAdd(float angle, float scale, Vector2f add, Vector2f result) {
        float sina = FloatMath.sin(angle);
        float cosa = FloatMath.cos(angle);
        return result.set((this.x * cosa - this.y * sina) * scale + add.x, (this.x * sina + this.y * cosa) * scale + add.y);
    }

    public Vector2f lerpLocal(Vector2f other, float t) {
        return this.lerp(other, t, this);
    }

    public Vector2f lerp(Vector2f other, float t) {
        return this.lerp(other, t, new Vector2f());
    }

    public Vector2f lerp(Vector2f other, float t, Vector2f result) {
        return result.set(this.x + t * (other.x - this.x), this.y + t * (other.y - this.y));
    }

    public Vector2f set(Vector2f other) {
        return this.set(other.x, other.y);
    }

    public Vector2f set(float[] values) {
        return this.set(values[0], values[1]);
    }

    public Vector2f set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public float get(int idx) {
        switch (idx) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(idx));
    }

    public void get(float[] values) {
        values[0] = this.x;
        values[1] = this.y;
    }

    public FloatBuffer get(FloatBuffer buf) {
        return buf.put(this.x).put(this.y);
    }

    @Override
    public String encodeToString() {
        return this.x + ", " + this.y;
    }

    @Override
    public void decodeFromString(String string) throws Exception {
        this.set(StringUtil.parseFloatArray((String)string));
    }

    @Override
    public void encodeToStream(DataOutputStream out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
    }

    @Override
    public void decodeFromStream(DataInputStream in) throws IOException {
        this.set(in.readFloat(), in.readFloat());
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    public int hashCode() {
        return Float.floatToIntBits(this.x) ^ Float.floatToIntBits(this.y);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Vector2f)) {
            return false;
        }
        Vector2f ovec = (Vector2f)other;
        return this.x == ovec.x && this.y == ovec.y;
    }
}

