/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.util;

import com.google.common.collect.Lists;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.threerings.config.ConfigManager;
import com.threerings.math.FloatMath;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.media.util.AStarPathUtil;
import com.threerings.media.util.MathUtil;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.ActorSprite;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.space.SpaceElement;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.CoordIntMap;
import java.awt.Point;
import java.util.List;

public class Pathfinder
implements TudeySceneModel.Observer {
    private TudeySceneView _view;
    protected CoordIntMap _entryFlags = new CoordIntMap(3, 0);
    protected CoordIntMap _actorFlags = new CoordIntMap(3, 0);
    protected IntMap<List<Integer>> _actorFlagLists = IntMaps.newHashIntMap();
    protected Polygon _quad = new Polygon(4);
    protected List<SpaceElement> _elements = Lists.newArrayList();
    protected List<Vector2f> _waypoints = Lists.newArrayList();
    protected Rectangle _region = new Rectangle();
    protected Transform2D _transform = new Transform2D();
    protected Shape _worldShape;
    protected Vector2f _translation = new Vector2f();
    protected Shape _sweptShape;
    protected static final int SUBDIVISION = 2;

    public Pathfinder(TudeySceneView view) {
        this._view = view;
        TudeySceneModel model = this._view.getSceneModel();
        for (TudeySceneModel.Entry entry : model.getEntries()) {
            this.addFlags(entry);
        }
        model.addObserver(this);
    }

    public void shutdown() {
        this._view.getSceneModel().removeObserver(this);
    }

    public Vector2f[] getEntryPath(ActorSprite actor, float longest, float bx, float by, boolean partial, boolean shortcut) {
        Vector2f translation = actor.getActor().getTranslation();
        return this.getEntryPath(actor, longest, translation.x, translation.y, bx, by, partial, shortcut);
    }

    public Vector2f[] getEntryPath(ActorSprite actor, float longest, float ax, float ay, float bx, float by, boolean partial, boolean shortcut) {
        return this.getPath(false, actor, longest, ax, ay, bx, by, partial, shortcut);
    }

    public Vector2f[] getPath(ActorSprite actor, float longest, float bx, float by, boolean partial, boolean shortcut) {
        Vector2f translation = actor.getActor().getTranslation();
        System.out.println("source=" + translation + ",target=[" + bx + "," + by + "]");
        return this.getPath(actor, longest, translation.x, translation.y, bx, by, partial, shortcut);
    }

    public Vector2f[] getPath(ActorSprite actor, float longest, float ax, float ay, float bx, float by, boolean partial, boolean shortcut) {
        return this.getPath(true, actor, longest, ax, ay, bx, by, partial, shortcut);
    }

    @Override
    public void entryAdded(TudeySceneModel.Entry entry) {
        this.addFlags(entry);
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        this.removeFlags(oentry);
        this.addFlags(nentry);
    }

    @Override
    public void entryRemoved(TudeySceneModel.Entry oentry) {
        this.removeFlags(oentry);
    }

    protected Vector2f[] getPath(boolean collideActor, ActorSprite logic, float longest, float ax, float ay, float bx, float by, boolean partial, boolean shortcut) {
        Object pred;
        Vector2f start = new Vector2f(ax, ay);
        if (ax == bx && ay == by) {
            return new Vector2f[]{start};
        }
        Vector2f end = new Vector2f(bx, by);
        if (!this.sweptShapeCollides(collideActor, logic, start, end)) {
            return new Vector2f[]{start, end};
        }
        Rect bounds = logic.getShapeElement().getBounds();
        int width = Math.max(1, FloatMath.iceil(bounds.getWidth() * 2.0f));
        int height = Math.max(1, FloatMath.iceil(bounds.getHeight() * 2.0f));
        Actor actor = logic.getActor();
        final int collisionMask = actor.getCollisionMask();
        if (width == 1 && height == 1) {
            pred = collideActor ? new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    return (collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)x, (int)2), MathUtil.floorDiv((int)y, (int)2))) == 0 && (collisionMask & Pathfinder.this._actorFlags.get(x, y)) == 0;
                }
            } : new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    return (collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)x, (int)2), MathUtil.floorDiv((int)y, (int)2))) == 0;
                }
            };
        } else {
            final int left = width / 2;
            final int right = (width - 1) / 2;
            final int bottom = height / 2;
            final int top = (height - 1) / 2;
            pred = collideActor ? new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    int yymax = y + top;
                    for (int yy = y - bottom; yy <= yymax; ++yy) {
                        int xxmax = x + right;
                        for (int xx = x - left; xx <= xxmax; ++xx) {
                            if ((collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)xx, (int)2), MathUtil.floorDiv((int)yy, (int)2))) == 0 && (collisionMask & Pathfinder.this._actorFlags.get(xx, yy)) == 0) continue;
                            return false;
                        }
                    }
                    return true;
                }
            } : new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    int yymax = y + top;
                    for (int yy = y - bottom; yy <= yymax; ++yy) {
                        int xxmax = x + right;
                        for (int xx = x - left; xx <= xxmax; ++xx) {
                            if ((collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)xx, (int)2), MathUtil.floorDiv((int)yy, (int)2))) == 0) continue;
                            return false;
                        }
                    }
                    return true;
                }
            };
        }
        float xoff = (float)(width % 2) * 0.5f / 2.0f;
        float yoff = (float)(height % 2) * 0.5f / 2.0f;
        List path = AStarPathUtil.getPath((AStarPathUtil.TraversalPred)pred, (Object)actor, (int)((int)longest), (int)Math.round((ax *= 2.0f) - xoff), (int)Math.round((ay *= 2.0f) - yoff), (int)Math.round((bx *= 2.0f) - xoff), (int)Math.round((by *= 2.0f) - yoff), (boolean)partial);
        if (path == null) {
            return null;
        }
        Vector2f[] waypoints = new Vector2f[path.size()];
        for (int ii = 0; ii < waypoints.length; ++ii) {
            Point pt = (Point)path.get(ii);
            waypoints[ii] = new Vector2f(((float)pt.x + xoff) / 2.0f, ((float)pt.y + yoff) / 2.0f);
        }
        if (!shortcut) {
            return waypoints;
        }
        Vector2f current = start;
        int ii = 0;
        block1: while (ii < waypoints.length) {
            for (int jj = waypoints.length - 1; jj >= ii; --jj) {
                Vector2f waypoint = waypoints[jj];
                if (jj != ii && this.sweptShapeCollides(collideActor, logic, current, waypoint)) continue;
                current = waypoint;
                this._waypoints.add(current);
                ii = jj + 1;
                continue block1;
            }
        }
        waypoints = this._waypoints.toArray(new Vector2f[this._waypoints.size()]);
        this._waypoints.clear();
        return waypoints;
    }

    protected boolean sweptShapeCollides(boolean collideActor, ActorSprite logic, Vector2f start, Vector2f end) {
        this._worldShape = logic.getShapeElement().getLocalShape().transform(this._transform.set(start, logic.getActor().getRotation()), this._worldShape);
        this._sweptShape = this._worldShape.sweep(end.subtract(start, this._translation), this._sweptShape);
        if (!collideActor) {
            return this._view.getSceneModel().collides(logic.getActor(), this._sweptShape);
        }
        return this._view.collides(logic.getActor(), this._sweptShape);
    }

    protected void addFlags(TudeySceneModel.Entry entry) {
        int yy;
        if (!(entry instanceof TudeySceneModel.TileEntry)) {
            ConfigManager cfgmgr = this._view.getSceneModel().getConfigManager();
            Shape shape = entry.createShape(cfgmgr);
            if (shape != null) {
                this.addFlags(shape, entry.getCollisionFlags(cfgmgr), true);
            }
            return;
        }
        TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
        TileConfig.Original config = tentry.getConfig(this._view.getSceneModel().getConfigManager());
        tentry.getRegion(config, this._region);
        int yymax = yy + this._region.height;
        for (yy = this._region.y; yy < yymax; ++yy) {
            int xx;
            int xxmax = xx + this._region.width;
            for (xx = this._region.x; xx < xxmax; ++xx) {
                int flags = tentry.getCollisionFlags(config, xx, yy);
                if (flags == 0) continue;
                this._entryFlags.setBits(xx, yy, flags);
            }
        }
    }

    protected void removeFlags(TudeySceneModel.Entry entry) {
        int yy;
        if (!(entry instanceof TudeySceneModel.TileEntry)) {
            ConfigManager cfgmgr = this._view.getSceneModel().getConfigManager();
            Shape shape = entry.createShape(cfgmgr);
            if (shape != null) {
                this.removeFlags(shape, entry.getCollisionFlags(cfgmgr), true, null);
            }
            return;
        }
        TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
        TileConfig.Original config = tentry.getConfig(this._view.getSceneModel().getConfigManager());
        tentry.getRegion(config, this._region);
        int yymax = yy + this._region.height;
        for (yy = this._region.y; yy < yymax; ++yy) {
            int xx;
            int xxmax = xx + this._region.width;
            for (xx = this._region.x; xx < xxmax; ++xx) {
                int flags = tentry.getCollisionFlags(config, xx, yy);
                if (flags == 0) continue;
                this.updateQuad(xx, yy);
                this.updateEntryFlags(xx, yy, null);
            }
        }
    }

    protected void addFlags(Shape shape, int flags, boolean entry) {
        if (flags == 0) {
            return;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                if (entry) {
                    this.updateQuad(xx, yy);
                    if (!shape.intersects(this._quad)) continue;
                    this._entryFlags.setBits(xx, yy, flags);
                    continue;
                }
                for (int ys = 0; ys < 2; ++ys) {
                    for (int xs = 0; xs < 2; ++xs) {
                        this.updateQuadSubdivision(xx, yy, xs, ys);
                        if (!shape.intersects(this._quad)) continue;
                        int sx = xx * 2 + xs;
                        int sy = yy * 2 + ys;
                        this._actorFlags.setBits(sx, sy, flags);
                        int coord = Coord.encode(sx, sy);
                        List list = (List)this._actorFlagLists.get(coord);
                        if (list == null) {
                            list = Lists.newArrayListWithCapacity((int)1);
                            this._actorFlagLists.put(coord, (Object)list);
                        }
                        list.add(flags);
                    }
                }
            }
        }
    }

    protected void removeFlags(Shape shape, int flags, boolean entry, SpaceElement skip) {
        if (flags == 0) {
            return;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                if (entry) {
                    this.updateQuad(xx, yy);
                    if (!shape.intersects(this._quad)) continue;
                    this.updateEntryFlags(xx, yy, skip);
                    continue;
                }
                for (int ys = 0; ys < 2; ++ys) {
                    for (int xs = 0; xs < 2; ++xs) {
                        int sy;
                        int sx;
                        int coord;
                        List list;
                        this.updateQuadSubdivision(xx, yy, xs, ys);
                        if (!shape.intersects(this._quad) || (list = (List)this._actorFlagLists.get(coord = Coord.encode(sx = xx * 2 + xs, sy = yy * 2 + ys))) == null) continue;
                        list.remove((Object)flags);
                        int nsize = list.size();
                        if (nsize == 0) {
                            this._actorFlagLists.remove(coord);
                            this._actorFlags.remove(sx, sy);
                            continue;
                        }
                        int combined = 0;
                        for (int ii = 0; ii < nsize; ++ii) {
                            combined |= ((Integer)list.get(ii)).intValue();
                        }
                        this._actorFlags.put(sx, sy, combined);
                    }
                }
            }
        }
    }

    protected void updateQuad(int x, int y) {
        this.updateQuad(x, y, x + 1, y + 1);
    }

    protected void updateQuadSubdivision(int x, int y, int xs, int ys) {
        this.updateQuad((float)x + (float)xs / 2.0f, (float)y + (float)ys / 2.0f, (float)x + (float)(xs + 1) / 2.0f, (float)y + (float)(ys + 1) / 2.0f);
    }

    protected void updateQuad(float lx, float ly, float ux, float uy) {
        this._quad.getVertex(0).set(lx += 2.0E-6f, ly += 2.0E-6f);
        this._quad.getVertex(1).set(ux -= 2.0E-6f, ly);
        this._quad.getVertex(2).set(ux, uy -= 2.0E-6f);
        this._quad.getVertex(3).set(lx, uy);
        this._quad.getBounds().getMinimumExtent().set(lx, ly);
        this._quad.getBounds().getMaximumExtent().set(ux, uy);
    }

    protected void updateEntryFlags(int x, int y, SpaceElement skip) {
        TudeySceneModel model = this._view.getSceneModel();
        int flags = model.getCollisionFlags().get(x, y);
        model.getSpace().getIntersecting(this._quad, this._elements);
        ConfigManager cfgmgr = this._view.getSceneModel().getConfigManager();
        int nn = this._elements.size();
        for (int ii = 0; ii < nn; ++ii) {
            SpaceElement element = this._elements.get(ii);
            if (element == skip) continue;
            flags |= ((TudeySceneModel.Entry)element.getUserObject()).getCollisionFlags(cfgmgr);
        }
        this._elements.clear();
        this._entryFlags.put(x, y, flags);
    }
}

