/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.config.ConfigReference;
import com.threerings.opengl.gui.Button;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.Label;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.Selectable;
import com.threerings.opengl.gui.ToggleButton;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import com.threerings.opengl.gui.layout.BorderLayout;
import com.threerings.opengl.gui.layout.GroupLayout;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import java.util.ArrayList;

public class TabbedPane
extends Container
implements Selectable<Component> {
    protected ActionListener _selector = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                TabbedPane.this.selectTab(Integer.parseInt(event.getAction()), event.getWhen(), event.getModifiers());
            }
            catch (Exception e) {
                Log.log.warning((Object)"Exception thrown handling selection event.", new Object[]{"event", event, e});
            }
        }
    };
    protected ActionListener _closer = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TabbedPane.this._selidx >= 0) {
                TabbedPane.this.removeTab(TabbedPane.this._selidx, true);
            }
        }
    };
    protected ArrayList<Tab> _tabs = new ArrayList();
    protected int _selidx = -1;
    protected Container _top;
    protected Container _buttons;
    protected Button _close;

    public TabbedPane(GlContext ctx) {
        this(ctx, GroupLayout.LEFT);
    }

    public TabbedPane(GlContext ctx, GroupLayout.Justification tabAlign) {
        this(ctx, tabAlign, 5);
    }

    public TabbedPane(GlContext ctx, GroupLayout.Justification tabAlign, int gap) {
        super(ctx, new BorderLayout());
        GroupLayout gl = GroupLayout.makeHoriz(GroupLayout.STRETCH, GroupLayout.LEFT, GroupLayout.CONSTRAIN);
        this._top = new Container(this._ctx, gl);
        gl = GroupLayout.makeHoriz(GroupLayout.CONSTRAIN, tabAlign, GroupLayout.CONSTRAIN);
        this._buttons = new Container(this._ctx, gl){

            @Override
            protected void renderComponent(Renderer renderer) {
                int nn = this.getComponentCount();
                for (int ii = 0; ii < nn; ++ii) {
                    if (ii == TabbedPane.this._selidx) continue;
                    this.getComponent(ii).render(renderer);
                }
                if (TabbedPane.this._selidx != -1) {
                    this.getComponent(TabbedPane.this._selidx).render(renderer);
                }
            }
        };
        this._top.add(this._buttons);
        gl.setGap(gap);
        this.add(this._top, BorderLayout.NORTH);
        this._close = new Button(this._ctx, "", this._closer, "close");
        this._close.setStyleConfig("Default/TabbedPaneClose");
    }

    public void setTabAlignment(GroupLayout.Justification tabAlign) {
        ((GroupLayout)this._buttons.getLayoutManager()).setJustification(tabAlign);
    }

    public void setGap(int gap) {
        ((GroupLayout)this._buttons.getLayoutManager()).setGap(gap);
    }

    public void addTab(String title, Component tab) {
        this.addTab(title, tab, false);
    }

    public void addTab(String title, Component tab, boolean hasClose) {
        this.addTab(title, tab, hasClose, null);
    }

    public void addTab(String title, Component tab, boolean hasClose, ConfigReference<StyleConfig> style) {
        ToggleButton tbutton = new ToggleButton(this._ctx, title, String.valueOf(this._tabs.size())){

            @Override
            protected void fireAction(long when, int modifiers) {
                if (!this._selected) {
                    super.fireAction(when, modifiers);
                }
            }
        };
        if (style == null) {
            tbutton.setStyleConfig("Default/Tab");
        } else {
            tbutton.setStyleConfig(style);
        }
        tbutton.addListener(this._selector);
        tbutton.setFit(Label.Fit.TRUNCATE);
        this._buttons.add(tbutton);
        this._tabs.add(new Tab(title, hasClose, tab));
        if (this._selidx == -1) {
            this.setSelectedIndex(0);
        }
    }

    public void replaceTab(Component otab, Component ntab) {
        int idx = this.indexOfTab(otab);
        if (idx != -1) {
            this.replaceTab(idx, ntab);
        } else {
            Log.log.warning((Object)"Requested to replace non-added tab.", new Object[]{"pane", this, "tab", otab});
        }
    }

    public void replaceTab(int tabidx, Component ntab) {
        Tab tab = this._tabs.get(tabidx);
        if (this._selidx == tabidx) {
            this.remove(tab.component);
            this.add(ntab, BorderLayout.CENTER);
        }
        tab.component = ntab;
    }

    public void removeTab(Component tab) {
        int idx = this.indexOfTab(tab);
        if (idx != -1) {
            this.removeTab(idx);
        } else {
            Log.log.warning((Object)"Requested to remove non-added tab", new Object[]{"pane", this, "tab", tab});
        }
    }

    public void removeTab(int tabidx) {
        this.removeTab(tabidx, false);
    }

    public void removeTab(int tabidx, boolean btnClose) {
        this._buttons.remove(this._buttons.getComponent(tabidx));
        Tab tab = this._tabs.remove(tabidx);
        if (this._selidx == tabidx) {
            this.remove(tab.component);
            this._selidx = -1;
            if (this._close.getParent() != null) {
                this._top.remove(this._close);
            }
            if (tabidx < this._tabs.size()) {
                this.setSelectedIndex(tabidx);
            } else {
                this.setSelectedIndex(tabidx - 1);
            }
        } else if (this._selidx > tabidx) {
            --this._selidx;
        }
        this.tabWasRemoved(tab.component, btnClose);
    }

    public void removeAllTabs() {
        if (this._selidx != -1) {
            this.remove(this._tabs.get((int)this._selidx).component);
        }
        this._selidx = -1;
        this._buttons.removeAll();
        this._tabs.clear();
    }

    public int getTabCount() {
        return this._tabs.size();
    }

    @Override
    public Component getSelected() {
        return this._selidx == -1 ? null : this._tabs.get((int)this._selidx).component;
    }

    @Override
    public void setSelected(Component tab) {
        this.setSelectedIndex(this.indexOfTab(tab));
    }

    @Override
    public int getSelectedIndex() {
        return this._selidx;
    }

    @Override
    public void setSelectedIndex(int index) {
        this.selectTab(index, -1L, 0);
    }

    public ToggleButton getTabButton(Component tab) {
        int idx = this.indexOfTab(tab);
        return idx == -1 ? null : this.getTabButton(idx);
    }

    public ToggleButton getTabButton(int idx) {
        return (ToggleButton)this._buttons.getComponent(idx);
    }

    public Component getTab(int idx) {
        return this._tabs.get((int)idx).component;
    }

    public int indexOfTab(Component tab) {
        for (int ii = 0; ii < this._tabs.size(); ++ii) {
            if (this._tabs.get((int)ii).component != tab) continue;
            return ii;
        }
        return -1;
    }

    protected void selectTab(int tabidx, long when, int modifiers) {
        if (tabidx == this._selidx) {
            return;
        }
        tabidx = Math.max(0, Math.min(this._tabs.size() - 1, tabidx));
        for (int ii = 0; ii < this._tabs.size(); ++ii) {
            this.getTabButton(ii).setSelected(ii == tabidx);
        }
        if (this._selidx != -1) {
            this.remove(this._tabs.get((int)this._selidx).component);
        }
        Tab tab = this._tabs.get(tabidx);
        this.add(tab.component, BorderLayout.CENTER);
        this.updateClose(tab.close);
        this._selidx = tabidx;
        this.emitEvent(new ActionEvent(this, when, modifiers, "select", tab.component));
    }

    protected void updateClose(boolean showClose) {
        if (showClose && this._close.getParent() == null) {
            this._top.add(this._close, GroupLayout.FIXED);
        } else if (!showClose && this._close.getParent() != null) {
            this._top.remove(this._close);
        }
    }

    protected void tabWasRemoved(Component tab, boolean btnClose) {
        int ll = this._buttons.getComponentCount();
        for (int ii = 0; ii < ll; ++ii) {
            this.getTabButton(ii).setAction("" + ii);
        }
    }

    @Override
    protected String getDefaultStyleConfig() {
        return "Default/TabbedPane";
    }

    protected static class Tab {
        public String title;
        public boolean close;
        public Component component;

        public Tab(String title, boolean close, Component component) {
            this.title = title;
            this.close = close;
            this.component = component;
        }
    }
}

