/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect;

import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.util.DeepObject;

@EditorTypes(value={None.class, QuadraticIn.class, QuadraticOut.class, QuadraticInAndOut.class})
public abstract class Easing
extends DeepObject
implements Exportable,
Streamable {
    public abstract float getTime(float var1);

    public abstract Easing copy(Easing var1);

    public static class QuadraticInAndOut
    extends Easing {
        @Override
        public float getTime(float t) {
            return t <= 0.5f ? 2.0f * t * t : 2.0f * t * (2.0f - t) - 1.0f;
        }

        @Override
        public Easing copy(Easing result) {
            return result instanceof QuadraticInAndOut ? result : new QuadraticInAndOut();
        }
    }

    public static class QuadraticOut
    extends Easing {
        @Override
        public float getTime(float t) {
            return t * (2.0f - t);
        }

        @Override
        public Easing copy(Easing result) {
            return result instanceof QuadraticOut ? result : new QuadraticOut();
        }
    }

    public static class QuadraticIn
    extends Easing {
        @Override
        public float getTime(float t) {
            return t * t;
        }

        @Override
        public Easing copy(Easing result) {
            return result instanceof QuadraticIn ? result : new QuadraticIn();
        }
    }

    public static class None
    extends Easing {
        @Override
        public float getTime(float t) {
            return t;
        }

        @Override
        public Easing copy(Easing result) {
            return result instanceof None ? result : new None();
        }
    }
}

