/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.math.Vector3f;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.tudey.client.cursor.TileCursor;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.ConfigTool;
import com.threerings.tudey.tools.EditorTool;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.TudeyContext;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;

public class TileBrush
extends ConfigTool<TileConfig> {
    protected TudeySceneModel.TileEntry _entry = new TudeySceneModel.TileEntry();
    protected TileCursor _cursor;
    protected boolean _cursorVisible;
    protected EditorTool.DirectionalConstraint _constraint;
    protected Coord _lastPlacement = new Coord();
    protected Vector3f _isect = new Vector3f();

    public TileBrush(SceneEditor editor) {
        super(editor, TileConfig.class, new TileReference());
    }

    public void setRotation(int rotation) {
        this._entry.rotation = rotation;
    }

    @Override
    public void init() {
        this._cursor = new TileCursor((TudeyContext)this._editor, this._editor.getView(), this._entry);
    }

    @Override
    public void tick(float elapsed) {
        this.updateCursor();
        if (this._cursorVisible) {
            this._cursor.tick(elapsed);
        } else if (this._editor.isThirdButtonDown() && !this._editor.isSpecialDown()) {
            this._editor.deleteMouseEntry(SceneEditor.TILE_ENTRY_FILTER);
        }
    }

    @Override
    public void composite() {
        if (this._cursorVisible) {
            this._cursor.composite();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        boolean erase;
        int button = event.getButton();
        boolean paint = button == 1;
        boolean bl = erase = button == 3;
        if (!this._editor.isSpecialDown() && (paint || erase) && this._cursorVisible) {
            this.paintTile(erase);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this._cursorVisible) {
            this._entry.rotation = this._entry.rotation + event.getWheelRotation() & 3;
        }
    }

    protected void updateCursor() {
        this._cursorVisible = this._entry.tile != null && this.getMousePlaneIntersection(this._isect) && !this._editor.isSpecialDown();
        if (!this._cursorVisible) {
            return;
        }
        TileConfig.Original config = this._entry.getConfig(this._editor.getConfigManager());
        int width = this._entry.getWidth(config);
        int height = this._entry.getHeight(config);
        Coord location = this._entry.getLocation();
        int x = Math.round(this._isect.x - (float)width * 0.5f);
        int y = Math.round(this._isect.y - (float)height * 0.5f);
        if (this._editor.isShiftDown()) {
            if (this._constraint == EditorTool.DirectionalConstraint.HORIZONTAL) {
                y = location.y;
            } else if (this._constraint == EditorTool.DirectionalConstraint.VERTICAL) {
                x = location.x;
            } else if (x != location.x && y == location.y) {
                this._constraint = EditorTool.DirectionalConstraint.HORIZONTAL;
            } else if (x == location.x && y != location.y) {
                this._constraint = EditorTool.DirectionalConstraint.VERTICAL;
            }
        } else {
            this._constraint = null;
        }
        location.set(x, y);
        this._entry.elevation = this._editor.getGrid().getElevation();
        this._cursor.update((TudeySceneModel.Entry)this._entry);
        boolean paint = this._editor.isFirstButtonDown();
        boolean erase = this._editor.isThirdButtonDown();
        if ((paint || erase) && !location.equals(this._lastPlacement)) {
            if (erase) {
                this.paintTile(true);
            } else if (Math.abs(location.x - this._lastPlacement.x) >= width || Math.abs(location.y - this._lastPlacement.y) >= height) {
                this.paintTile(false);
            }
        }
    }

    protected void paintTile(boolean erase) {
        Rectangle region = new Rectangle();
        this._entry.getRegion(this._entry.getConfig(this._editor.getConfigManager()), region);
        ArrayList underneath = new ArrayList();
        this._scene.getTileEntries(region, underneath);
        this._editor.removeEntries(underneath);
        if (!erase) {
            this._editor.addEntries(new TudeySceneModel.Entry[]{(TudeySceneModel.TileEntry)this._entry.clone()});
        }
        this._lastPlacement.set(this._entry.getLocation());
    }

    @Override
    protected void referenceChanged(ConfigReference<TileConfig> ref) {
        this._entry.tile = ref;
    }

    protected static class TileReference
    extends ConfigTool.EditableReference<TileConfig> {
        @Editable(nullable=true)
        public ConfigReference<TileConfig> tile;

        protected TileReference() {
        }

        @Override
        public ConfigReference<TileConfig> getReference() {
            return this.tile;
        }

        @Override
        public void setReference(ConfigReference<TileConfig> ref) {
            this.tile = ref;
        }
    }
}

