/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.threerings.editor.Editable;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.editor.util.EditorContext;
import com.threerings.export.Exportable;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.client.util.ShapeSceneElement;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.tools.EditorTool;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.tudey.util.TudeySceneMetrics;
import com.threerings.util.DeepObject;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class Selector
extends EditorTool {
    protected Options _options = new Options();
    protected ShapeSceneElement _cursor;
    protected boolean _cursorVisible;
    protected boolean _dragging;
    protected Vector3f _anchor = new Vector3f();
    protected Vector3f _isect = new Vector3f();
    protected ArrayList<TudeySceneModel.Entry> _entries = new ArrayList();

    public Selector(SceneEditor editor) {
        super(editor);
        EditorPanel epanel = new EditorPanel((EditorContext)editor);
        this.add((Component)epanel);
        epanel.setObject((Object)this._options);
    }

    @Override
    public void init() {
        this._cursor = new ShapeSceneElement((GlContext)this._editor, true);
        this._cursor.setShape((Shape)new Polygon(4));
    }

    @Override
    public void tick(float elapsed) {
        this.updateSelection();
    }

    @Override
    public void composite() {
        if (this._cursorVisible) {
            this._cursor.composite();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.getButton() != 1 || this._editor.isSpecialDown()) {
            return;
        }
        TudeySceneModel.Entry entry = this._editor.getMouseEntry();
        if (entry != null && this._editor.isSelected(entry)) {
            this._editor.moveSelection();
        } else if (this.getMousePlaneIntersection(this._isect)) {
            this._editor.clearSelection();
            this._anchor.set(this._isect);
            this._dragging = true;
        }
    }

    protected void updateSelection() {
        this._cursorVisible = this._dragging && this._editor.isFirstButtonDown() && this.getMousePlaneIntersection(this._isect) && !this._editor.isSpecialDown();
        if (!this._cursorVisible) {
            this._dragging = false;
            return;
        }
        if (this._anchor.equals((Object)this._isect)) {
            this._cursorVisible = false;
        }
        boolean gx = this._isect.x >= this._anchor.x;
        boolean gy = this._isect.y >= this._anchor.y;
        Polygon shape = (Polygon)this._cursor.getShape();
        Vector2f corner = shape.getVertex(0);
        if (!this._editor.isShiftDown()) {
            corner.x = gx ? FloatMath.floor((float)this._anchor.x) + 0.01f : FloatMath.ceil((float)this._anchor.x) - 0.01f;
            corner.y = gy ? FloatMath.floor((float)this._anchor.y) + 0.01f : FloatMath.ceil((float)this._anchor.y) - 0.01f;
            this._isect.x = gx ? FloatMath.ceil((float)this._isect.x) - 0.01f : FloatMath.floor((float)this._isect.x) + 0.01f;
            this._isect.y = gy ? FloatMath.ceil((float)this._isect.y) - 0.01f : FloatMath.floor((float)this._isect.y) + 0.01f;
        } else {
            corner.set(this._anchor.x, this._anchor.y);
        }
        shape.getVertex(2).set(this._isect.x, this._isect.y);
        if (gx ^ gy) {
            shape.getVertex(1).set(corner.x, this._isect.y);
            shape.getVertex(3).set(this._isect.x, corner.y);
        } else {
            shape.getVertex(1).set(this._isect.x, corner.y);
            shape.getVertex(3).set(corner.x, this._isect.y);
        }
        shape.updateBounds();
        this._cursor.getTransform().getTranslation().z = TudeySceneMetrics.getTileZ(this._editor.getGrid().getElevation());
        this._scene.getEntries((Shape)shape, Predicates.and((Predicate)this._options.filter, this._editor.getLayerPredicate()), this._entries);
        if (!Selector.keysEqual(this._entries, this._editor.getSelection())) {
            this._editor.setSelection(this._entries.toArray(new TudeySceneModel.Entry[this._entries.size()]));
        }
        this._entries.clear();
    }

    protected static boolean keysEqual(ArrayList<TudeySceneModel.Entry> list, TudeySceneModel.Entry[] array) {
        if (list.size() != array.length) {
            return false;
        }
        int ii = 0;
        while (ii < array.length) {
            if (!list.get(ii).getKey().equals(array[ii].getKey())) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    protected static class Options
    extends DeepObject
    implements Exportable {
        @Editable
        public EditorTool.Filter filter = new EditorTool.Filter();

        protected Options() {
        }
    }
}

