/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.common.collect.Lists;
import com.threerings.config.ConfigManager;
import com.threerings.export.BinaryImporter;
import com.threerings.resource.ResourceManager;
import com.threerings.tudey.Log;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.util.MessageManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SceneValidatorTask
extends Task {
    protected List<FileSet> _filesets = Lists.newArrayList();

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    public void execute() throws BuildException {
        ResourceManager rsrcmgr = new ResourceManager("rsrc/");
        MessageManager msgmgr = new MessageManager("rsrc.i18n");
        rsrcmgr.initResourceDir("rsrc/");
        ConfigManager cfgmgr = new ConfigManager(rsrcmgr, msgmgr, "config/");
        cfgmgr.init();
        boolean valid = true;
        for (FileSet fs : this._filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            String[] stringArray = ds.getIncludedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File source = new File(fromDir, file);
                try {
                    TudeySceneModel model = (TudeySceneModel)new BinaryImporter((InputStream)new FileInputStream(source)).readObject();
                    model.getConfigManager().init("scene", cfgmgr);
                    valid = model.validateReferences(file, System.err) && valid;
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Failed to read scene.", new Object[]{"file", source, e});
                }
                ++n2;
            }
        }
    }
}

