/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.common.base.Predicates;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.math.FloatMath;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.tudey.client.cursor.PlaceableCursor;
import com.threerings.tudey.config.PlaceableConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.tools.ConfigTool;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.tudey.util.TudeyContext;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;

public class Placer
extends ConfigTool<PlaceableConfig> {
    protected TudeySceneModel.PlaceableEntry _entry = new TudeySceneModel.PlaceableEntry();
    protected PlaceableCursor _cursor;
    protected boolean _cursorVisible;
    protected float _angle;
    protected Vector3f _lastPlacement = new Vector3f();
    protected Vector3f _isect = new Vector3f();
    protected ArrayList<TudeySceneModel.Entry> _entries = new ArrayList();
    protected static final float MIN_SPACING = 0.5f;

    public Placer(SceneEditor editor) {
        super(editor, PlaceableConfig.class, new PlaceableReference());
        this._entry.transform.setType(2);
    }

    public void setAngle(float angle) {
        this._angle = angle;
    }

    @Override
    public void init() {
        this._cursor = new PlaceableCursor((TudeyContext)this._editor, this._editor.getView(), this._entry);
    }

    @Override
    public void tick(float elapsed) {
        this.updateCursor();
        if (this._cursorVisible) {
            this._cursor.tick(elapsed);
        } else if (this._editor.isThirdButtonDown() && !this._editor.isSpecialDown()) {
            this._editor.deleteMouseEntry(SceneEditor.PLACEABLE_ENTRY_FILTER);
        }
    }

    @Override
    public void composite() {
        if (this._cursorVisible) {
            this._cursor.composite();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.getButton() == 1 && this._cursorVisible) {
            this.placeEntry();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this._cursorVisible) {
            float increment = event.isShiftDown() ? FINE_ROTATION_INCREMENT : 1.5707964f;
            this._angle = (float)(Math.round(this._angle / increment) + event.getWheelRotation()) * increment;
        }
    }

    protected void updateCursor() {
        this._cursorVisible = this._entry.placeable != null && this.getMousePlaneIntersection(this._isect) && !this._editor.isSpecialDown();
        if (!this._cursorVisible) {
            return;
        }
        if (!this._editor.isShiftDown()) {
            this._isect.x = FloatMath.floor((float)this._isect.x) + 0.5f;
            this._isect.y = FloatMath.floor((float)this._isect.y) + 0.5f;
        }
        Transform3D transform = this._entry.transform;
        transform.getTranslation().set(this._isect.x, this._isect.y, this._editor.getGrid().getZ());
        transform.getRotation().fromAngleAxis(this._angle, Vector3f.UNIT_Z);
        this._cursor.update((TudeySceneModel.Entry)this._entry);
        if (this._editor.isThirdButtonDown()) {
            Shape shape = this._cursor.getShape();
            if (shape != null) {
                this._scene.getEntries(shape, Predicates.and(SceneEditor.PLACEABLE_ENTRY_FILTER, this._editor.getLayerPredicate()), this._entries);
                this._editor.removeEntries(this._entries);
                this._entries.clear();
            }
        } else if (this._editor.isFirstButtonDown() && transform.getTranslation().distance(this._lastPlacement) >= 0.5f) {
            this.placeEntry();
        }
    }

    protected void placeEntry() {
        TudeySceneModel.PlaceableEntry entry = (TudeySceneModel.PlaceableEntry)this._entry.clone();
        PlaceableConfig.Original config = entry.getConfig(this._editor.getConfigManager());
        entry.transform.getRotation().multLocal(config.rotationOffset.getValue(new Quaternion()));
        this._editor.addEntries(new TudeySceneModel.Entry[]{entry});
        this._lastPlacement.set(entry.transform.getTranslation());
    }

    @Override
    protected void referenceChanged(ConfigReference<PlaceableConfig> ref) {
        this._entry.placeable = ref;
    }

    protected static class PlaceableReference
    extends ConfigTool.EditableReference<PlaceableConfig> {
        @Editable(nullable=true)
        public ConfigReference<PlaceableConfig> placeable;

        protected PlaceableReference() {
        }

        @Override
        public ConfigReference<PlaceableConfig> getReference() {
            return this.placeable;
        }

        @Override
        public void setReference(ConfigReference<PlaceableConfig> ref) {
            this.placeable = ref;
        }
    }
}

