/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.samskivert.swing.GroupLayout;
import com.threerings.export.XMLExporter;
import com.threerings.export.XMLImporter;
import com.threerings.swing.PrefsTree;
import com.threerings.swing.PrefsTreeNode;
import com.threerings.tudey.Log;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.BaseMover;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.util.DeepUtil;
import com.threerings.util.ToolUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public class Palette
extends BaseMover
implements TreeSelectionListener,
ActionListener {
    protected PrefsTree _tree = new PrefsTree(_prefs.node("palette"));
    protected JButton _delete;
    protected JFileChooser _chooser;
    protected static Preferences _prefs = Preferences.userNodeForPackage(Palette.class);

    public Palette(SceneEditor editor) {
        super(editor);
        this.add(new JScrollPane((Component)this._tree));
        this._tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._tree.addTreeSelectionListener((TreeSelectionListener)this);
        JPanel bpanel = new JPanel();
        this.add((Component)bpanel, GroupLayout.FIXED);
        bpanel.add(ToolUtil.createButton(this, this._msgs, "new_folder"));
        this._delete = ToolUtil.createButton(this, this._msgs, "delete");
        bpanel.add(this._delete);
        this._delete.setEnabled(false);
        JPanel epanel = new JPanel();
        this.add((Component)epanel, GroupLayout.FIXED);
        epanel.add(ToolUtil.createButton(this, this._msgs, "import_short"));
        epanel.add(ToolUtil.createButton(this, this._msgs, "export_short"));
        this._chooser = new JFileChooser(_prefs.get("palette_export_dir", null));
        this._chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.toString().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return Palette.this._msgs.get("m.xml_files");
            }
        });
    }

    public void add(TudeySceneModel.Entry ... entries) {
        this._tree.insertNewNode(this._msgs.get("m.new_entry"), (Object)DeepUtil.copy(entries));
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        PrefsTreeNode node = this._tree.getSelectedNode();
        if (node != null && node.getValue() != null) {
            this.move((TudeySceneModel.Entry[])node.getValue());
        } else {
            this.clear();
        }
        this._delete.setEnabled(node != null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals("new_folder")) {
            this._tree.insertNewNode(this._msgs.get("m.new_folder"), null);
        } else if (action.equals("delete")) {
            this._tree.removeSelectedNode();
        } else if (action.equals("import_short")) {
            this.importPalette();
        } else {
            this.exportPalette();
        }
    }

    protected void importPalette() {
        if (this._chooser.showOpenDialog(this._editor.getFrame()) == 0) {
            File file = this._chooser.getSelectedFile();
            try {
                XMLImporter in = new XMLImporter((InputStream)new FileInputStream(file));
                this.merge(this._tree.getRootNode(), (PrefsTreeNode)in.readObject());
                in.close();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to import palette.", new Object[]{"file", file, e});
            }
        }
        _prefs.put("palette_export_dir", this._chooser.getCurrentDirectory().toString());
    }

    protected void exportPalette() {
        if (this._chooser.showSaveDialog(this._editor.getFrame()) == 0) {
            File file = this._chooser.getSelectedFile();
            try {
                XMLExporter out = new XMLExporter((OutputStream)new FileOutputStream(file));
                out.writeObject((Object)this._tree.getRootNode());
                out.close();
            }
            catch (IOException e) {
                Log.log.warning((Object)"Failed to export palette.", new Object[]{"file", file, e});
            }
        }
        _prefs.put("palette_export_dir", this._chooser.getCurrentDirectory().toString());
    }

    protected void merge(PrefsTreeNode onode, PrefsTreeNode nnode) {
        PrefsTreeNode[] nchildren = new PrefsTreeNode[nnode.getChildCount()];
        int ii = 0;
        while (ii < nchildren.length) {
            nchildren[ii] = (PrefsTreeNode)nnode.getChildAt(ii);
            ++ii;
        }
        PrefsTreeNode[] prefsTreeNodeArray = nchildren;
        int n = nchildren.length;
        int n2 = 0;
        while (n2 < n) {
            PrefsTreeNode nchild = prefsTreeNodeArray[n2];
            PrefsTreeNode ochild = onode.getChild((String)nchild.getUserObject());
            if (ochild == null) {
                this._tree.insertNodeInto(nchild, onode);
            } else if (!ochild.getAllowsChildren() || !nchild.getAllowsChildren()) {
                this._tree.removeNodeFromParent(ochild);
                this._tree.insertNodeInto(nchild, onode);
            } else {
                this.merge(ochild, nchild);
            }
            ++n2;
        }
    }

    @Override
    public void calculateElevation(int minElevation, int maxElevation) {
        this._elevation = this._editor.getGrid().getElevation();
    }
}

