/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.common.base.Predicate;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.editor.Editable;
import com.threerings.export.Exportable;
import com.threerings.math.FloatMath;
import com.threerings.math.Ray3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.util.Tickable;
import com.threerings.tudey.Log;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.util.DeepObject;
import com.threerings.util.MessageBundle;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public abstract class EditorTool
extends JPanel
implements Tickable,
Compositable,
TudeySceneModel.Observer,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected SceneEditor _editor;
    protected MessageBundle _msgs;
    protected JToggleButton _button;
    protected TudeySceneModel _scene;
    protected Ray3D _pick = new Ray3D();
    protected static final float FINE_ROTATION_INCREMENT = FloatMath.toRadians((float)5.0f);

    public EditorTool(SceneEditor editor) {
        super((LayoutManager)new VGroupLayout(GroupLayout.STRETCH, GroupLayout.STRETCH, 5, GroupLayout.TOP));
        this._editor = editor;
        this._msgs = this._editor.getMessageManager().getBundle("scene");
    }

    public void setButton(JToggleButton button) {
        this._button = button;
    }

    public void init() {
    }

    public void activate() {
        this._button.setSelected(true);
        Component canvas = this._editor.getCanvas();
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        canvas.addMouseWheelListener(this);
    }

    public void deactivate() {
        Component canvas = this._editor.getCanvas();
        canvas.removeMouseListener(this);
        canvas.removeMouseMotionListener(this);
        canvas.removeMouseWheelListener(this);
    }

    public void sceneChanged(TudeySceneModel scene) {
        if (this._scene != null) {
            this._scene.removeObserver((TudeySceneModel.Observer)this);
        }
        this._scene = scene;
        this._scene.addObserver((TudeySceneModel.Observer)this);
    }

    public boolean allowsMouseCamera() {
        return false;
    }

    public void tick(float elapsed) {
    }

    public void composite() {
    }

    public void entryAdded(TudeySceneModel.Entry entry) {
    }

    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
    }

    public void entryRemoved(TudeySceneModel.Entry oentry) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
    }

    protected boolean getMousePlaneIntersection(Vector3f result) {
        return this._editor.getMouseRay(this._pick) && this._editor.getGrid().getPlane().getIntersection(this._pick, result);
    }

    protected static enum DirectionalConstraint {
        HORIZONTAL,
        VERTICAL;

    }

    protected static class Filter
    extends DeepObject
    implements Predicate<TudeySceneModel.Entry>,
    Exportable {
        @Editable(hgroup="t")
        public boolean tiles = true;
        @Editable(hgroup="t")
        public boolean placeables = true;
        @Editable(hgroup="p")
        public boolean paths = true;
        @Editable(hgroup="p")
        public boolean areas = true;

        protected Filter() {
        }

        public boolean apply(TudeySceneModel.Entry entry) {
            if (entry instanceof TudeySceneModel.TileEntry) {
                return this.tiles;
            }
            if (entry instanceof TudeySceneModel.PlaceableEntry) {
                return this.placeables;
            }
            if (entry instanceof TudeySceneModel.PathEntry) {
                return this.paths;
            }
            if (entry instanceof TudeySceneModel.AreaEntry) {
                return this.areas;
            }
            Log.log.warning((Object)"Unknown entry type.", new Object[]{"class", entry.getClass()});
            return true;
        }
    }
}

