/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.threerings.editor.swing.EditorPanel;
import com.threerings.editor.util.EditorContext;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.EditorTool;
import com.threerings.tudey.tools.SceneEditor;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Arrow
extends EditorTool
implements ChangeListener {
    protected EditorPanel _epanel;
    protected boolean _ignoreUpdate;

    public Arrow(SceneEditor editor) {
        super(editor);
        this._epanel = new EditorPanel((EditorContext)editor);
        this.add((Component)this._epanel);
        this._epanel.addChangeListener((ChangeListener)this);
    }

    public void edit(TudeySceneModel.Entry entry) {
        this._editor.setSelection(entry);
        this._epanel.setObject((Object)entry.clone());
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this._editor.incrementEditId();
        this._ignoreUpdate = true;
        try {
            TudeySceneModel.Entry entry = (TudeySceneModel.Entry)this._epanel.getObject();
            if (entry != null) {
                this._editor.updateEntries((TudeySceneModel.Entry)entry.clone());
            }
        }
        finally {
            this._ignoreUpdate = false;
        }
    }

    @Override
    public void sceneChanged(TudeySceneModel scene) {
        super.sceneChanged(scene);
        this._epanel.setObject(null);
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        if (this._ignoreUpdate) {
            return;
        }
        TudeySceneModel.Entry entry = (TudeySceneModel.Entry)this._epanel.getObject();
        if (entry != null && entry.getKey().equals(oentry.getKey())) {
            this._epanel.setObject((Object)nentry.clone());
        }
    }

    @Override
    public void entryRemoved(TudeySceneModel.Entry oentry) {
        TudeySceneModel.Entry entry = (TudeySceneModel.Entry)this._epanel.getObject();
        if (entry != null && entry.getKey().equals(oentry.getKey())) {
            this._epanel.setObject(null);
        }
    }

    @Override
    public void tick(float elapsed) {
        if (this._editor.isThirdButtonDown() && !this._editor.isSpecialDown()) {
            this._editor.deleteMouseEntry();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.getButton() == 1 && !this._editor.isSpecialDown()) {
            TudeySceneModel.Entry entry = this._editor.getMouseEntry();
            if (entry != null) {
                if (this._editor.isSelected(entry)) {
                    this._editor.moveSelection();
                } else {
                    this._editor.select(entry);
                }
            } else {
                this._editor.clearSelection();
                this._epanel.setObject(null);
            }
        }
    }
}

