/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.common.base.Predicate;
import com.samskivert.util.ArrayUtil;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector3f;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.tudey.client.sprite.AreaSprite;
import com.threerings.tudey.config.AreaConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.ConfigTool;
import com.threerings.tudey.tools.SceneEditor;
import java.awt.event.MouseEvent;

public class AreaDefiner
extends ConfigTool<AreaConfig> {
    protected TudeySceneModel.AreaEntry _entry;
    protected int _idx;
    protected Vector3f _isect = new Vector3f();
    protected final Predicate<SceneElement> AREA_FILTER = new Predicate<SceneElement>(){

        public boolean apply(SceneElement element) {
            Object obj = element.getUserObject();
            return obj instanceof AreaSprite && AreaDefiner.this._editor.getLayerPredicate().apply((Object)((AreaSprite)obj).getEntry());
        }
    };

    public AreaDefiner(SceneEditor editor) {
        super(editor, AreaConfig.class, new AreaReference());
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this._entry != null) {
            this.release();
        }
    }

    @Override
    public void sceneChanged(TudeySceneModel scene) {
        super.sceneChanged(scene);
        this._entry = null;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this._editor.isSpecialDown()) {
            return;
        }
        int button = event.getButton();
        if (this._entry != null) {
            if (button == 1) {
                this.insertVertex(this._entry, this._idx + 1);
            } else if (button == 3) {
                this.release();
            }
            return;
        }
        if (this._editor.getMouseRay(this._pick)) {
            SceneElement element = this._editor.getView().getScene().getIntersection(this._pick, this._isect, this.AREA_FILTER);
            if (element instanceof Model) {
                Model model = (Model)element;
                AreaSprite sprite = (AreaSprite)model.getUserObject();
                TudeySceneModel.AreaEntry entry = (TudeySceneModel.AreaEntry)sprite.getEntry();
                int idx = sprite.getVertexIndex(model);
                if (idx != -1) {
                    if (button == 1) {
                        this._entry = entry;
                        this._idx = idx;
                    } else if (button == 3) {
                        this.removeVertices(entry, idx, 1);
                    }
                    return;
                }
                idx = sprite.getEdgeIndex(model);
                if (button == 1) {
                    this.insertVertex(entry, idx + 1);
                } else if (button == 3) {
                    if (idx == entry.vertices.length - 1) {
                        this.removeVertices(entry, idx, 1);
                        this.removeVertices(entry, 0, 1);
                    } else {
                        this.removeVertices(entry, idx, 2);
                    }
                }
                return;
            }
            if (element != null && button == 3) {
                AreaSprite sprite = (AreaSprite)element.getUserObject();
                this._editor.removeEntries(sprite.getEntry().getKey());
            }
        }
        ConfigReference area = this._eref.getReference();
        if (button == 1 && area != null && this.getMousePlaneIntersection(this._isect)) {
            this._entry = new TudeySceneModel.AreaEntry();
            this._idx = 1;
            this._entry.area = area;
            this._entry.vertices = new TudeySceneModel.Vertex[]{new TudeySceneModel.Vertex(), new TudeySceneModel.Vertex()};
            this.setMouseLocation(this._entry.vertices[0]);
            this._editor.addEntries(new TudeySceneModel.Entry[]{this._entry});
        }
    }

    @Override
    public void tick(float elapsed) {
        if (this._entry == null || !this.getMousePlaneIntersection(this._isect) || this._editor.isSpecialDown()) {
            return;
        }
        this._entry = (TudeySceneModel.AreaEntry)this._entry.clone();
        this.setMouseLocation(this._entry.vertices[this._idx]);
        this._editor.updateEntries(new TudeySceneModel.Entry[]{this._entry});
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        if (this._entry != null && this._entry.getKey().equals(oentry.getKey()) && this._entry != nentry) {
            this._entry = null;
        }
    }

    @Override
    public void entryRemoved(TudeySceneModel.Entry oentry) {
        if (this._entry != null && this._entry.getKey().equals(oentry.getKey())) {
            this._entry = null;
        }
    }

    protected void setMouseLocation(TudeySceneModel.Vertex vertex) {
        if (!this._editor.isShiftDown()) {
            this._isect.x = FloatMath.floor((float)this._isect.x) + 0.5f;
            this._isect.y = FloatMath.floor((float)this._isect.y) + 0.5f;
        }
        vertex.set(this._isect.x, this._isect.y, this._editor.getGrid().getZ());
    }

    protected void release() {
        this.removeVertices(this._entry, this._idx, 1);
        this._entry = null;
    }

    protected void insertVertex(TudeySceneModel.AreaEntry entry, int idx) {
        this._entry = (TudeySceneModel.AreaEntry)entry.clone();
        this._idx = idx;
        this._entry.vertices = (TudeySceneModel.Vertex[])ArrayUtil.insert((Object[])this._entry.vertices, (Object)new TudeySceneModel.Vertex(), (int)idx);
        this._editor.updateEntries(new TudeySceneModel.Entry[]{this._entry});
    }

    protected void removeVertices(TudeySceneModel.AreaEntry entry, int idx, int count) {
        if (entry.vertices.length <= count) {
            this._editor.removeEntries(entry.getKey());
        } else {
            TudeySceneModel.AreaEntry nentry = (TudeySceneModel.AreaEntry)entry.clone();
            nentry.vertices = (TudeySceneModel.Vertex[])ArrayUtil.splice((Object[])nentry.vertices, (int)idx, (int)count);
            this._editor.updateEntries(new TudeySceneModel.Entry[]{nentry});
        }
    }

    protected static class AreaReference
    extends ConfigTool.EditableReference<AreaConfig> {
        @Editable(nullable=true)
        public ConfigReference<AreaConfig> area;

        protected AreaReference() {
        }

        @Override
        public ConfigReference<AreaConfig> getReference() {
            return this.area;
        }

        @Override
        public void setReference(ConfigReference<AreaConfig> ref) {
            this.area = ref;
        }
    }
}

