/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape;

import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.math.Box;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.Batch;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.AlphaState;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.renderer.state.DepthState;
import com.threerings.opengl.renderer.state.TransformState;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.client.util.ShapeConfigElement;
import com.threerings.tudey.shape.config.ShapeModelConfig;

public class ShapeModel
extends Model.Implementation {
    protected GlContext _ctx;
    protected ShapeModelConfig _config;
    protected ShapeConfigElement _element;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound(value="viewTransform")
    protected Transform3D _parentViewTransform;
    @Bound
    protected Transform3D _localTransform;
    @Bound
    protected ColorState _colorState;

    public ShapeModel(GlContext ctx, Scope parentScope, ShapeModelConfig config) {
        super(parentScope);
        this._ctx = ctx;
        this._element = new ShapeConfigElement(ctx){
            {
                this._queue = this._ctx.getCompositor().getQueue("Transparent");
                this._batch.getStates()[0] = AlphaState.PREMULTIPLIED;
                this._batch.getStates()[5] = DepthState.TEST;
            }

            public void enqueue() {
                TransformState tstate = (TransformState)this._batch.getStates()[15];
                Transform3D modelview = tstate.getModelview();
                ShapeModel.this._parentViewTransform.compose(ShapeModel.this._localTransform, modelview);
                tstate.setDirty(true);
                this._batch.depth = modelview.transformPointZ(this.getCenter());
                this._queue.add((Batch)this._batch, this._priority);
            }

            protected void boundsWillChange() {
                ((Model)ShapeModel.this._parentScope).boundsWillChange((Model.Implementation)ShapeModel.this);
            }

            protected void boundsDidChange() {
                ((Model)ShapeModel.this._parentScope).boundsDidChange((Model.Implementation)ShapeModel.this);
            }
        };
        this.setConfig(ctx, config);
    }

    public void setConfig(GlContext ctx, ShapeModelConfig config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    public Box getBounds() {
        return this._element.getBounds();
    }

    public void updateBounds() {
        if (this._parentWorldTransform == null) {
            this._element.getTransform().set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._element.getTransform());
        }
        this._element.updateBounds();
    }

    public void drawBounds() {
        DebugBounds.draw((Box)this._element.getBounds(), (Color4f)Color4f.WHITE);
    }

    public boolean getIntersection(Ray3D ray, Vector3f result) {
        return this._element.getIntersection(ray, result);
    }

    public void composite() {
        this._element.composite();
    }

    protected void updateFromConfig() {
        this._element.setConfig(this._config.shape, this._config.outline);
        this._element.getStates()[2] = this._colorState == null ? ColorState.WHITE : this._colorState;
        this.updateBounds();
    }
}

