/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape;

import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Capsule;
import com.threerings.tudey.shape.Circle;
import com.threerings.tudey.shape.Compound;
import com.threerings.tudey.shape.Point;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.space.SimpleSpaceElement;

public class ShapeElement
extends SimpleSpaceElement {
    protected Shape _localShape;
    protected Shape _worldShape;

    public ShapeElement(ShapeConfig config) {
        this.setConfig(config);
    }

    public ShapeElement(Shape localShape) {
        this.setLocalShape(localShape);
    }

    public void setConfig(ShapeConfig config) {
        this.setLocalShape(config.getShape());
    }

    public void setLocalShape(Shape shape) {
        this._localShape = shape;
        this.updateBounds();
    }

    public Shape getLocalShape() {
        return this._localShape;
    }

    public Shape getWorldShape() {
        return this._worldShape;
    }

    @Override
    public void updateBounds() {
        this._worldShape = this._localShape.transform(this._transform, this._worldShape);
        Rect sbounds = this._worldShape.getBounds();
        if (!this._bounds.equals((Object)sbounds)) {
            this.boundsWillChange();
            this._bounds.set(sbounds);
            this.boundsDidChange();
        }
    }

    @Override
    public boolean getIntersection(Ray2D ray, Vector2f result) {
        return this._worldShape.getIntersection(ray, result);
    }

    @Override
    public void getNearestPoint(Vector2f point, Vector2f result) {
        this._worldShape.getNearestPoint(point, result);
    }

    @Override
    public boolean intersects(Point point) {
        return this._worldShape.intersects(point);
    }

    @Override
    public boolean intersects(Segment segment) {
        return this._worldShape.intersects(segment);
    }

    @Override
    public boolean intersects(Circle circle) {
        return this._worldShape.intersects(circle);
    }

    @Override
    public boolean intersects(Capsule capsule) {
        return this._worldShape.intersects(capsule);
    }

    @Override
    public boolean intersects(Polygon polygon) {
        return this._worldShape.intersects(polygon);
    }

    @Override
    public boolean intersects(Compound compound) {
        return this._worldShape.intersects(compound);
    }
}

