/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.collect.Lists;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.tudey.config.ScriptConfig;
import com.threerings.tudey.data.actor.Mobile;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActionLogic;
import com.threerings.tudey.server.logic.AgentLogic;
import com.threerings.tudey.server.logic.BehaviorLogic;
import com.threerings.tudey.server.logic.ConditionLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.TargetLogic;
import java.util.ArrayList;
import java.util.Map;

public abstract class ScriptLogic
extends Logic {
    protected ScriptConfig _config;
    protected AgentLogic _agent;
    protected BehaviorLogic.Scripted _scripted;
    protected static final float MAX_PATH_LENGTH = 10.0f;

    public static ScriptLogic createScriptLogic(TudeySceneManager scenemgr, ScriptConfig config, AgentLogic agent, BehaviorLogic.Scripted scripted) {
        ScriptLogic logic = (ScriptLogic)scenemgr.createLogic(config.getLogicClassName());
        if (logic == null) {
            return null;
        }
        logic.init(scenemgr, config, agent, scripted);
        return logic;
    }

    public void init(TudeySceneManager scenemgr, ScriptConfig config, AgentLogic agent, BehaviorLogic.Scripted scripted) {
        super.init(scenemgr);
        this._config = config;
        this._agent = agent;
        this._scripted = scripted;
        this.didInit();
    }

    public boolean tick(int timestamp) {
        return true;
    }

    public void start(int timestamp) {
    }

    public void suspend() {
    }

    public void shutdown() {
    }

    public void reachedTargetRotation() {
    }

    protected void didInit() {
    }

    public static class Action
    extends ScriptLogic {
        protected ActionLogic _action;

        @Override
        public void start(int timestamp) {
        }

        @Override
        public boolean tick(int timestamp) {
            this._action.execute(timestamp, this._agent);
            return true;
        }

        @Override
        public void shutdown() {
            this._action.removed();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._action.transfer(((Action)source)._action, refs);
        }

        @Override
        protected void didInit() {
            this._action = this.createAction(((ScriptConfig.Action)this._config).action, this._agent);
        }
    }

    public static class ClearSpeed
    extends ScriptLogic {
        @Override
        public void start(int timestamp) {
            this._agent.clearSpeed();
        }
    }

    public static class Condition
    extends ScriptLogic {
        protected ConditionLogic _condition;

        @Override
        public void start(int timestamp) {
            this._agent.stopMoving();
            this._agent.clearTargetRotation();
        }

        @Override
        public boolean tick(int timestamp) {
            return this._condition.isSatisfied(this._agent);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._condition.transfer(((Condition)source)._condition, refs);
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._condition = this.createCondition(((ScriptConfig.Condition)this._config).condition, this._agent);
        }
    }

    public static class ConditionalScript
    extends Condition {
        protected ScriptLogic _success;
        protected ScriptLogic _failure;
        public boolean _satisfied;

        @Override
        public void start(int timestamp) {
            super.start(timestamp);
            this._satisfied = this._condition.isSatisfied(this._agent);
            if (this._satisfied) {
                this._success.start(timestamp);
            } else {
                this._failure.start(timestamp);
            }
        }

        @Override
        public boolean tick(int timestamp) {
            return this._satisfied ? this._success.tick(timestamp) : this._failure.tick(timestamp);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._success.transfer(((ConditionalScript)source)._success, refs);
            this._failure.transfer(((ConditionalScript)source)._failure, refs);
            this._satisfied = ((ConditionalScript)source)._satisfied;
        }

        @Override
        protected void didInit() {
            super.didInit();
            ScriptConfig.ConditionalScript config = (ScriptConfig.ConditionalScript)this._config;
            this._success = ConditionalScript.createScriptLogic(this._scenemgr, config.success, this._agent, this._scripted);
            this._failure = ConditionalScript.createScriptLogic(this._scenemgr, config.failure, this._agent, this._scripted);
        }
    }

    public static class Goto
    extends ScriptLogic {
        @Override
        public void start(int timestamp) {
            this._scripted.setCurrentStep(((ScriptConfig.Goto)this._config).step, timestamp);
        }
    }

    public static class Move
    extends ScriptLogic {
        protected TargetLogic _target;
        protected Vector2f[] _path;
        protected int _pidx;
        protected Logic _finalTarget;

        @Override
        public void start(int timestamp) {
            this.createPath();
        }

        @Override
        public boolean tick(int timestamp) {
            if (this._path == null || this.finishedMove()) {
                this.finishMove();
                return true;
            }
            Vector2f trans = this._agent.getTranslation();
            boolean completedPath = false;
            while (this._path[this._pidx].distanceSquared(trans) <= this.getReachRadiusSquared()) {
                if (++this._pidx == this._path.length) {
                    this._agent.stopMoving();
                    this._path = null;
                    if (completedPath) {
                        this.finishMove();
                        return true;
                    }
                    this.createPath();
                    completedPath = true;
                }
                if (this._path != null) continue;
                this.finishMove();
                return true;
            }
            Vector2f node = this._path[this._pidx];
            float rot = FloatMath.atan2((float)(node.y - trans.y), (float)(node.x - trans.x));
            if (FloatMath.getAngularDistance((float)this._agent.getRotation(), (float)rot) > 1.0E-4f) {
                this._agent.stopMoving();
                this._agent.setTargetRotation(rot);
            } else {
                this._agent.startMoving();
            }
            return false;
        }

        @Override
        public void suspend() {
            this._agent.stopMoving();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Move msource = (Move)source;
            this._target.transfer(msource._target, refs);
            this._path = msource._path;
            this._pidx = msource._pidx;
            this._finalTarget = (Logic)refs.get(msource._finalTarget);
        }

        protected float getReachRadiusSquared() {
            float dist = ((Mobile)this._agent.getActor()).getSpeed() / (float)this._scenemgr.getTicksPerSecond();
            return dist * dist;
        }

        protected void createPath() {
            this._path = null;
            ArrayList targets = Lists.newArrayList();
            this._target.resolve(this._agent, targets);
            if (targets.isEmpty()) {
                return;
            }
            this._finalTarget = (Logic)targets.get(0);
            if (this.finishedMove()) {
                return;
            }
            Vector2f loc = this._finalTarget.getTranslation();
            this._path = this._scenemgr.getPathfinder().getPath(this._agent, 10.0f, loc.x, loc.y, true, true);
            this._pidx = 0;
        }

        protected boolean finishedMove() {
            float dist2 = this.getReachRadiusSquared();
            return this._finalTarget.getTranslation().distanceSquared(this._agent.getTranslation()) <= dist2;
        }

        protected void finishMove() {
            if (this._finalTarget != null) {
                Vector2f translation = this._finalTarget.getTranslation();
                this._agent.move(translation.x, translation.y, this._agent.getRotation());
            }
            this._agent.stopMoving();
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._target = this.createTarget(((ScriptConfig.Move)this._config).target, this._agent);
        }
    }

    public static class Rotate
    extends ScriptLogic {
        protected boolean _complete;

        @Override
        public void start(int timestamp) {
            ScriptConfig.Rotate config = (ScriptConfig.Rotate)this._config;
            this._agent.stopMoving();
            float rotation = config.direction + FloatMath.random((float)(-config.rotationVariance), (float)config.rotationVariance);
            if (config.relative) {
                rotation += this._agent.getRotation();
            }
            this._complete = false;
            this._agent.setTargetRotation(FloatMath.normalizeAnglePositive((float)rotation));
        }

        @Override
        public void reachedTargetRotation() {
            this._complete = true;
        }

        @Override
        public boolean tick(int timestamp) {
            return this._complete;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._complete = ((Rotate)source)._complete;
        }
    }

    public static class SetSpeed
    extends ScriptLogic {
        @Override
        public void start(int timestamp) {
            this._agent.setSpeed(((ScriptConfig.SetSpeed)this._config).speed);
        }
    }

    public static class Wait
    extends ScriptLogic {
        protected int _started;

        @Override
        public void start(int timestamp) {
            this._agent.stopMoving();
            this._agent.clearTargetRotation();
            this._started = timestamp;
        }

        @Override
        public boolean tick(int timestamp) {
            return timestamp - this._started > ((ScriptConfig.Wait)this._config).wait;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._started = ((Wait)source)._started;
        }
    }
}

