/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.data.actor;

import com.samskivert.util.ArrayUtil;
import com.threerings.config.ConfigReference;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.StepLimiter;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.DirectionUtil;
import com.threerings.tudey.util.MobileAdvancer;
import com.threerings.util.DeepOmit;

public class Mobile
extends Actor {
    public static final int MOVING = 2;
    public static final int LAST_FLAG = 2;
    protected StepLimiter[] _limiters;
    protected float _maxStep;
    @DeepOmit
    protected float _direction;

    public Mobile(ConfigReference<ActorConfig> config, int id, int created, Vector2f translation, float rotation) {
        super(config, id, created, translation, rotation);
    }

    public Mobile() {
    }

    public void stopMoving() {
        this.clear(2);
    }

    public void setDirection(float direction) {
        this._direction = direction;
        this.setDirty(true);
    }

    public float getDirection() {
        return this._direction;
    }

    public void setMaxStep(float maxStep) {
        if (maxStep != this._maxStep) {
            this._maxStep = maxStep;
            this.setDirty(true);
        }
    }

    public float getMaxStep() {
        return this._maxStep;
    }

    public void addStepLimiter(StepLimiter limiter) {
        if (this._limiters == null) {
            this._limiters = new StepLimiter[1];
            this._limiters[0] = limiter;
        } else {
            this._limiters = (StepLimiter[])ArrayUtil.append((Object[])this._limiters, (Object)limiter);
        }
    }

    public void removeStepLimiter(StepLimiter limiter) {
        if (this._limiters != null) {
            int idx = ArrayUtil.indexOf((Object[])this._limiters, (Object)limiter);
            if (idx == 0 && this._limiters.length == 1) {
                this._limiters = null;
            } else if (idx > -1) {
                this._limiters = (StepLimiter[])ArrayUtil.splice((Object[])this._limiters, (int)idx, (int)1);
            }
        }
    }

    public float getMaxStepSquared() {
        return this._maxStep * this._maxStep;
    }

    public int getTurnDirection() {
        return 0;
    }

    public float getTurnRate() {
        return 0.0f;
    }

    public float getSpeed() {
        return ((ActorConfig.Mobile)this._original).speed;
    }

    public void step(float elapsed, int timestamp, int directions) {
        float length;
        Vector2f step;
        if (this.isSet(2) && DirectionUtil.alterStep(step = new Vector2f((length = this.getSpeed() * elapsed) * FloatMath.cos((float)this._direction), length * FloatMath.sin((float)this._direction)), directions)) {
            this._translation.addLocal(step);
            this.setDirty(true);
        }
    }

    public Actor extrapolate(float elapsed, int timestamp, Actor result) {
        super.extrapolate(elapsed, timestamp, result);
        ((Mobile)result).step(elapsed, timestamp, 0);
        return result;
    }

    public ActorAdvancer createAdvancer(ActorAdvancer.Environment environment, int timestamp) {
        return new MobileAdvancer(environment, this, timestamp);
    }

    public Object copy(Object dest) {
        Mobile result = (Mobile)((Object)super.copy(dest));
        result._direction = this._direction;
        return result;
    }

    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        Mobile omobile = (Mobile)((Object)other);
        return this._direction == omobile._direction;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Float.floatToIntBits(this._direction);
        return hash;
    }
}

