/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.probs;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.effect.Easing;
import com.threerings.opengl.effect.FloatFunction;
import com.threerings.probs.FloatVariable;
import com.threerings.util.DeepObject;

@EditorTypes(value={Fixed.class, VariableConstant.class, VariableLinear.class, VariableInAndOut.class, VariableThreePoint.class, VariableMultipoint.class}, label="mode")
public abstract class FloatFunctionVariable
extends DeepObject
implements Exportable {
    public abstract FloatFunction getValue(FloatFunction var1);

    public static class Fixed
    extends FloatFunctionVariable {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public FloatFunction function = new FloatFunction.Constant();

        public Fixed(FloatFunction function) {
            this.function = function;
        }

        public Fixed() {
        }

        @Override
        public FloatFunction getValue(FloatFunction result) {
            return this.function.copy(result);
        }
    }

    public static class VariableConstant
    extends FloatFunctionVariable {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public FloatVariable value = new FloatVariable.Constant();

        @Override
        public FloatFunction getValue(FloatFunction result) {
            FloatFunction.Constant cresult = result instanceof FloatFunction.Constant ? (FloatFunction.Constant)result : new FloatFunction.Constant();
            cresult.value = this.value.getValue();
            return cresult;
        }
    }

    public static class VariableInAndOut
    extends FloatFunctionVariable {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public FloatVariable start = new FloatVariable.Constant();
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public FloatVariable end = new FloatVariable.Constant();
        @Editable(min=0.0, max=1.0, step=0.01)
        public FloatVariable in = new FloatVariable.Constant(0.25f);
        @Editable(min=0.0, max=1.0, step=0.01)
        public FloatVariable out = new FloatVariable.Constant(0.25f);

        @Override
        public FloatFunction getValue(FloatFunction result) {
            FloatFunction.InAndOut ioresult = result instanceof FloatFunction.InAndOut ? (FloatFunction.InAndOut)result : new FloatFunction.InAndOut();
            ioresult.start = this.start.getValue();
            ioresult.end = this.end.getValue();
            ioresult.in = this.in.getValue();
            ioresult.out = this.out.getValue();
            return ioresult;
        }
    }

    public static class VariableLinear
    extends FloatFunctionVariable {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public FloatVariable start = new FloatVariable.Constant();
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public FloatVariable end = new FloatVariable.Constant();
        @Editable
        public Easing easing = new Easing.None();

        @Override
        public FloatFunction getValue(FloatFunction result) {
            FloatFunction.Linear lresult = result instanceof FloatFunction.Linear ? (FloatFunction.Linear)result : new FloatFunction.Linear();
            lresult.start = this.start.getValue();
            lresult.end = this.end.getValue();
            lresult.easing = this.easing.copy(lresult.easing);
            return lresult;
        }
    }

    public static class VariableMultipoint
    extends FloatFunctionVariable {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public FloatVariable start = new FloatVariable.Constant();
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public Point[] middle = new Point[0];
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public FloatVariable end = new FloatVariable.Constant();

        @Override
        public FloatFunction getValue(FloatFunction result) {
            int ii;
            FloatFunction.Multipoint mpresult = result instanceof FloatFunction.Multipoint ? (FloatFunction.Multipoint)result : new FloatFunction.Multipoint();
            mpresult.start = this.start.getValue();
            if (mpresult.middle.length != this.middle.length) {
                mpresult.middle = new FloatFunction.Multipoint.Point[this.middle.length];
                ii = 0;
                while (ii < this.middle.length) {
                    mpresult.middle[ii] = new FloatFunction.Multipoint.Point();
                    ++ii;
                }
            }
            ii = 0;
            while (ii < this.middle.length) {
                Point point = this.middle[ii];
                FloatFunction.Multipoint.Point mpoint = mpresult.middle[ii];
                mpoint.value = point.value.getValue();
                mpoint.offset = point.offset.getValue();
                ++ii;
            }
            mpresult.end = this.end.getValue();
            return mpresult;
        }

        public static class Point
        extends DeepObject
        implements Exportable {
            @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
            public FloatVariable value = new FloatVariable.Constant();
            @Editable(min=0.0, max=1.0, step=0.01)
            public FloatVariable offset = new FloatVariable.Constant(0.25f);
        }
    }

    public static class VariableThreePoint
    extends FloatFunctionVariable {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public FloatVariable start = new FloatVariable.Constant();
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public FloatVariable middle = new FloatVariable.Constant();
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public FloatVariable end = new FloatVariable.Constant();
        @Editable(min=0.0, max=1.0, step=0.01)
        public FloatVariable in = new FloatVariable.Constant(0.25f);
        @Editable(min=0.0, max=1.0, step=0.01)
        public FloatVariable out = new FloatVariable.Constant(0.25f);

        @Override
        public FloatFunction getValue(FloatFunction result) {
            FloatFunction.ThreePoint tpresult = result instanceof FloatFunction.ThreePoint ? (FloatFunction.ThreePoint)result : new FloatFunction.ThreePoint();
            tpresult.start = this.start.getValue();
            tpresult.middle = this.middle.getValue();
            tpresult.end = this.end.getValue();
            tpresult.in = this.in.getValue();
            tpresult.out = this.out.getValue();
            return tpresult;
        }
    }
}

