/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.layout;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.layout.LayoutManager;
import com.threerings.opengl.gui.util.Dimension;
import java.util.HashMap;

public class AnchorLayout
extends LayoutManager {
    public static final Anchor SOUTHWEST = new Anchor(0.0f, 0.0f, 0.0f, 0.0f, false);
    public static final Anchor SOUTH = new Anchor(0.5f, 0.0f, 0.5f, 0.0f, false);
    public static final Anchor SOUTHEAST = new Anchor(1.0f, 0.0f, 1.0f, 0.0f, false);
    public static final Anchor EAST = new Anchor(1.0f, 0.5f, 1.0f, 0.5f, false);
    public static final Anchor NORTHEAST = new Anchor(1.0f, 1.0f, 1.0f, 1.0f, false);
    public static final Anchor NORTH = new Anchor(0.5f, 1.0f, 0.5f, 1.0f, false);
    public static final Anchor NORTHWEST = new Anchor(0.0f, 1.0f, 0.0f, 1.0f, false);
    public static final Anchor WEST = new Anchor(0.0f, 0.5f, 0.0f, 0.5f, false);
    public static final Anchor CENTER = new Anchor(0.5f, 0.5f, 0.5f, 0.5f, false);
    protected HashMap<Component, Anchor> _anchors = new HashMap();

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Anchor anchor;
        if (constraints instanceof Anchor) {
            anchor = (Anchor)constraints;
        } else if (constraints == null) {
            anchor = CENTER;
        } else {
            throw new IllegalArgumentException("Components must be added to an AnchorLayout with Anchor constraints.");
        }
        this._anchors.put(comp, anchor);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this._anchors.remove(comp);
    }

    @Override
    public Object getConstraints(Component comp) {
        return this._anchors.get(comp);
    }

    @Override
    public Dimension computePreferredSize(Container target, int whint, int hhint) {
        int ii = 0;
        int nn = target.getComponentCount();
        while (ii < nn) {
            Dimension size = target.getComponent(ii).getPreferredSize(whint, hhint);
            whint = Math.max(whint, size.width);
            hhint = Math.max(hhint, size.height);
            ++ii;
        }
        return new Dimension(whint, hhint);
    }

    @Override
    public void layoutContainer(Container target) {
        int width = target.getWidth();
        int height = target.getHeight();
        int ii = 0;
        int nn = target.getComponentCount();
        while (ii < nn) {
            Anchor anchor;
            Component comp = target.getComponent(ii);
            if (comp.isVisible() && (anchor = this._anchors.get(comp)) != null) {
                int px = Math.round((float)width * anchor.px);
                int py = Math.round((float)height * anchor.py);
                Dimension size = anchor.fitToContainer ? comp.getPreferredSize(width, height) : comp.getPreferredSize(-1, -1);
                int cx = Math.round((float)size.width * anchor.cx);
                int cy = Math.round((float)size.height * anchor.cy);
                comp.setBounds(px - cx, py - cy, size.width, size.height);
            }
            ++ii;
        }
    }

    public static class Anchor {
        public float cx;
        public float cy;
        public float px;
        public float py;
        public boolean fitToContainer;

        public Anchor(float cx, float cy, float px, float py, boolean fitToContainer) {
            this.cx = cx;
            this.cy = cy;
            this.px = px;
            this.py = py;
            this.fitToContainer = fitToContainer;
        }
    }
}

