/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl;

import com.samskivert.util.HashIntSet;
import com.samskivert.util.Interator;
import com.threerings.opengl.GlApp;
import com.threerings.opengl.GlCanvas;
import com.threerings.opengl.Log;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.PixelFormat;

public class DisplayCanvas
extends JPanel
implements GlCanvas,
KeyEventDispatcher {
    protected Canvas _canvas;
    protected boolean _initialized;
    protected Runnable _updater;
    protected boolean _entered;
    protected int _lx;
    protected int _ly;
    protected ButtonRecord[] _buttons = new ButtonRecord[]{new ButtonRecord(), new ButtonRecord(), new ButtonRecord()};
    protected int _lclicks;
    protected int _modifiers;
    protected HashIntSet _pressedKeys = new HashIntSet();
    protected static final int ANY_BUTTONS_DOWN_MASK = 7168;
    protected static final long CLICK_INTERVAL = 250L;
    protected static final long CLICK_CHAIN_INTERVAL = 250L;

    public DisplayCanvas(final int antialiasingLevel) {
        super(new BorderLayout());
        this._canvas = new Canvas(){

            @Override
            public Point getMousePosition() {
                return DisplayCanvas.this._entered ? DisplayCanvas.this.getRelativeMouseLocation() : null;
            }

            @Override
            public void paint(Graphics g) {
                if (DisplayCanvas.this._initialized) {
                    return;
                }
                DisplayCanvas.this._initialized = true;
                PixelFormat[] pixelFormatArray = GlApp.getPixelFormats(antialiasingLevel);
                int n = pixelFormatArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PixelFormat format = pixelFormatArray[n2];
                    try {
                        DisplayCanvas.this.init(format);
                        return;
                    }
                    catch (LWJGLException lWJGLException) {
                        ++n2;
                    }
                }
                Log.log.warning((Object)"Couldn't find valid pixel format.", new Object[0]);
            }

            @Override
            public void update(Graphics g) {
            }
        };
        this.add((Component)this._canvas, "Center");
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this._canvas.setFocusable(false);
        MouseInputAdapter listener = new MouseInputAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                DisplayCanvas.this._entered = true;
                DisplayCanvas.this._lx = event.getX();
                DisplayCanvas.this._ly = event.getY();
            }

            @Override
            public void mouseExited(MouseEvent event) {
                DisplayCanvas.this._entered = false;
            }

            @Override
            public void mousePressed(MouseEvent event) {
                DisplayCanvas.this.requestFocusInWindow();
                int button = DisplayCanvas.getLWJGLButton(event.getButton());
                DisplayCanvas.this._buttons[button].wasPressed(event);
                DisplayCanvas.this.updateButtonModifier(button, true);
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                int button = DisplayCanvas.getLWJGLButton(event.getButton());
                DisplayCanvas.this._buttons[button].wasReleased(event);
                DisplayCanvas.this.updateButtonModifier(button, false);
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                DisplayCanvas.this._lx = event.getX();
                DisplayCanvas.this._ly = event.getY();
            }

            @Override
            public void mouseDragged(MouseEvent event) {
                DisplayCanvas.this._lx = event.getX();
                DisplayCanvas.this._ly = event.getY();
            }
        };
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                --DisplayCanvas.this._lclicks;
            }
        });
    }

    @Override
    public Drawable getDrawable() {
        return Display.getDrawable();
    }

    @Override
    public void setVSyncEnabled(boolean vsync) {
        Display.setVSyncEnabled((boolean)vsync);
    }

    @Override
    public void makeCurrent() {
        try {
            Display.makeCurrent();
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to make context current.", new Object[]{e});
        }
    }

    @Override
    public void shutdown() {
        Keyboard.destroy();
        Mouse.destroy();
        Display.destroy();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        int okey;
        int mask;
        boolean pressed;
        int id = event.getID();
        if (id == 401) {
            pressed = true;
        } else if (id == 402) {
            pressed = false;
        } else {
            return false;
        }
        boolean left = event.getKeyLocation() == 2;
        switch (event.getKeyCode()) {
            case 16: {
                mask = 64;
                okey = left ? 54 : 42;
                break;
            }
            case 17: {
                mask = 128;
                okey = left ? 157 : 29;
                break;
            }
            case 18: {
                mask = 512;
                okey = left ? 184 : 56;
                break;
            }
            case 157: {
                mask = 256;
                okey = left ? 220 : 219;
                break;
            }
            default: {
                return false;
            }
        }
        this._modifiers = pressed || this._pressedKeys.contains(okey) ? (this._modifiers |= mask) : (this._modifiers &= ~mask);
        return false;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
    }

    @Override
    public Point getMousePosition() {
        return this._canvas.getMousePosition();
    }

    protected void init(PixelFormat pformat) throws LWJGLException {
        Display.setParent((Canvas)this._canvas);
        Display.create((PixelFormat)pformat);
        try {
            Keyboard.create();
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to create keyboard.", new Object[]{e});
        }
        try {
            Mouse.create();
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to create mouse.", new Object[]{e});
        }
        this.didInit();
        this.startUpdating();
    }

    protected void didInit() {
    }

    protected void startUpdating() {
        this._updater = new Runnable(){

            @Override
            public void run() {
                if (DisplayCanvas.this._updater != null) {
                    DisplayCanvas.this.makeCurrent();
                    DisplayCanvas.this.updateFrame();
                    EventQueue.invokeLater(this);
                }
            }
        };
        EventQueue.invokeLater(this._updater);
    }

    protected void stopUpdating() {
        this._updater = null;
    }

    protected void updateFrame() {
        try {
            this.generateEvents();
            this.updateView();
            if (Display.isVisible()) {
                this.renderView();
            }
            Display.update();
        }
        catch (Exception e) {
            Log.log.warning((Object)"Caught exception in frame loop.", new Object[]{e});
        }
    }

    protected void generateEvents() {
        long now = System.currentTimeMillis();
        while (Keyboard.next()) {
            int key = Keyboard.getEventKey();
            boolean pressed = Keyboard.getEventKeyState();
            this.dispatchEvent(new KeyEvent(this, pressed ? 401 : 402, now, this._modifiers, DisplayCanvas.getAWTCode(key), Keyboard.getEventCharacter(), DisplayCanvas.getAWTLocation(key)));
            if (pressed) {
                this._pressedKeys.add(key);
                continue;
            }
            this._pressedKeys.remove(key);
        }
        while (Mouse.next()) {
            int delta;
            int x = Mouse.getEventX();
            int y = this.getHeight() - Mouse.getEventY() - 1;
            this.checkEntered(now, x, y);
            this.checkMoved(now, x, y);
            int button = Mouse.getEventButton();
            if (button != -1) {
                this.checkButtonState(now, x, y, button, Mouse.getEventButtonState());
            }
            if ((delta = -Integer.signum(Mouse.getEventDWheel())) == 0 || ++this._lclicks <= 0) continue;
            this.dispatchEvent(new MouseWheelEvent((Component)this, 507, now, this._modifiers, x, y, 0, false, 0, delta, delta));
        }
        Point pt = this.getRelativeMouseLocation();
        this.checkEntered(now, pt.x, pt.y);
        this.checkExited(now, pt.x, pt.y);
        this.checkMoved(now, pt.x, pt.y);
        this.checkButtonState(now, pt.x, pt.y, 0, Mouse.isButtonDown((int)0));
        this.checkButtonState(now, pt.x, pt.y, 1, Mouse.isButtonDown((int)1));
        this.checkButtonState(now, pt.x, pt.y, 2, Mouse.isButtonDown((int)2));
        if (!this.windowIsFocused()) {
            if (!this._pressedKeys.isEmpty()) {
                Interator it = this._pressedKeys.interator();
                while (it.hasNext()) {
                    int key = it.nextInt();
                    this.dispatchEvent(new KeyEvent(this, 402, now, this._modifiers, DisplayCanvas.getAWTCode(key), '\uffff', DisplayCanvas.getAWTLocation(key)));
                }
                this._pressedKeys.clear();
            }
            this._modifiers = 0;
        }
    }

    protected void checkEntered(long now, int x, int y) {
        if (!this._entered && this.contains(x, y) && this.windowIsFocused()) {
            this.dispatchEvent(new MouseEvent(this, 504, now, this._modifiers, x, y, 0, false));
        }
    }

    protected void checkExited(long now, int x, int y) {
        if (!(!this._entered || this.anyButtonsDown() || this.contains(x, y) && this.windowIsFocused())) {
            int ii = 0;
            while (ii < this._buttons.length) {
                this.checkButtonState(now, x, y, ii, false);
                ++ii;
            }
            this.dispatchEvent(new MouseEvent(this, 505, now, this._modifiers, x, y, 0, false));
        }
    }

    protected boolean windowIsFocused() {
        Window window = SwingUtilities.windowForComponent(this);
        return window != null && window.isFocused();
    }

    protected void checkMoved(long now, int x, int y) {
        if (this._entered && (this._lx != x || this._ly != y)) {
            this.dispatchEvent(new MouseEvent(this, this.anyButtonsDown() ? 506 : 503, now, this._modifiers, x, y, 0, false));
        }
    }

    protected void checkButtonState(long now, int x, int y, int button, boolean pressed) {
        if (this._buttons != null && this._buttons.length > button && this._entered && this._buttons[button].isPressed() != pressed) {
            this.dispatchEvent(new MouseEvent(this, pressed ? 501 : 502, now, this._modifiers, x, y, 0, false, DisplayCanvas.getAWTButton(button)));
        }
    }

    protected void updateButtonModifier(int button, boolean pressed) {
        int mask;
        switch (button) {
            case 0: {
                mask = 1024;
                break;
            }
            case 1: {
                mask = 4096;
                break;
            }
            case 2: {
                mask = 2048;
                break;
            }
            default: {
                return;
            }
        }
        this._modifiers = pressed ? (this._modifiers |= mask) : (this._modifiers &= ~mask);
    }

    protected void updateView() {
    }

    protected void renderView() {
    }

    protected Point getRelativeMouseLocation() {
        Point pt = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(pt, this);
        return pt;
    }

    protected boolean anyButtonsDown() {
        return (this._modifiers & 0x1C00) != 0;
    }

    protected static int getAWTCode(int key) {
        switch (key) {
            case 11: {
                return 48;
            }
            case 2: {
                return 49;
            }
            case 3: {
                return 50;
            }
            case 4: {
                return 51;
            }
            case 5: {
                return 52;
            }
            case 6: {
                return 53;
            }
            case 7: {
                return 54;
            }
            case 8: {
                return 55;
            }
            case 9: {
                return 56;
            }
            case 10: {
                return 57;
            }
            case 30: {
                return 65;
            }
            case 78: {
                return 107;
            }
            case 40: {
                return 222;
            }
            case 221: {
                return 0;
            }
            case 145: {
                return 512;
            }
            case 150: {
                return 0;
            }
            case 48: {
                return 66;
            }
            case 14: {
                return 8;
            }
            case 43: {
                return 92;
            }
            case 46: {
                return 67;
            }
            case 58: {
                return 20;
            }
            case 144: {
                return 514;
            }
            case 146: {
                return 513;
            }
            case 51: {
                return 44;
            }
            case 121: {
                return 28;
            }
            case 32: {
                return 68;
            }
            case 83: {
                return 110;
            }
            case 211: {
                return 127;
            }
            case 181: {
                return 111;
            }
            case 208: {
                return 40;
            }
            case 18: {
                return 69;
            }
            case 207: {
                return 35;
            }
            case 13: {
                return 61;
            }
            case 1: {
                return 27;
            }
            case 33: {
                return 70;
            }
            case 59: {
                return 112;
            }
            case 68: {
                return 121;
            }
            case 87: {
                return 122;
            }
            case 88: {
                return 123;
            }
            case 100: {
                return 61440;
            }
            case 101: {
                return 61441;
            }
            case 102: {
                return 61442;
            }
            case 60: {
                return 113;
            }
            case 61: {
                return 114;
            }
            case 62: {
                return 115;
            }
            case 63: {
                return 116;
            }
            case 64: {
                return 117;
            }
            case 65: {
                return 118;
            }
            case 66: {
                return 119;
            }
            case 67: {
                return 120;
            }
            case 34: {
                return 71;
            }
            case 41: {
                return 192;
            }
            case 35: {
                return 72;
            }
            case 199: {
                return 36;
            }
            case 23: {
                return 73;
            }
            case 210: {
                return 155;
            }
            case 36: {
                return 74;
            }
            case 37: {
                return 75;
            }
            case 112: {
                return 241;
            }
            case 148: {
                return 25;
            }
            case 38: {
                return 76;
            }
            case 26: {
                return 91;
            }
            case 29: {
                return 17;
            }
            case 203: {
                return 37;
            }
            case 56: {
                return 18;
            }
            case 219: {
                return 157;
            }
            case 42: {
                return 16;
            }
            case 50: {
                return 77;
            }
            case 12: {
                return 45;
            }
            case 55: {
                return 106;
            }
            case 49: {
                return 78;
            }
            case 209: {
                return 34;
            }
            case 123: {
                return 29;
            }
            case 0: {
                return 0;
            }
            case 69: {
                return 144;
            }
            case 82: {
                return 96;
            }
            case 79: {
                return 97;
            }
            case 80: {
                return 98;
            }
            case 81: {
                return 99;
            }
            case 75: {
                return 100;
            }
            case 76: {
                return 101;
            }
            case 77: {
                return 102;
            }
            case 71: {
                return 103;
            }
            case 72: {
                return 104;
            }
            case 73: {
                return 105;
            }
            case 179: {
                return 44;
            }
            case 156: {
                return 10;
            }
            case 141: {
                return 61;
            }
            case 24: {
                return 79;
            }
            case 25: {
                return 80;
            }
            case 197: {
                return 19;
            }
            case 52: {
                return 46;
            }
            case 222: {
                return 0;
            }
            case 201: {
                return 33;
            }
            case 16: {
                return 81;
            }
            case 19: {
                return 82;
            }
            case 27: {
                return 93;
            }
            case 157: {
                return 17;
            }
            case 28: {
                return 10;
            }
            case 205: {
                return 39;
            }
            case 184: {
                return 18;
            }
            case 220: {
                return 157;
            }
            case 54: {
                return 16;
            }
            case 31: {
                return 83;
            }
            case 70: {
                return 145;
            }
            case 39: {
                return 59;
            }
            case 53: {
                return 47;
            }
            case 223: {
                return 0;
            }
            case 57: {
                return 32;
            }
            case 149: {
                return 65480;
            }
            case 74: {
                return 109;
            }
            case 183: {
                return 154;
            }
            case 20: {
                return 84;
            }
            case 15: {
                return 9;
            }
            case 22: {
                return 85;
            }
            case 147: {
                return 523;
            }
            case 151: {
                return 0;
            }
            case 200: {
                return 38;
            }
            case 47: {
                return 86;
            }
            case 17: {
                return 87;
            }
            case 45: {
                return 88;
            }
            case 21: {
                return 89;
            }
            case 125: {
                return 0;
            }
            case 44: {
                return 90;
            }
        }
        return 0;
    }

    protected static int getAWTLocation(int key) {
        switch (key) {
            case 29: 
            case 42: 
            case 56: 
            case 219: {
                return 2;
            }
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 141: 
            case 156: 
            case 179: {
                return 4;
            }
            case 54: 
            case 157: 
            case 184: 
            case 220: {
                return 3;
            }
        }
        return 1;
    }

    protected static int getAWTButton(int button) {
        switch (button) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    protected static int getLWJGLButton(int button) {
        switch (button) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    protected class ButtonRecord {
        protected boolean _pressed;
        protected long _clickTime;
        protected long _chainTime;
        protected int _count;

        protected ButtonRecord() {
        }

        public boolean isPressed() {
            return this._pressed;
        }

        public void wasPressed(MouseEvent press) {
            this._pressed = true;
            long when = press.getWhen();
            this._clickTime = when + 250L;
            this._count = when < this._chainTime ? this._count + 1 : 1;
        }

        public void wasReleased(MouseEvent release) {
            this._pressed = false;
            long when = release.getWhen();
            if (when < this._clickTime) {
                DisplayCanvas.this.dispatchEvent(new MouseEvent(DisplayCanvas.this, 500, when, DisplayCanvas.this._modifiers, release.getX(), release.getY(), this._count, false, release.getButton()));
                this._chainTime = when + 250L;
            }
        }
    }
}

