/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.samskivert.swing.CollapsiblePanel;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.Spacer;
import com.samskivert.util.ListUtil;
import com.threerings.editor.swing.editors.ArrayListEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public abstract class PanelArrayListEditor
extends ArrayListEditor {
    protected JPanel _panels;
    protected static Icon _raiseIcon;
    protected static Icon _lowerIcon;
    protected static Icon _deleteIcon;

    @Override
    public void update() {
        int pcount = this._panels.getComponentCount();
        int length = this.getLength();
        int ii = 0;
        while (ii < length) {
            Object value = this.getValue(ii);
            if (ii < pcount) {
                this.updatePanel((EntryPanel)((Object)this._panels.getComponent(ii)), value);
            } else {
                this.addPanel(value);
            }
            ++ii;
        }
        while (pcount > length) {
            this._panels.remove(--pcount);
        }
        this.updatePanels();
    }

    @Override
    public void makeVisible(int idx) {
        EntryPanel panel = (EntryPanel)((Object)this._panels.getComponent(idx));
        panel.setCollapsed(false);
        this._panels.scrollRectToVisible(panel.getBounds());
    }

    @Override
    protected void didInit() {
        super.didInit();
        this._panels = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.TOP, (GroupLayout.Policy)GroupLayout.STRETCH);
        this._content.add(this._panels);
        this._panels.setBackground(null);
        JPanel bpanel = new JPanel();
        bpanel.setBackground(null);
        this._content.add(bpanel);
        this._add = new JButton(this.getActionLabel("new"));
        bpanel.add(this._add);
        this._add.addActionListener(this);
    }

    @Override
    protected String getMousePath(Point pt) {
        Component comp = this._panels.getComponentAt(SwingUtilities.convertPoint((Component)((Object)this), pt, this._panels));
        int idx = this._panels.getComponentZOrder(comp);
        return idx == -1 ? "" : "[" + idx + "]" + ((EntryPanel)((Object)comp)).getMousePath(pt);
    }

    @Override
    protected void addValue(Object value) {
        super.addValue(value);
        this.addPanel(value);
        this.updatePanels();
    }

    @Override
    protected void removeValue(int idx) {
        super.removeValue(idx);
        this._panels.remove(idx);
        this.updatePanels();
    }

    protected void swapValues(int idx1, int idx2) {
        Object tmp = this.getValue(idx1);
        this.setValue(idx1, this.getValue(idx2));
        this.setValue(idx2, tmp);
        this._panels.setComponentZOrder(this._panels.getComponent(idx1), idx2);
        this.fireStateChanged(true);
        this.updatePanels();
    }

    protected abstract void addPanel(Object var1);

    protected void updatePanels() {
        int ii = 0;
        int nn = this._panels.getComponentCount();
        while (ii < nn) {
            ((EntryPanel)((Object)this._panels.getComponent(ii))).updateButtons();
            ++ii;
        }
        this._panels.revalidate();
    }

    protected abstract void updatePanel(EntryPanel var1, Object var2);

    protected abstract class EntryPanel
    extends CollapsiblePanel
    implements ActionListener {
        protected JButton _raise;
        protected JButton _lower;
        protected JButton _delete;
        protected JButton _highlight;
        protected boolean _highlighted;
        protected TitledBorder _title;

        public EntryPanel(Object value) {
            JPanel panel = this.createPanel(value);
            if (_expandIcon == null) {
                _expandIcon = PanelArrayListEditor.this.loadIcon("expand", PanelArrayListEditor.this._ctx);
                _collapseIcon = PanelArrayListEditor.this.loadIcon("collapse", PanelArrayListEditor.this._ctx);
                _highlightIcon = PanelArrayListEditor.this.loadIcon("highlight", PanelArrayListEditor.this._ctx);
            }
            if (_raiseIcon == null) {
                _raiseIcon = PanelArrayListEditor.this.loadIcon("raise", PanelArrayListEditor.this._ctx);
                _lowerIcon = PanelArrayListEditor.this.loadIcon("lower", PanelArrayListEditor.this._ctx);
                _deleteIcon = PanelArrayListEditor.this.loadIcon("delete", PanelArrayListEditor.this._ctx);
            }
            JPanel tcont = GroupLayout.makeHBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.RIGHT, (GroupLayout.Policy)GroupLayout.NONE);
            tcont.setOpaque(false);
            JButton expand = PanelArrayListEditor.this.createButton(_expandIcon);
            tcont.add(expand);
            this._highlight = PanelArrayListEditor.this.createButton(_highlightIcon);
            tcont.add(this._highlight);
            this._highlight.addActionListener(this);
            this._raise = PanelArrayListEditor.this.createButton(_raiseIcon);
            tcont.add(this._raise);
            this._raise.addActionListener(this);
            this._lower = PanelArrayListEditor.this.createButton(_lowerIcon);
            tcont.add(this._lower);
            this._lower.addActionListener(this);
            this._delete = PanelArrayListEditor.this.createButton(_deleteIcon);
            tcont.add(this._delete);
            this._delete.addActionListener(this);
            this._title = BorderFactory.createTitledBorder("");
            this.updateBorder();
            this.setBackground(null);
            this.setTrigger(expand, _expandIcon, _collapseIcon);
            expand.setHorizontalAlignment(0);
            this.add((Component)new Spacer(1, -25));
            this.setTriggerContainer(tcont, panel);
            this.setGap(5);
            this.setCollapsed(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        EntryPanel.this._highlighted = !EntryPanel.this._highlighted;
                        EntryPanel.this.updateBorder();
                    }
                }
            });
        }

        public abstract String getMousePath(Point var1);

        public void updateButtons() {
            int idx = this.getIndex();
            int count = PanelArrayListEditor.this._panels.getComponentCount();
            this._raise.setEnabled(idx > 0);
            this._lower.setEnabled(idx < count - 1);
            this._delete.setEnabled(count > PanelArrayListEditor.this._min);
            this.updateBorder();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == this._raise) {
                int idx = this.getIndex();
                PanelArrayListEditor.this.swapValues(idx, idx - 1);
            } else if (source == this._lower) {
                int idx = this.getIndex();
                PanelArrayListEditor.this.swapValues(idx, idx + 1);
            } else if (source == this._delete) {
                PanelArrayListEditor.this.removeValue(this.getIndex());
            } else if (source == this._highlight) {
                this._highlighted = !this._highlighted;
                this.updateBorder();
            } else {
                super.actionPerformed(event);
            }
        }

        public void scrollRectToVisible(Rectangle rect) {
        }

        protected int getIndex() {
            return ListUtil.indexOfRef((Object[])PanelArrayListEditor.this._panels.getComponents(), (Object)this);
        }

        protected void updateBorder() {
            String title = String.valueOf(PanelArrayListEditor.this.getPropertyLabel()) + " (" + this.getIndex() + ")";
            this._title = this._highlighted ? BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 2), title) : BorderFactory.createTitledBorder(title);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0), this._title));
        }

        protected abstract JPanel createPanel(Object var1);
    }
}

