/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.samskivert.util.ListUtil;
import com.threerings.ClydeLog;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.ArgumentPathProperty;
import com.threerings.editor.DynamicallyEditable;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.InvalidPathsException;
import com.threerings.editor.PathProperty;
import com.threerings.editor.Property;
import com.threerings.editor.TranslatedPathProperty;
import com.threerings.export.Exportable;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import com.threerings.util.Inner;
import com.threerings.util.ReflectionUtil;
import java.io.PrintStream;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import proguard.annotation.Keep;

@EditorTypes(value={Direct.class, Choice.class, Translated.class})
public abstract class Parameter
extends DeepObject
implements Exportable {
    @Editable
    public String name = "";
    @DeepOmit
    protected transient Property _property = INVALID_PROPERTY;
    @DeepOmit
    protected transient Property _argumentProperty = INVALID_PROPERTY;
    protected static final Property INVALID_PROPERTY = new Property(){

        @Override
        public Member getMember() {
            return null;
        }

        @Override
        public Class<?> getType() {
            return null;
        }

        @Override
        public Type getGenericType() {
            return null;
        }

        @Override
        public Object get(Object object) {
            return null;
        }

        @Override
        public void set(Object object, Object value) {
        }
    };

    public Property getProperty(ParameterizedConfig reference) {
        if (this._property == INVALID_PROPERTY) {
            this._property = this.createProperty(reference);
        }
        return this._property;
    }

    public Property getArgumentProperty(ParameterizedConfig reference) {
        if (this._argumentProperty == INVALID_PROPERTY) {
            this._argumentProperty = this.createArgumentProperty(reference);
        }
        return this._argumentProperty;
    }

    public void invalidateProperties() {
        this._property = this._argumentProperty = INVALID_PROPERTY;
    }

    public abstract boolean validatePaths(String var1, ParameterizedConfig var2, PrintStream var3);

    public void validateOuters(String where, ParameterizedConfig outer) {
    }

    protected abstract Property createProperty(ParameterizedConfig var1);

    protected abstract Property createArgumentProperty(ParameterizedConfig var1);

    public static class Choice
    extends Parameter
    implements Inner {
        @Editable
        public Direct[] directs = new Direct[0];
        @Editable(depends={"directs"})
        public Option[] options = new Option[0];
        @Editable(editor="choice", depends={"options"})
        public String choice;
        @DeepOmit
        protected transient ParameterizedConfig _outer;
        @DeepOmit
        protected transient Property[] _optionProperties;

        public Choice(ParameterizedConfig outer) {
            this._outer = outer;
        }

        @Keep
        public String[] getChoiceOptions() {
            String[] names = new String[this.options.length];
            int ii = 0;
            while (ii < this.options.length) {
                names[ii] = this.options[ii].name;
                ++ii;
            }
            return names;
        }

        @Override
        public void setOuter(Object outer) {
            this._outer = (ParameterizedConfig)outer;
        }

        @Override
        public Object getOuter() {
            return this._outer;
        }

        @Override
        public void invalidateProperties() {
            super.invalidateProperties();
            Direct[] directArray = this.directs;
            int n = this.directs.length;
            int n2 = 0;
            while (n2 < n) {
                Direct direct = directArray[n2];
                direct.invalidateProperties();
                ++n2;
            }
            this._optionProperties = null;
        }

        @Override
        public boolean validatePaths(String where, ParameterizedConfig reference, PrintStream out) {
            where = String.valueOf(where) + ":" + this.name;
            boolean result = true;
            Direct[] directArray = this.directs;
            int n = this.directs.length;
            int n2 = 0;
            while (n2 < n) {
                Direct direct = directArray[n2];
                result &= direct.validatePaths(where, reference, out);
                ++n2;
            }
            return result;
        }

        @Override
        public void validateOuters(String where, ParameterizedConfig outer) {
            if (this._outer != outer) {
                this._outer = outer;
                ClydeLog.log.warning((Object)"Fixed invalid outer reference.", new Object[]{"where", where, "parameter", this.name});
            }
            Option[] optionArray = this.options;
            int n = this.options.length;
            int n2 = 0;
            while (n2 < n) {
                Option option = optionArray[n2];
                option.validateOuters(where, this);
                ++n2;
            }
        }

        @Override
        protected Property createProperty(ParameterizedConfig reference) {
            int idx = ListUtil.indexOfRef((Object[])reference.parameters, (Object)this);
            if (idx == -1) {
                return null;
            }
            try {
                return new PathProperty(reference.getConfigManager(), this.name, reference, new String[]{"parameters[" + idx + "].choice"}){

                    @Override
                    public void set(Object object, Object value) {
                        super.set(object, value);
                        Option option = Choice.this.getOption((String)value);
                        if (option != null) {
                            option.apply((ParameterizedConfig)object);
                        }
                    }
                };
            }
            catch (InvalidPathsException e) {
                return null;
            }
        }

        @Override
        protected Property createArgumentProperty(ParameterizedConfig reference) {
            int idx = ListUtil.indexOfRef((Object[])reference.parameters, (Object)this);
            if (idx == -1) {
                return null;
            }
            try {
                return new ArgumentPathProperty(reference.getConfigManager(), this.name, (Object)reference, "parameters[" + idx + "].choice");
            }
            catch (InvalidPathsException e) {
                return null;
            }
            catch (Exception e) {
                ClydeLog.log.warning((Object)"Failed to create argument property.", new Object[]{"name", this.name, e});
                return null;
            }
        }

        protected Option getOption(String name) {
            Option[] optionArray = this.options;
            int n = this.options.length;
            int n2 = 0;
            while (n2 < n) {
                Option option = optionArray[n2];
                if (option.name.equals(name)) {
                    return option;
                }
                ++n2;
            }
            return null;
        }

        protected Property[] getOptionProperties() {
            if (this._optionProperties == null) {
                ArrayList<2> props = new ArrayList<2>(this.directs.length);
                Direct[] directArray = this.directs;
                int n = this.directs.length;
                int n2 = 0;
                while (n2 < n) {
                    Direct direct = directArray[n2];
                    final Property aprop = direct.getArgumentProperty(this._outer);
                    if (aprop != null) {
                        props.add(new Property(){
                            {
                                this._name = property.getName();
                            }

                            @Override
                            public Member getMember() {
                                return aprop.getMember();
                            }

                            @Override
                            public Object getMemberObject(Object object) {
                                return aprop.getMemberObject(object);
                            }

                            @Override
                            public Class<?> getType() {
                                return aprop.getType();
                            }

                            @Override
                            public Type getGenericType() {
                                return aprop.getGenericType();
                            }

                            @Override
                            public Object get(Object object) {
                                return aprop.get(((Option)object)._arguments);
                            }

                            @Override
                            public void set(Object object, Object value) {
                                aprop.set(((Option)object)._arguments, value);
                            }
                        });
                    }
                    ++n2;
                }
                this._optionProperties = props.toArray(new Property[props.size()]);
            }
            return this._optionProperties;
        }

        public class Option
        extends DeepObject
        implements DynamicallyEditable,
        Exportable {
            @Editable
            public String name = "";
            protected ArgumentMap _arguments = new ArgumentMap();

            public void apply(ParameterizedConfig instance) {
                Choice.this._outer.applyArguments(instance, this._arguments, Choice.this.directs);
            }

            public void validateOuters(String where, Choice outer) {
                if (Choice.this != outer) {
                    ReflectionUtil.setOuter(this, outer);
                    ClydeLog.log.warning((Object)"Fixed invalid outer reference.", new Object[]{"where", where, "parameter", outer.name, "option", this.name});
                }
            }

            @Override
            public Property[] getDynamicProperties() {
                return Choice.this.getOptionProperties();
            }
        }
    }

    public static class Direct
    extends Parameter {
        @Editable(width=40, editor="paths")
        public String[] paths = new String[0];

        @Override
        public boolean validatePaths(String where, ParameterizedConfig reference, PrintStream out) {
            boolean result = true;
            String[] stringArray = this.paths;
            int n = this.paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                try {
                    new PathProperty(reference.getConfigManager(), this.name, reference, path);
                }
                catch (InvalidPathsException e) {
                    out.println(String.valueOf(where) + ":" + this.name + " has invalid path: " + path);
                    result = false;
                }
                ++n2;
            }
            return result;
        }

        @Override
        protected Property createProperty(ParameterizedConfig reference) {
            try {
                return new PathProperty(reference.getConfigManager(), this.name, reference, this.paths);
            }
            catch (InvalidPathsException e) {
                return null;
            }
        }

        @Override
        protected Property createArgumentProperty(ParameterizedConfig reference) {
            if (this.paths.length == 0) {
                return null;
            }
            try {
                return new ArgumentPathProperty(reference.getConfigManager(), this.name, (Object)reference, this.paths[0]);
            }
            catch (InvalidPathsException e) {
                return null;
            }
            catch (Exception e) {
                ClydeLog.log.warning((Object)"Failed to create argument property.", new Object[]{"name", this.name, e});
                return null;
            }
        }
    }

    public static class Translated
    extends Direct {
        @Editable
        public String bundle = "";

        @Override
        protected Property createProperty(ParameterizedConfig reference) {
            try {
                return new TranslatedPathProperty(reference.getConfigManager(), this.name, this.bundle, reference, this.paths);
            }
            catch (InvalidPathsException e) {
                return null;
            }
        }
    }
}

