/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.samskivert.util.SoftCache;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.expr.ExpressionBinding;
import com.threerings.expr.Scope;
import com.threerings.expr.ScopeEvent;
import com.threerings.expr.ScopeUpdateListener;
import com.threerings.expr.Updater;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;

public class BoundConfig
extends ParameterizedConfig
implements ScopeUpdateListener {
    @Editable(weight=1.0)
    public ExpressionBinding[] bindings = new ExpressionBinding[0];
    @DeepOmit
    protected transient Updater[] _updaters;
    @DeepOmit
    protected transient SoftCache<ScopeKey, BoundConfig> _bound;

    @Override
    public void scopeUpdated(ScopeEvent event) {
        this.wasUpdated();
    }

    @Override
    protected BoundConfig getBound(Scope scope) {
        ScopeKey key;
        BoundConfig bound;
        if (scope == null || this.bindings.length == 0) {
            return this;
        }
        if (this._bound == null) {
            this._bound = new SoftCache(1);
        }
        if ((bound = (BoundConfig)this._bound.get((Object)(key = new ScopeKey(scope)))) == null) {
            bound = (BoundConfig)this.clone();
            this._bound.put((Object)key, (Object)bound);
            bound.init(this._cfgmgr);
            bound._base = this;
            bound.bind(scope);
        }
        return bound;
    }

    @Override
    public void wasUpdated() {
        Object[] objectArray = this.bindings;
        int n = this.bindings.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionBinding binding = objectArray[n2];
            binding.invalidate();
            ++n2;
        }
        if (this._updaters != null) {
            objectArray = this._updaters;
            n = this._updaters.length;
            n2 = 0;
            while (n2 < n) {
                Object updater = objectArray[n2];
                updater.update();
                ++n2;
            }
        }
        super.wasUpdated();
        if (this._bound == null) {
            return;
        }
        Iterator it = this._bound.getMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            BoundConfig bound = (BoundConfig)((SoftReference)entry.getValue()).get();
            if (bound == null) {
                it.remove();
                continue;
            }
            this.copy(bound);
            bound.wasUpdated();
        }
        if (this._bound.getMap().isEmpty()) {
            this._bound = null;
        }
    }

    protected void bind(Scope scope) {
        this._updaters = new Updater[this.bindings.length];
        int ii = 0;
        while (ii < this.bindings.length) {
            this._updaters[ii] = this.bindings[ii].createUpdater(this._cfgmgr, scope, this);
            this._updaters[ii].update();
            ++ii;
        }
        scope.addListener(this);
    }

    protected static class ScopeKey {
        protected WeakReference<Scope> _scope;

        public ScopeKey(Scope scope) {
            this._scope = new WeakReference<Scope>(scope);
        }

        public int hashCode() {
            return System.identityHashCode(this._scope.get());
        }

        public boolean equals(Object other) {
            return this._scope.get() == ((ScopeKey)other)._scope.get();
        }
    }
}

