/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.threerings.tudey.data.InputFrame;
import com.threerings.tudey.server.ClientLiaison;
import com.threerings.tudey.server.logic.ActiveLogic;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.PawnAdvancer;
import com.threerings.util.ArrayDeque;

public class PawnLogic
extends ActiveLogic {
    protected PawnAdvancer _advancer;
    protected ClientLiaison _client;
    protected ArrayDeque<InputFrame> _input = new ArrayDeque(4);

    public void bodyEntered(ClientLiaison client) {
        this._client = client;
    }

    public void enqueueInput(InputFrame frame) {
        this._input.addLast(frame);
    }

    public int getControlDelta() {
        return this._client == null ? 0 : this._client.getControlDelta();
    }

    @Override
    public int getActivityAdvance() {
        return this.getControlDelta() / 2;
    }

    @Override
    public boolean tick(int timestamp) {
        while (!this._input.isEmpty() && this._input.peekFirst().getTimestamp() <= timestamp) {
            this._advancer.advance(this._input.pollFirst());
        }
        return super.tick(timestamp);
    }

    @Override
    protected ActorAdvancer createAdvancer() {
        this._advancer = (PawnAdvancer)this._actor.createAdvancer(this, this._actor.getCreated());
        return this._advancer;
    }
}

