/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.collect.Lists;
import com.samskivert.util.ListUtil;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.tudey.Log;
import com.threerings.tudey.config.ConditionConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActionLogic;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.ExpressionLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.RegionLogic;
import com.threerings.tudey.server.logic.TargetLogic;
import com.threerings.tudey.shape.Shape;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;

public abstract class ConditionLogic
extends Logic {
    protected ConditionConfig _config;
    protected Logic _source;

    public void init(TudeySceneManager scenemgr, ConditionConfig config, Logic source) {
        super.init(scenemgr);
        this._config = config;
        this._source = source;
        this.didInit();
    }

    public abstract boolean isSatisfied(Logic var1);

    @Override
    public boolean isActive() {
        return this._source.isActive();
    }

    @Override
    public EntityKey getEntityKey() {
        return this._source.getEntityKey();
    }

    @Override
    public Vector2f getTranslation() {
        return this._source.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._source.getRotation();
    }

    protected void didInit() {
    }

    public static class DateRange
    extends Targeted {
        @Override
        public boolean isSatisfied(Logic activator) {
            ConditionConfig.DateRange config = (ConditionConfig.DateRange)this._config;
            long now = System.currentTimeMillis();
            return !(config.start != null && now < config.start || config.end != null && now > config.end);
        }
    }

    public static class Is
    extends Targeted {
        protected ArrayList<Logic> _targets = Lists.newArrayList();
        protected TargetLogic _sourceTarget;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSatisfied(Logic activator) {
            this._sourceTarget.resolve(activator, this._targets);
            Logic sourceTarget = this._targets.isEmpty() ? null : this._targets.get(0);
            this._targets.clear();
            if (sourceTarget == null) {
                return false;
            }
            ConditionConfig.Is config = (ConditionConfig.Is)this._config;
            this._target.resolve(activator, this._targets);
            try {
                for (Logic target : this._targets) {
                    if (target != sourceTarget) continue;
                    boolean bl = !config.all;
                    return bl;
                }
                boolean bl = config.all;
                return bl;
            }
            finally {
                this._targets.clear();
            }
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ConditionConfig.Is)this._config).target, this._source);
            this._sourceTarget = this.createTarget(((ConditionConfig.Is)this._config).source, this._source);
        }
    }

    public static class Action
    extends ConditionLogic {
        protected ActionLogic _action;

        @Override
        public boolean isSatisfied(Logic activator) {
            return this._action.execute(this._scenemgr.getTimestamp(), activator);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._action.transfer(((Action)source)._action, refs);
        }

        @Override
        protected void didInit() {
            this._action = this.createAction(((ConditionConfig.Action)this._config).action, this._source);
        }
    }

    public static class Evaluate
    extends ConditionLogic {
        protected ExpressionLogic _expression;

        @Override
        public boolean isSatisfied(Logic activator) {
            return ExpressionLogic.coerceToBoolean(this._expression.evaluate(activator, null));
        }

        @Override
        protected void didInit() {
            this._expression = this.createExpression(((ConditionConfig.Evaluate)this._config).expression, this._source);
        }
    }

    public static class Always
    extends ConditionLogic {
        @Override
        public boolean isSatisfied(Logic activator) {
            return true;
        }
    }

    public static class Not
    extends ConditionLogic {
        protected ConditionLogic _condition;

        @Override
        public boolean isSatisfied(Logic activator) {
            return !this._condition.isSatisfied(activator);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._condition.transfer(((Not)source)._condition, refs);
        }

        @Override
        protected void didInit() {
            this._condition = this.createCondition(((ConditionConfig.Not)this._config).condition, this._source);
        }
    }

    public static class Cooldown
    extends ConditionLogic {
        protected int _nextTimestamp = -1;

        @Override
        public boolean isSatisfied(Logic activator) {
            int timestamp = this._scenemgr.getTimestamp();
            if (timestamp > this._nextTimestamp) {
                this._nextTimestamp = timestamp + ((ConditionConfig.Cooldown)this._config).time;
                return true;
            }
            return false;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._nextTimestamp = ((Cooldown)source)._nextTimestamp;
        }
    }

    public static class FlagSet
    extends Targeted {
        protected ArrayList<Logic> _targets = Lists.newArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSatisfied(Logic activator) {
            ConditionConfig.FlagSet config = (ConditionConfig.FlagSet)this._config;
            this._target.resolve(activator, this._targets);
            try {
                int nn = this._targets.size();
                for (int ii = 0; ii < nn; ++ii) {
                    Logic logic = this._targets.get(ii);
                    if (!(logic instanceof ActorLogic)) continue;
                    Actor actor = ((ActorLogic)logic).getActor();
                    try {
                        Field flag = actor.getClass().getField(config.flagName);
                        if (!actor.isSet(flag.getInt(actor))) continue;
                        boolean bl = config.set;
                        return bl;
                    }
                    catch (NoSuchFieldException e) {
                        Log.log.warning((Object)"Flag field not found in class for Flag Set Condition.", new Object[]{e});
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        Log.log.warning((Object)"Cannot access flag field for Flag Set Condition.", new Object[]{e});
                    }
                }
                boolean bl = !config.set;
                return bl;
            }
            finally {
                this._targets.clear();
            }
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ConditionConfig.FlagSet)this._config).target, this._source);
        }
    }

    public static class Any
    extends ConditionLogic {
        protected ConditionLogic[] _conditions;

        @Override
        public boolean isSatisfied(Logic activator) {
            for (ConditionLogic condition : this._conditions) {
                if (!condition.isSatisfied(activator)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            ConditionLogic[] sconditions = ((Any)source)._conditions;
            for (int ii = 0; ii < this._conditions.length; ++ii) {
                this._conditions[ii].transfer(sconditions[ii], refs);
            }
        }

        @Override
        protected void didInit() {
            ArrayList list = Lists.newArrayList();
            for (ConditionConfig config : ((ConditionConfig.Any)this._config).conditions) {
                ConditionLogic condition = this.createCondition(config, this._source);
                if (condition == null) continue;
                list.add(condition);
            }
            this._conditions = list.toArray(new ConditionLogic[list.size()]);
        }
    }

    public static class All
    extends ConditionLogic {
        protected ConditionLogic[] _conditions;

        @Override
        public boolean isSatisfied(Logic activator) {
            for (ConditionLogic condition : this._conditions) {
                if (condition.isSatisfied(activator)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            ConditionLogic[] sconditions = ((All)source)._conditions;
            for (int ii = 0; ii < this._conditions.length; ++ii) {
                this._conditions[ii].transfer(sconditions[ii], refs);
            }
        }

        @Override
        protected void didInit() {
            ArrayList list = Lists.newArrayList();
            for (ConditionConfig config : ((ConditionConfig.All)this._config).conditions) {
                ConditionLogic condition = this.createCondition(config, this._source);
                if (condition == null) continue;
                list.add(condition);
            }
            this._conditions = list.toArray(new ConditionLogic[list.size()]);
        }
    }

    public static class Limit
    extends ConditionLogic {
        protected int _limit;

        @Override
        public boolean isSatisfied(Logic activator) {
            if (this._limit > 0) {
                --this._limit;
                return true;
            }
            return false;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._limit = ((Limit)source)._limit;
        }

        @Override
        protected void didInit() {
            this._limit = ((ConditionConfig.Limit)this._config).limit;
        }
    }

    public static class Random
    extends ConditionLogic {
        @Override
        public boolean isSatisfied(Logic activator) {
            return FloatMath.random() < ((ConditionConfig.Random)this._config).probability;
        }
    }

    public static class DistanceWithin
    extends ConditionLogic {
        protected TargetLogic _first;
        protected TargetLogic _second;
        protected ArrayList<Logic> _firsts = Lists.newArrayList();
        protected ArrayList<Logic> _seconds = Lists.newArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSatisfied(Logic activator) {
            boolean all = ((ConditionConfig.DistanceWithin)this._config).allFirst;
            this._first.resolve(activator, this._firsts);
            this._second.resolve(activator, this._seconds);
            try {
                int nn = this._firsts.size();
                for (int ii = 0; ii < nn; ++ii) {
                    if (this.withinSecond(this._firsts.get(ii).getTranslation()) == all) continue;
                    boolean bl = !all;
                    return bl;
                }
                boolean bl = all;
                return bl;
            }
            finally {
                this._firsts.clear();
                this._seconds.clear();
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            DistanceWithin dsource = (DistanceWithin)source;
            this._first.transfer(dsource._first, refs);
            this._second.transfer(dsource._second, refs);
        }

        @Override
        protected void didInit() {
            ConditionConfig.DistanceWithin config = (ConditionConfig.DistanceWithin)this._config;
            this._first = this.createTarget(config.first, this._source);
            this._second = this.createTarget(config.second, this._source);
        }

        protected boolean withinSecond(Vector2f t1) {
            ConditionConfig.DistanceWithin config = (ConditionConfig.DistanceWithin)this._config;
            int nn = this._seconds.size();
            for (int ii = 0; ii < nn; ++ii) {
                Vector2f t2 = this._seconds.get(ii).getTranslation();
                if (FloatMath.isWithin(t1.distance(t2), config.minimum, config.maximum) == config.allSecond) continue;
                return !config.allSecond;
            }
            return config.allSecond;
        }
    }

    public static class IntersectsScene
    extends ConditionLogic {
        protected RegionLogic _region;
        protected ArrayList<Shape> _shapes = Lists.newArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSatisfied(Logic activator) {
            this._region.resolve(activator, this._shapes);
            try {
                for (Shape shape : this._shapes) {
                    if (!this._scenemgr.collides(((ConditionConfig.IntersectsScene)this._config).collisionMask, shape)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this._shapes.clear();
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._region.transfer(((IntersectsScene)source)._region, refs);
        }

        @Override
        protected void didInit() {
            this._region = this.createRegion(((ConditionConfig.IntersectsScene)this._config).region, this._source);
        }
    }

    public static class Intersecting
    extends ConditionLogic {
        protected RegionLogic _first;
        protected RegionLogic _second;
        protected ArrayList<Shape> _firsts = Lists.newArrayList();
        protected ArrayList<Shape> _seconds = Lists.newArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSatisfied(Logic activator) {
            boolean all = ((ConditionConfig.Intersecting)this._config).allFirst;
            this._first.resolve(activator, this._firsts);
            this._second.resolve(activator, this._seconds);
            try {
                int nn = this._firsts.size();
                for (int ii = 0; ii < nn; ++ii) {
                    if (this.intersectsSecond(this._firsts.get(ii)) == all) continue;
                    boolean bl = !all;
                    return bl;
                }
                boolean bl = all;
                return bl;
            }
            finally {
                this._firsts.clear();
                this._seconds.clear();
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Intersecting isource = (Intersecting)source;
            this._first.transfer(isource._first, refs);
            this._second.transfer(isource._second, refs);
        }

        @Override
        protected void didInit() {
            ConditionConfig.Intersecting config = (ConditionConfig.Intersecting)this._config;
            this._first = this.createRegion(config.first, this._source);
            this._second = this.createRegion(config.second, this._source);
        }

        protected boolean intersectsSecond(Shape shape) {
            boolean all = ((ConditionConfig.Intersecting)this._config).allSecond;
            int nn = this._seconds.size();
            for (int ii = 0; ii < nn; ++ii) {
                if (shape.intersects(this._seconds.get(ii)) == all) continue;
                return !all;
            }
            return all;
        }
    }

    public static class InstanceOf
    extends Targeted {
        protected Class<?> _logicClass;
        protected ArrayList<Logic> _targets = Lists.newArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSatisfied(Logic activator) {
            boolean all = ((ConditionConfig.InstanceOf)this._config).all;
            this._target.resolve(activator, this._targets);
            try {
                int nn = this._targets.size();
                for (int ii = 0; ii < nn; ++ii) {
                    if (this._logicClass.isInstance(this._targets.get(ii)) == all) continue;
                    boolean bl = !all;
                    return bl;
                }
                boolean bl = all;
                return bl;
            }
            finally {
                this._targets.clear();
            }
        }

        @Override
        protected void didInit() {
            ConditionConfig.InstanceOf config = (ConditionConfig.InstanceOf)this._config;
            try {
                this._logicClass = Class.forName(config.logicClass);
            }
            catch (ClassNotFoundException e) {
                Log.log.warning((Object)"Missing logic class for InstanceOf condition.", new Object[]{e});
                this._logicClass = Logic.class;
            }
            this._target = this.createTarget(config.target, this._source);
        }
    }

    public static class Tagged
    extends Targeted {
        protected ArrayList<Logic> _targets = Lists.newArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSatisfied(Logic activator) {
            ConditionConfig.Tagged config = (ConditionConfig.Tagged)this._config;
            this._target.resolve(activator, this._targets);
            try {
                int nn = this._targets.size();
                for (int ii = 0; ii < nn; ++ii) {
                    if (ListUtil.contains((Object[])this._targets.get(ii).getTags(), (Object)config.tag) == config.all) continue;
                    boolean bl = !config.all;
                    return bl;
                }
                boolean bl = config.all;
                return bl;
            }
            finally {
                this._targets.clear();
            }
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ConditionConfig.Tagged)this._config).target, this._source);
        }
    }

    public static abstract class Targeted
    extends ConditionLogic {
        protected TargetLogic _target;

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((Targeted)source)._target, refs);
        }
    }
}

