/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.opengl.effect.Easing;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.ViewerEffect;
import com.threerings.opengl.scene.config.ViewerEffectConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.config.CameraConfig;

@EditorTypes(value={Camera.class})
public abstract class TudeyViewerEffectConfig
extends ViewerEffectConfig {

    public static class Camera
    extends TudeyViewerEffectConfig {
        @Editable(min=0.0, step=0.01)
        public float transition;
        @Editable
        public Easing easing = new Easing.None();
        @Editable
        public CameraConfig camera = new CameraConfig();

        @Override
        public ViewerEffect getViewerEffect(GlContext ctx, Scope scope, ViewerEffect effect) {
            final TudeySceneView view = ScopeUtil.resolve(scope, "view:this", null, TudeySceneView.class);
            if (view == null) {
                return Camera.getNoopEffect(effect);
            }
            class CameraEffect
            extends ViewerEffect {
                protected float _transition;
                protected Easing _easing;
                protected CameraConfig _camcfg;
                protected boolean _activated;

                CameraEffect() {
                    this._transition = Camera.this.transition;
                    this._easing = Camera.this.easing;
                    this._camcfg = Camera.this.camera;
                }

                public void setConfig(Camera camera) {
                    if (this._activated) {
                        view.removeCameraConfig(this._camcfg, 0.0f, null);
                    }
                    this._transition = camera.transition;
                    this._easing = camera.easing;
                    this._camcfg = camera.camera;
                    if (this._activated) {
                        view.addCameraConfig(this._camcfg, 0.0f, null);
                    }
                }

                @Override
                public void activate(Scene scene) {
                    this._activated = true;
                    view.addCameraConfig(this._camcfg, this._transition, this._easing);
                }

                @Override
                public void deactivate() {
                    view.removeCameraConfig(this._camcfg, this._transition, this._easing);
                    this._activated = false;
                }
            }
            if (effect instanceof CameraEffect) {
                ((CameraEffect)effect).setConfig(this);
            } else {
                effect = new CameraEffect();
            }
            return effect;
        }
    }
}

