/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.samskivert.util.HashIntSet;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.samskivert.util.ObserverList;
import com.samskivert.util.RunAnywhere;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.math.FloatMath;
import com.threerings.math.Plane;
import com.threerings.math.Ray3D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.camera.MouseOrbiter;
import com.threerings.opengl.camera.OrbitCameraHandler;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.event.Event;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.event.MouseListener;
import com.threerings.opengl.gui.event.MouseMotionListener;
import com.threerings.opengl.gui.event.MouseWheelListener;
import com.threerings.opengl.gui.util.PseudoKeys;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.Tickable;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.MessageEvent;
import com.threerings.presents.dobj.MessageListener;
import com.threerings.tudey.Log;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.ActorSprite;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.client.sprite.Sprite;
import com.threerings.tudey.config.ClientActionConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.InputFrame;
import com.threerings.tudey.data.TudeyOccupantInfo;
import com.threerings.tudey.data.TudeySceneConfig;
import com.threerings.tudey.data.TudeySceneObject;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.Pawn;
import com.threerings.tudey.dobj.SceneDeltaEvent;
import com.threerings.tudey.dobj.SceneDeltaListener;
import com.threerings.tudey.util.PawnAdvancer;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.whirled.client.SceneController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TudeySceneController
extends SceneController
implements SceneDeltaListener,
MessageListener,
PseudoKeys.Observer,
MouseListener,
MouseMotionListener,
MouseWheelListener,
Tickable {
    protected TudeyContext _tctx;
    protected TudeySceneView _tsview;
    protected TudeySceneObject _tsobj;
    protected MouseOrbiter _orbiter;
    protected int _targetId;
    protected int _controlledId;
    protected Sprite _hsprite;
    protected boolean _holdHover;
    protected PseudoKeys.Unifier _unifier = new PseudoKeys.Unifier(this);
    protected IntMap<ObserverList<PseudoKeys.Observer>> _keyObservers = IntMaps.newHashIntMap();
    protected int _flags;
    protected Multimap<Integer, Integer> _flagPresses = HashMultimap.create();
    protected float[] _absoluteMoveAmounts = new float[4];
    protected float[] _relativeMoveAmounts = new float[4];
    protected IntMap<Float>[] _absoluteMovePresses = TudeySceneController.createDirectionPresses();
    protected IntMap<Float>[] _relativeMovePresses = TudeySceneController.createDirectionPresses();
    protected List<InputFrame> _input = Lists.newArrayList();
    protected InputFrame _lastFrame;
    protected List<PawnState> _states = Lists.newArrayList();
    protected PawnAdvancer _advancer;
    protected float _lastRotation;
    protected float _lastDirection;
    protected int _lastFlags;
    protected long _nextInput;
    protected long _lastTransmit;
    protected int _lastDelta;
    protected HashIntSet _strafePresses = new HashIntSet();
    protected int _tickCount;
    protected Ray3D _pick = new Ray3D();
    protected Plane _tplane = new Plane();
    protected Vector3f _isect = new Vector3f();
    protected Vector2f _translation = new Vector2f();
    protected static final float CONVERGENCE_RATE = 20.0f * FloatMath.log(0.5f);
    protected static final int UPSTREAM_RATE_LIMIT = 12288;
    protected static final Predicate<SceneElement> HOVER_FILTER = new Predicate<SceneElement>(){

        public boolean apply(SceneElement element) {
            Object obj = element.getUserObject();
            return obj instanceof Sprite && ((Sprite)obj).isHoverable();
        }
    };

    public int getTransmitInterval() {
        return ((TudeySceneConfig)this._config).getTransmitInterval();
    }

    public int getTargetId() {
        return this._targetId;
    }

    public int getControlledId() {
        return this._controlledId;
    }

    public boolean isControlledId(int actorId) {
        return actorId == this._controlledId;
    }

    public Sprite getHoverSprite() {
        return this._hsprite;
    }

    public void controlledActorAdded(int timestamp, Actor actor) {
        this._advancer = (PawnAdvancer)actor.maybeCreateAdvancer(this._tctx, this._tsview, timestamp);
        this._advancer.advance(this._tsview.getAdvancedTime());
    }

    public void controlledActorUpdated(int timestamp, Actor actor) {
        while (!this._states.isEmpty() && timestamp >= this._states.get(0).getFrame().getTimestamp()) {
            this._states.remove(0);
        }
        Actor oactor = this._advancer.getActor();
        Actor nactor = (Actor)actor.clone();
        this._advancer.init(nactor, timestamp);
        int advancedTime = this._tsview.getAdvancedTime();
        int nn = this._states.size();
        for (int ii = 0; ii < nn; ++ii) {
            PawnState state = this._states.get(ii);
            Pawn spawn = state.getPawn();
            this._advancer.advance(state.getFrame());
            if (spawn.equals(nactor)) {
                this._advancer.init(oactor, advancedTime);
                return;
            }
            nactor.copy(spawn);
        }
        if (this._lastFrame != null) {
            this._advancer.advance(this._lastFrame);
        }
        this._advancer.advance(advancedTime);
        Actor sactor = this._tsview.getControlledSprite().getActor();
        this._translation.set(sactor.getTranslation());
        nactor.copy(sactor);
        if (!sactor.isSet(1)) {
            sactor.getTranslation().set(this._translation);
        }
    }

    public void controlledSpriteRemoved(long timestamp) {
        this._advancer = null;
    }

    public void submitRequest(Sprite source, String name) {
        if (source instanceof ActorSprite) {
            this._tsobj.tudeySceneService.submitActorRequest(((ActorSprite)source).getActor().getId(), name);
        } else if (source instanceof EntrySprite) {
            this._tsobj.tudeySceneService.submitEntryRequest(((EntrySprite)source).getEntry().getKey(), name);
        } else {
            Log.log.warning((Object)"Tried to submit request from unknown sprite type.", new Object[]{"source", source, "name", name});
        }
    }

    @Override
    public void sceneDeltaReceived(SceneDeltaEvent event) {
        if (event.getSceneOid() != this._tsobj.getOid()) {
            Log.log.info((Object)"Received delta event for wrong scene.", new Object[]{"event", event});
            return;
        }
        int timestamp = event.getTimestamp();
        if (timestamp <= this._lastDelta) {
            return;
        }
        int acknowledge = event.getAcknowledge();
        while (!this._input.isEmpty() && this._input.get(0).getTimestamp() <= acknowledge) {
            this._input.remove(0);
        }
        if (this._tsview.processSceneDelta(event)) {
            this._lastDelta = timestamp;
        }
    }

    public void messageReceived(MessageEvent event) {
        if (event.getName().equals("forceClientAction")) {
            Object[] args = event.getArgs();
            ((ClientActionConfig)args[0]).execute(this._tctx, this._tsview, this._tsview.getSprite((EntityKey)((Object)args[1])));
        }
    }

    @Override
    public void keyPressed(final long when, final int key, final float amount) {
        ObserverList list;
        if (!this.mouseCameraEnabled() && (list = (ObserverList)this._keyObservers.get(key)) != null) {
            list.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<PseudoKeys.Observer>(){

                public boolean apply(PseudoKeys.Observer observer) {
                    observer.keyPressed(when, key, amount);
                    return true;
                }
            });
        }
    }

    @Override
    public void keyReleased(final long when, final int key) {
        ObserverList list;
        if (!this.mouseCameraEnabled() && (list = (ObserverList)this._keyObservers.get(key)) != null) {
            list.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<PseudoKeys.Observer>(){

                public boolean apply(PseudoKeys.Observer observer) {
                    observer.keyReleased(when, key);
                    return true;
                }
            });
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (!this.inputWindowHovered()) {
            return;
        }
        if (this._hsprite != null && this._hsprite.dispatchEvent(event)) {
            event.consume();
        }
        if (event.getButton() == 0) {
            this._holdHover = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (!this.inputWindowHovered()) {
            return;
        }
        if (this._hsprite != null && this._hsprite.dispatchEvent(event)) {
            event.consume();
        }
        if (event.getButton() == 0) {
            this._holdHover = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.maybeDispatchToHoverSprite(event);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.maybeDispatchToHoverSprite(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.maybeDispatchToHoverSprite(event);
    }

    @Override
    public void mouseWheeled(MouseEvent event) {
        this.maybeDispatchToHoverSprite(event);
    }

    @Override
    public void tick(float elapsed) {
        ++this._tickCount;
        this.updateInput(elapsed);
        long now = RunAnywhere.currentTimeMillis();
        if (now - this._lastTransmit >= (long)this.getTransmitInterval() && this._lastDelta > 0) {
            this.transmitInput();
            this._lastTransmit = now;
        }
    }

    public void wasAdded() {
        super.wasAdded();
        if (this.getMouseCameraModifiers() != 0) {
            OrbitCameraHandler camhand = this._tsview.getCameraHandler();
            this._orbiter = new MouseOrbiter(camhand, true){

                @Override
                public void mouseDragged(MouseEvent event) {
                    if (TudeySceneController.this.mouseCameraEnabled()) {
                        super.mouseDragged(event);
                    } else {
                        super.mouseMoved(event);
                    }
                }

                @Override
                public void mouseWheeled(MouseEvent event) {
                    if (TudeySceneController.this.mouseCameraEnabled()) {
                        super.mouseWheeled(event);
                    }
                }
            };
            this._tsview.getInputWindow().addListener(this._orbiter);
        }
    }

    public void wasRemoved() {
        super.wasRemoved();
        if (this._orbiter != null) {
            this._tsview.getInputWindow().removeListener(this._orbiter);
            this._orbiter = null;
        }
    }

    public void willEnterPlace(PlaceObject plobj) {
        super.willEnterPlace(plobj);
        this._tsobj = (TudeySceneObject)plobj;
        ClientObject clobj = this._ctx.getClient().getClientObject();
        clobj.addListener((ChangeListener)this);
        this._tsview.getInputWindow().addListener(this);
        this._tsview.getInputWindow().addListener(this._unifier);
        this._controlledId = this._tsobj.getPawnId(clobj.getOid());
        this._targetId = this._controlledId > 0 ? this._controlledId : this._tsobj.getFirstPawnId();
        this.bindKeys();
        if (this._tsobj.tudeySceneService != null) {
            this._tsobj.tudeySceneService.enteredPlace();
        }
    }

    public void didLeavePlace(PlaceObject plobj) {
        super.didLeavePlace(plobj);
        this._ctx.getClient().getClientObject().removeListener((ChangeListener)this);
        this._tsview.getInputWindow().removeListener(this);
        this._tsview.getInputWindow().removeListener(this._unifier);
    }

    protected PlaceView createPlaceView(CrowdContext ctx) {
        this._tsview = new TudeySceneView((TudeyContext)ctx, this);
        return this._tsview;
    }

    protected void didInit() {
        super.didInit();
        this._tctx = (TudeyContext)this._ctx;
    }

    protected void bindKeys() {
        if (this._controlledId > 0) {
            this.bindKeyMovement(256, this._relativeMoveAmounts, this._relativeMovePresses, 0);
            this.bindKeyMovement(17, this._absoluteMoveAmounts, this._absoluteMovePresses, 0);
            this.bindKeyMovement(31, this._absoluteMoveAmounts, this._absoluteMovePresses, 1);
            this.bindKeyMovement(30, this._absoluteMoveAmounts, this._absoluteMovePresses, 2);
            this.bindKeyMovement(32, this._absoluteMoveAmounts, this._absoluteMovePresses, 3);
            this.bindKeyStrafe(46);
        } else {
            this.bindKeyCycle(203, false);
            this.bindKeyCycle(205, true);
        }
    }

    protected void bindKeyFlag(int key, final int flag) {
        this.addKeyObserver(key, new PseudoKeys.Observer(){

            @Override
            public void keyPressed(long when, int key, float amount) {
                TudeySceneController.this._flagPresses.put((Object)flag, (Object)key);
                TudeySceneController.this.updateFlag(flag);
            }

            @Override
            public void keyReleased(long when, int key) {
                TudeySceneController.this._flagPresses.remove((Object)flag, (Object)key);
                TudeySceneController.this.updateFlag(flag);
            }
        });
    }

    protected void updateFlag(int flag) {
        if (flag == 1) {
            this.updateMoveFlag();
            return;
        }
        this._flags = this._flagPresses.containsKey((Object)flag) ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    protected void updateMoveFlag() {
        this._flags = this.isPressed(this._absoluteMoveAmounts) || this.isPressed(this._relativeMoveAmounts) || this._flagPresses.containsKey((Object)1) ? (this._flags |= 1) : (this._flags &= 0xFFFFFFFE);
    }

    protected boolean isPressed(float[] amounts) {
        float fx = amounts[3] - amounts[2];
        float fy = amounts[0] - amounts[1];
        return FloatMath.hypot(fx, fy) > 0.5f;
    }

    protected void bindKeyCycle(int key, final boolean forward) {
        this.addKeyObserver(key, new PseudoKeys.Adapter(){

            @Override
            public void keyPressed(long when, int key, float amount) {
                TudeySceneController.this.cycleTarget(forward);
            }
        });
    }

    protected void bindKeyMovement(int key, final float[] amounts, IntMap<Float>[] presses, final int idx) {
        final IntMap<Float> fpresses = presses[idx];
        this.addKeyObserver(key, new PseudoKeys.Observer(){

            @Override
            public void keyPressed(long when, int key, float amount) {
                fpresses.put(key, (Object)Float.valueOf(amount));
                this.updateAmount();
            }

            @Override
            public void keyReleased(long when, int key) {
                fpresses.remove(key);
                this.updateAmount();
            }

            protected void updateAmount() {
                float maximum = 0.0f;
                Iterator i$ = fpresses.values().iterator();
                while (i$.hasNext()) {
                    float value = ((Float)i$.next()).floatValue();
                    maximum = Math.max(maximum, value);
                }
                amounts[idx] = maximum;
                TudeySceneController.this.updateMoveFlag();
            }
        });
    }

    protected void bindKeyStrafe(int key) {
        this.addKeyObserver(key, new PseudoKeys.Observer(){

            @Override
            public void keyPressed(long when, int key, float amount) {
                TudeySceneController.this._strafePresses.add(key);
            }

            @Override
            public void keyReleased(long when, int key) {
                TudeySceneController.this._strafePresses.remove(key);
            }
        });
    }

    protected void addKeyObserver(int key, PseudoKeys.Observer observer) {
        this.addKeyObserver(key, observer, true);
    }

    protected void addKeyObserver(final int key, PseudoKeys.Observer observer, boolean hold) {
        ObserverList list;
        if (hold) {
            final PseudoKeys.Observer obs = observer;
            class Holder
            implements PseudoKeys.Observer,
            Runnable {
                protected int _pressTick;
                protected long _released;
                protected boolean _posted;

                Holder() {
                }

                @Override
                public void keyPressed(long when, int key2, float amount) {
                    obs.keyPressed(when, key2, amount);
                    this._pressTick = this._pressTick == 0 ? TudeySceneController.this._tickCount : this._pressTick;
                    this._released = 0L;
                }

                @Override
                public void keyReleased(long when, int key2) {
                    if (TudeySceneController.this._tickCount == this._pressTick) {
                        this._released = when;
                        if (!this._posted) {
                            TudeySceneController.this._ctx.getClient().getRunQueue().postRunnable((Runnable)this);
                            this._posted = true;
                        }
                    } else {
                        obs.keyReleased(when, key2);
                    }
                    this._pressTick = 0;
                }

                @Override
                public void run() {
                    if (this._released > 0L) {
                        obs.keyReleased(this._released, key);
                    }
                    this._posted = false;
                }
            }
            observer = new Holder();
        }
        if ((list = (ObserverList)this._keyObservers.get(key)) == null) {
            list = ObserverList.newFastUnsafe();
            this._keyObservers.put(key, (Object)list);
        }
        list.add((Object)observer);
    }

    protected void maybeDispatchToHoverSprite(Event event) {
        if (this.inputWindowHovered() && this._hsprite != null && this._hsprite.dispatchEvent(event)) {
            event.consume();
        }
    }

    protected boolean inputWindowHovered() {
        return this._tsview.getInputWindow().getState() == 1 && !this.mouseCameraEnabled();
    }

    protected boolean inputWindowFocused() {
        Root root = this._tctx.getRoot();
        if (root.getFocus() != null || this.mouseCameraEnabled()) {
            return false;
        }
        Window inputWindow = this._tsview.getInputWindow();
        for (int ii = root.getWindowCount() - 1; ii >= 0; --ii) {
            Window window = root.getWindow(ii);
            if (window == inputWindow) {
                return true;
            }
            if (!window.isModal()) continue;
            return false;
        }
        return false;
    }

    protected boolean mouseCameraEnabled() {
        int mods = this.getMouseCameraModifiers();
        return mods != 0 && (this._tctx.getRoot().getModifiers() & mods) == mods;
    }

    protected int getMouseCameraModifiers() {
        return 0;
    }

    protected void updateInput(float elapsed) {
        ActorSprite controlledSprite;
        boolean hovered = this.inputWindowHovered();
        Sprite nhsprite = null;
        if (hovered) {
            Root root = this._tctx.getRoot();
            this._tctx.getCompositor().getCamera().getPickRay(root.getMouseX(), root.getMouseY(), this._pick);
            Sprite sprite = nhsprite = this._holdHover && (this._hsprite == null || this._hsprite.isClickable()) ? this._hsprite : this.findHoverSprite(this._pick);
        }
        if (this._hsprite != nhsprite) {
            this.setHoverSprite(nhsprite);
        }
        if ((controlledSprite = this._tsview.getControlledSprite()) == null) {
            return;
        }
        float rotation = this._lastRotation;
        float direction = this._lastDirection;
        if (hovered && controlledSprite == this._tsview.getTargetSprite()) {
            Vector3f target = this._tsview.getCameraHandler().getTarget();
            this._tplane.set(Vector3f.UNIT_Z, -target.z);
            if (this._tplane.getIntersection(this._pick, this._isect) && !this._isect.equals(target)) {
                float dir = FloatMath.atan2(this._isect.y - target.y, this._isect.x - target.x);
                rotation = this._strafePresses.isEmpty() ? dir : this._lastRotation;
                direction = this.computeDirection(dir);
            }
        } else {
            direction = this.computeDirection(this._lastRotation);
        }
        if (!this.inputWindowFocused()) {
            this.clearInput();
        }
        long now = RunAnywhere.currentTimeMillis();
        if (rotation != this._lastRotation || direction != this._lastDirection || this._flags != this._lastFlags || now >= this._nextInput) {
            InputFrame frame = this._lastFrame = this.createInputFrame(this._tsview.getAdvancedTime(), rotation, direction, this._flags);
            this._lastRotation = rotation;
            this._lastDirection = direction;
            this._lastFlags = this._flags;
            this._nextInput = now + (long)this._tsview.getElapsed();
            this._input.add(frame);
            this._advancer.advance(frame);
            ((PawnAdvancer)controlledSprite.getAdvancer()).advance(frame);
            frame.setTranslation(new Vector2f(this._advancer.getActor().getTranslation()));
            this._states.add(new PawnState(frame, (Pawn)this._advancer.getActor().clone()));
        } else {
            int advancedTime = this._tsview.getAdvancedTime();
            this._advancer.advance(advancedTime);
            controlledSprite.getAdvancer().advance(advancedTime);
        }
        controlledSprite.getActor().getTranslation().lerpLocal(this._advancer.getActor().getTranslation(), 1.0f - FloatMath.exp(CONVERGENCE_RATE * elapsed));
    }

    protected Sprite findHoverSprite(Ray3D pick) {
        SceneElement element = this._tsview.getScene().getIntersection(pick, this._isect, HOVER_FILTER);
        return element == null ? null : (Sprite)element.getUserObject();
    }

    protected float computeDirection(float dir) {
        float fx = this._absoluteMoveAmounts[3] - this._absoluteMoveAmounts[2];
        float fy = this._absoluteMoveAmounts[0] - this._absoluteMoveAmounts[1];
        float flen = FloatMath.hypot(fx, fy);
        if (flen > 0.5f) {
            return FloatMath.atan2(fy, fx);
        }
        fx = this._relativeMoveAmounts[3] - this._relativeMoveAmounts[2];
        fy = this._relativeMoveAmounts[0] - this._relativeMoveAmounts[1];
        flen = FloatMath.hypot(fx, fy);
        return flen > 0.5f ? FloatMath.normalizeAngle(dir + FloatMath.atan2(-fx, fy)) : dir;
    }

    protected void clearInput() {
        int mask = ~this.getInputMask();
        this._flags &= mask;
        this._strafePresses.clear();
        this.clearDirection(this._relativeMoveAmounts, this._relativeMovePresses);
        this.clearDirection(this._absoluteMoveAmounts, this._absoluteMovePresses);
    }

    protected int getInputMask() {
        return 1;
    }

    protected void clearDirection(float[] amounts, IntMap<Float>[] presses) {
        Arrays.fill(amounts, 0.0f);
        for (IntMap<Float> map : presses) {
            map.clear();
        }
    }

    protected InputFrame createInputFrame(int timestamp, float rotation, float direction, int flags) {
        return new InputFrame(timestamp, rotation, direction, flags);
    }

    protected void setHoverSprite(Sprite nhsprite) {
        Root root = this._tctx.getRoot();
        if (this._hsprite != null) {
            this._hsprite.dispatchEvent(new MouseEvent(this, root.getTickStamp(), root.getModifiers(), 4, root.getMouseX(), root.getMouseY()));
        }
        if ((this._hsprite = nhsprite) != null) {
            this._hsprite.dispatchEvent(new MouseEvent(this, root.getTickStamp(), root.getModifiers(), 3, root.getMouseX(), root.getMouseY()));
        }
        root.tipTextChanged(this._tsview.getInputWindow());
    }

    protected void transmitInput() {
        int smoothedTime = this._tsview.getSmoothedTime();
        int cutoffTime = smoothedTime + Math.max(0, this._tsview.getPing() - Math.round((float)this._tsview.getElapsed() * 1.1f));
        while (this._input.size() > 1 && cutoffTime >= this._input.get(0).getTimestamp()) {
            this._input.remove(0);
        }
        if (!this._ctx.getClient().getTransmitDatagrams()) {
            this._tsobj.tudeySceneService.enqueueInputReliable(this._lastDelta, smoothedTime, this._input.toArray(new InputFrame[this._input.size()]));
            this._input.clear();
            return;
        }
        int size = 64;
        int nn = this._input.size();
        for (int ii = 0; ii < nn; ++ii) {
            size += this._input.get(ii).getApproximateSize();
        }
        int maxsize = 12288 * this.getTransmitInterval() / 1000;
        while (size > maxsize) {
            size -= this._input.remove(0).getApproximateSize();
        }
        this._tsobj.tudeySceneService.enqueueInputUnreliable(this._lastDelta, smoothedTime, this._input.toArray(new InputFrame[this._input.size()]));
    }

    protected void cycleTarget(boolean forward) {
        ArrayList list = Lists.newArrayList();
        for (OccupantInfo info : this._tsobj.occupantInfo) {
            int pawnId = ((TudeyOccupantInfo)info).pawnId;
            if (pawnId <= 0) continue;
            list.add(pawnId);
        }
        int size = list.size();
        if (size == 0) {
            return;
        }
        int idx = Math.max(list.indexOf(this._targetId), 0);
        int inc = forward ? 1 : size - 1;
        this.setTarget((Integer)list.get((idx + inc) % size));
    }

    protected void setTarget(int pawnId) {
        if (this._targetId == pawnId) {
            return;
        }
        this._targetId = pawnId;
        this._tsobj.tudeySceneService.setTarget(this._targetId);
        this._tsview.updateTargetSprite();
    }

    protected static IntMap<Float>[] createDirectionPresses() {
        IntMap[] presses = new IntMap[4];
        for (int ii = 0; ii < 4; ++ii) {
            presses[ii] = IntMaps.newHashIntMap();
        }
        return presses;
    }

    protected static class PawnState {
        protected InputFrame _frame;
        protected Pawn _pawn;

        public PawnState(InputFrame frame, Pawn pawn) {
            this._frame = frame;
            this._pawn = pawn;
        }

        public InputFrame getFrame() {
            return this._frame;
        }

        public Pawn getPawn() {
            return this._pawn;
        }
    }
}

