/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model;

import com.threerings.expr.Bound;
import com.threerings.expr.Executor;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.math.Box;
import com.threerings.math.Transform3D;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ScriptedConfig;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.GlContext;

public class Scripted
extends Model.Implementation {
    protected GlContext _ctx;
    protected ScriptedConfig _config;
    protected TimeExecutor[] _executors;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound
    protected Transform3D _localTransform;
    @Scoped
    protected Transform3D _worldTransform = new Transform3D();
    protected SceneElement.TickPolicy _tickPolicy;
    protected int _influenceFlags;
    @Scoped
    protected Box _bounds = new Box();
    protected Box _nbounds = new Box();
    protected float _time;
    protected int _eidx;
    protected boolean _completed;

    public Scripted(GlContext ctx, Scope parentScope, ScriptedConfig config) {
        super(parentScope);
        this.setConfig(ctx, config);
    }

    public void setConfig(GlContext ctx, ScriptedConfig config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    @Override
    public boolean hasCompleted() {
        return this._completed;
    }

    @Override
    public void reset() {
        this._eidx = 0;
        this._time = 0.0f;
        this._completed = false;
    }

    @Override
    public int getInfluenceFlags() {
        return this._influenceFlags;
    }

    @Override
    public Box getBounds() {
        return this._bounds;
    }

    @Override
    public void updateBounds() {
        this.tick(0.0f);
    }

    @Override
    public SceneElement.TickPolicy getTickPolicy() {
        return this._tickPolicy;
    }

    @Override
    public void tick(float elapsed) {
        if (this._parentWorldTransform == null) {
            this._worldTransform.set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }
        float expand = this._config.boundsExpansion;
        Box.ZERO.expand(expand, expand, expand, this._nbounds).transformLocal(this._worldTransform);
        if (!this._bounds.equals(this._nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(this._nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
        }
        if (this._completed) {
            return;
        }
        this._time += elapsed;
        this.executeActions();
        if (this._config.loopDuration > 0.0f) {
            if (this._time >= this._config.loopDuration) {
                this._time %= this._config.loopDuration;
                this._eidx = 0;
                this.executeActions();
            }
        } else if (this._eidx >= this._executors.length) {
            this._completed = true;
            ((Model)this._parentScope).completed(this);
        }
    }

    protected void updateFromConfig() {
        this._executors = new TimeExecutor[this._config.actions.length];
        for (int ii = 0; ii < this._executors.length; ++ii) {
            ScriptedConfig.TimeAction action = this._config.actions[ii];
            this._executors[ii] = new TimeExecutor(action.time, action.action.createExecutor(this._ctx, this));
        }
        this._influenceFlags = this._config.influences.getFlags();
        SceneElement.TickPolicy npolicy = this._config.tickPolicy;
        if (npolicy == SceneElement.TickPolicy.DEFAULT) {
            SceneElement.TickPolicy tickPolicy = npolicy = this._config.loopDuration > 0.0f ? SceneElement.TickPolicy.WHEN_VISIBLE : SceneElement.TickPolicy.ALWAYS;
        }
        if (this._tickPolicy != npolicy) {
            ((Model)this._parentScope).tickPolicyWillChange(this);
            this._tickPolicy = npolicy;
            ((Model)this._parentScope).tickPolicyDidChange(this);
        }
        this.updateBounds();
    }

    protected void executeActions() {
        while (this._eidx < this._executors.length && this._executors[this._eidx].time < this._time) {
            this._executors[this._eidx].executor.execute();
            ++this._eidx;
        }
    }

    protected static class TimeExecutor {
        public float time;
        public Executor executor;

        public TimeExecutor(float time, Executor executor) {
            this.time = time;
            this.executor = executor;
        }
    }
}

