/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.config.ConfigReference;
import com.threerings.expr.DynamicScope;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.UserInterface;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.config.UserInterfaceConfig;
import com.threerings.opengl.gui.layout.BorderLayout;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;

public class UserInterfaceWindow
extends Window
implements Renderer.Observer {
    protected DynamicScope _scope = new DynamicScope(this, "window");
    protected UserInterface _interface;
    protected boolean _stretch;

    public UserInterfaceWindow(GlContext ctx, boolean stretch) {
        this(ctx, stretch, (ConfigReference<UserInterfaceConfig>)null);
    }

    public UserInterfaceWindow(GlContext ctx, boolean stretch, String name) {
        this(ctx, stretch, new ConfigReference<UserInterfaceConfig>(name));
    }

    public UserInterfaceWindow(GlContext ctx, boolean stretch, String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this(ctx, stretch, new ConfigReference<UserInterfaceConfig>(name, firstKey, firstValue, otherArgs));
    }

    public UserInterfaceWindow(GlContext ctx, boolean stretch, ConfigReference<UserInterfaceConfig> ref) {
        super(ctx, new BorderLayout());
        this._scope.setParentScope(ctx.getScope());
        this._interface = this.createInterface();
        this._interface.getScope().setParentScope(this._scope);
        this._interface.setConfig(ref);
        this.add(this._interface, BorderLayout.CENTER);
        this._stretch = stretch;
    }

    public DynamicScope getScope() {
        return this._scope;
    }

    public UserInterface getInterface() {
        return this._interface;
    }

    public Component getComponent(String name) {
        return this._interface.getComponent(name);
    }

    @Override
    public void sizeChanged(int width, int height) {
        this.setSize(width, height);
    }

    @Override
    protected void wasAdded() {
        super.wasAdded();
        if (this._stretch) {
            Renderer renderer = this._ctx.getRenderer();
            this.setSize(renderer.getWidth(), renderer.getHeight());
            renderer.addObserver(this);
        }
    }

    @Override
    protected void wasRemoved() {
        super.wasRemoved();
        if (this._stretch) {
            this._ctx.getRenderer().removeObserver(this);
        }
    }

    protected UserInterface createInterface() {
        return new UserInterface(this._ctx);
    }
}

