/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.crowd.chat.client.ChatDisplay;
import com.threerings.crowd.chat.data.ChatMessage;
import com.threerings.crowd.chat.data.SystemMessage;
import com.threerings.crowd.chat.data.TellFeedbackMessage;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.opengl.gui.BoundedRangeModel;
import com.threerings.opengl.gui.Button;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.TextArea;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import com.threerings.opengl.gui.event.ChangeEvent;
import com.threerings.opengl.gui.event.ChangeListener;
import com.threerings.opengl.gui.layout.GroupLayout;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.MessageBundle;

public class ChatOverlay
extends Container
implements ChatDisplay {
    protected MessageBundle _msgs;
    protected Color4f[] _systemColors = new Color4f[3];
    protected Button _less;
    protected Button _more;
    protected Button _end;
    protected TextArea _area;

    public ChatOverlay(GlContext ctx) {
        super(ctx, GroupLayout.makeHStretch());
        this.setBundle("global");
        String prefix = "Default/ChatOverlay";
        this._area = new TextArea(this._ctx);
        this._area.setStyleConfig(prefix + "Text");
        final BoundedRangeModel model = this._area.getScrollModel();
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ChatOverlay.this.updateButtons();
            }
        });
        Container bcont = GroupLayout.makeVBox(ctx, GroupLayout.BOTTOM);
        this.add(bcont, GroupLayout.FIXED);
        this.add(this._area);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == ChatOverlay.this._less) {
                    model.setValue(model.getValue() - 1);
                } else if (source == ChatOverlay.this._more) {
                    model.setValue(model.getValue() + 1);
                } else if (source == ChatOverlay.this._end) {
                    model.setValue(model.getMaximum() - model.getExtent());
                }
            }
        };
        this._less = new Button(this._ctx, "", al, "less");
        this._less.setStyleConfig(prefix + "Less");
        this._less.setEnabled(false);
        bcont.add(this._less);
        this._more = new Button(this._ctx, "", al, "more");
        this._more.setStyleConfig(prefix + "More");
        this._more.setEnabled(false);
        bcont.add(this._more);
        this._end = new Button(this._ctx, "", al, "end");
        this._end.setStyleConfig(prefix + "End");
        this._end.setEnabled(false);
        bcont.add(this._end);
    }

    public void setBundle(String bundle) {
        this._msgs = this._ctx.getMessageManager().getBundle(bundle);
    }

    public void setPreferredWidth(int width) {
        this._area.setPreferredWidth(width);
    }

    public void setSystemColors(Color4f info, Color4f feedback, Color4f attention) {
        this._systemColors[0] = info;
        this._systemColors[1] = feedback;
        this._systemColors[2] = attention;
    }

    public void clear() {
        this._area.clearText();
    }

    public boolean displayMessage(ChatMessage msg, boolean alreadyDisplayed) {
        BoundedRangeModel model;
        String format = msg.getFormat();
        String text = msg.message;
        if (format != null && msg instanceof UserMessage) {
            UserMessage umsg = (UserMessage)msg;
            text = this._msgs.get(format, new Object[]{umsg.getSpeakerDisplayName(), text});
        }
        boolean end = (model = this._area.getScrollModel()).getValue() == model.getMaximum() - model.getExtent();
        this.appendMessage(msg, text + "\n", this.getColor(msg));
        if (end) {
            this._area.validate();
            model.setValue(model.getMaximum() - model.getExtent());
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
    }

    @Override
    public Component getHitComponent(int mx, int my) {
        Component comp = super.getHitComponent(mx, my);
        return (comp == this._less || comp == this._more || comp == this._end) && comp.isEnabled() ? comp : null;
    }

    @Override
    public void validate() {
        BoundedRangeModel model = this._area.getScrollModel();
        boolean end = model.getValue() == model.getMaximum() - model.getExtent();
        super.validate();
        if (end) {
            model.setValue(model.getMaximum() - model.getExtent());
        }
    }

    protected Color4f getColor(ChatMessage msg) {
        if (msg instanceof SystemMessage) {
            return this._systemColors[((SystemMessage)msg).attentionLevel];
        }
        if (msg instanceof TellFeedbackMessage) {
            return this._systemColors[1];
        }
        return null;
    }

    protected void appendMessage(ChatMessage msg, String text, Color4f color) {
        this._area.appendText(text, color);
    }

    protected void updateButtons() {
        if (!this.isEnabled()) {
            this._less.setEnabled(false);
            this._more.setEnabled(false);
            this._end.setEnabled(false);
            return;
        }
        BoundedRangeModel model = this._area.getScrollModel();
        int value = model.getValue();
        this._less.setEnabled(value > model.getMinimum());
        boolean more = value + model.getExtent() < model.getMaximum();
        this._more.setEnabled(more);
        this._end.setEnabled(more);
    }

    @Override
    protected void wasAdded() {
        super.wasAdded();
        this._area.invalidate();
    }
}

