/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.threerings.export.Exportable;
import com.threerings.export.Importer;
import com.threerings.export.Log;
import com.threerings.export.Stringifier;
import com.threerings.util.ReflectionUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLImporter
extends Importer {
    protected InputStream _in;
    protected Document _document;
    protected Element _element;
    protected HashMap<String, Object> _objects = new HashMap();

    public XMLImporter(InputStream in) {
        this._in = in;
    }

    @Override
    public Object readObject() throws IOException {
        Node first;
        if (this._document == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                this._document = builder.parse(this._in);
            }
            catch (Exception e) {
                throw new IOException("Failed to parse input [error=" + e + "].");
            }
            Element top = this._document.getDocumentElement();
            if (!top.getTagName().equals("java")) {
                throw new IOException("Invalid top-level element [name=" + top.getTagName() + "].");
            }
            String vstr = top.getAttribute("version");
            if (!vstr.equals("1.0")) {
                throw new IOException("Invalid version [version=" + vstr + ", expected=" + "1.0" + "].");
            }
            String cstr = top.getAttribute("class");
            if (!cstr.equals(this.getClass().getName())) {
                throw new IOException("Invalid importer class [class=" + cstr + ", expected=" + this.getClass().getName() + "].");
            }
            first = top.getFirstChild();
        } else {
            first = this._element == null ? null : this._element.getNextSibling();
        }
        this._element = XMLImporter.findElement(first, "object");
        if (this._element == null) {
            throw new EOFException();
        }
        return this.read(this._element, Object.class);
    }

    @Override
    public boolean read(String name, boolean defvalue) throws IOException {
        String value = this.getValue(name);
        return value == null ? defvalue : Boolean.parseBoolean(value);
    }

    @Override
    public byte read(String name, byte defvalue) throws IOException {
        String value = this.getValue(name);
        try {
            return value == null ? defvalue : Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            Log.log.warning((Object)("Couldn't parse value as byte [value=" + value + "]."), new Object[]{e});
            return defvalue;
        }
    }

    @Override
    public char read(String name, char defvalue) throws IOException {
        String value = this.getValue(name);
        return value == null ? defvalue : value.charAt(0);
    }

    @Override
    public double read(String name, double defvalue) throws IOException {
        String value = this.getValue(name);
        try {
            return value == null ? defvalue : Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            Log.log.warning((Object)("Couldn't parse value as double [value=" + value + "]."), new Object[]{e});
            return defvalue;
        }
    }

    @Override
    public float read(String name, float defvalue) throws IOException {
        String value = this.getValue(name);
        try {
            return value == null ? defvalue : Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            Log.log.warning((Object)("Couldn't parse value as float [value=" + value + "]."), new Object[]{e});
            return defvalue;
        }
    }

    @Override
    public int read(String name, int defvalue) throws IOException {
        String value = this.getValue(name);
        try {
            return value == null ? defvalue : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Log.log.warning((Object)("Couldn't parse value as int [value=" + value + "]."), new Object[]{e});
            return defvalue;
        }
    }

    @Override
    public long read(String name, long defvalue) throws IOException {
        String value = this.getValue(name);
        try {
            return value == null ? defvalue : Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Log.log.warning((Object)("Couldn't parse value as long [value=" + value + "]."), new Object[]{e});
            return defvalue;
        }
    }

    @Override
    public short read(String name, short defvalue) throws IOException {
        String value = this.getValue(name);
        try {
            return value == null ? defvalue : Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            Log.log.warning((Object)("Couldn't parse value as short [value=" + value + "]."), new Object[]{e});
            return defvalue;
        }
    }

    @Override
    public <T> T read(String name, T defvalue, Class<T> clazz) throws IOException {
        Element child = XMLImporter.findElement(this._element.getFirstChild(), name);
        if (child == null) {
            return defvalue;
        }
        return clazz.cast(this.read(child, clazz));
    }

    @Override
    public void close() throws IOException {
        this._in.close();
    }

    protected Object read(Element element, Class<?> clazz) throws IOException {
        String ref = element.getAttribute("ref");
        if (ref.length() > 0) {
            return this._objects.get(ref);
        }
        if (element.getFirstChild() == null) {
            return null;
        }
        return this.readValue(element, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readValue(Element element, Class<?> clazz) throws IOException {
        Class<?> cclazz;
        String id = element.getAttribute("id");
        String cstr = element.getAttribute("class");
        if (cstr.length() > 0) {
            try {
                cclazz = Class.forName(cstr);
            }
            catch (ClassNotFoundException e) {
                Log.log.warning((Object)"Class not found.", new Object[]{e});
                return null;
            }
        } else {
            cclazz = clazz;
        }
        Stringifier stringifier = Stringifier.getStringifier(cclazz);
        if (stringifier != null) {
            String string = element.getTextContent();
            Object value = null;
            try {
                Object t = stringifier.fromString(string);
                value = t;
                if (t == null) {
                    Log.log.warning((Object)"Failed to parse string.", new Object[]{"string", string, "class", cclazz});
                }
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to parse string.", new Object[]{"string", string, "class", cclazz, e});
            }
            if (id.length() > 0 && value != null) {
                this.putObject(id, value);
            }
            return value;
        }
        Element oelement = this._element;
        this._element = element;
        try {
            Object value;
            boolean wasRead = false;
            if (cclazz.isArray()) {
                value = Array.newInstance(cclazz.getComponentType(), this.countEntries());
            } else if (cclazz == ImmutableList.class) {
                value = ImmutableList.copyOf(this.readEntries(Lists.newArrayList()));
                wasRead = true;
            } else if (cclazz == ImmutableSet.class) {
                value = ImmutableSet.copyOf(this.readEntries(Lists.newArrayList()));
                wasRead = true;
            } else if (cclazz == ImmutableMap.class) {
                value = ImmutableMap.copyOf(this.readEntries(Maps.newHashMap()));
                wasRead = true;
            } else {
                value = ReflectionUtil.newInstance(cclazz, ReflectionUtil.isInner(cclazz) ? this.read("outer", null, Object.class) : null);
            }
            if (id.length() > 0) {
                this.putObject(id, value);
            }
            if (wasRead) {
                Object object = value;
                return object;
            }
            if (value instanceof Exportable) {
                this.readFields((Exportable)value);
            } else if (value instanceof Object[]) {
                this.readEntries((Object[])value, cclazz.getComponentType());
            } else if (value instanceof Collection) {
                Collection collection = (Collection)value;
                this.readEntries(collection);
            } else if (value instanceof Map) {
                Map map = (Map)value;
                this.readEntries(map);
            }
            Object object = value;
            return object;
        }
        finally {
            this._element = oelement;
        }
    }

    protected void putObject(String id, Object value) {
        Object ovalue = this._objects.put(id, value);
        if (ovalue != null) {
            Log.log.warning((Object)"Duplicate id detected.", new Object[]{"id", id, "ovalue", ovalue, "nvalue", value});
        }
    }

    protected int countEntries() {
        int count = 0;
        for (Node node = this._element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !node.getNodeName().equals("entry")) continue;
            ++count;
        }
        return count;
    }

    protected void readEntries(Object[] array, Class<?> cclazz) throws IOException {
        int idx = 0;
        for (Node node = this._element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !node.getNodeName().equals("entry")) continue;
            array[idx++] = this.read((Element)node, cclazz);
        }
    }

    protected Collection<Object> readEntries(Collection<Object> collection) throws IOException {
        for (Node node = this._element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !node.getNodeName().equals("entry")) continue;
            collection.add(this.read((Element)node, Object.class));
        }
        return collection;
    }

    protected Map<Object, Object> readEntries(Map<Object, Object> map) throws IOException {
        block0: for (Node node = this._element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !node.getNodeName().equals("key")) continue;
            Object key = this.read((Element)node, Object.class);
            for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element) || !node.getNodeName().equals("value")) continue;
                map.put(key, this.read((Element)node, Object.class));
                continue block0;
            }
        }
        return map;
    }

    protected String getValue(String name) {
        Element child = XMLImporter.findElement(this._element.getFirstChild(), name);
        if (child == null) {
            return null;
        }
        for (Node node = child.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Text)) continue;
            return node.getNodeValue();
        }
        return null;
    }

    protected static Element findElement(Node first, String name) {
        for (Node node = first; node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !node.getNodeName().equals(name)) continue;
            return (Element)node;
        }
        return null;
    }
}

