/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Stringifier;
import com.threerings.export.XMLImporter;
import com.threerings.util.ReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class XMLExporter
extends Exporter {
    public static final String VERSION = "1.0";
    protected OutputStream _out;
    protected Document _document;
    protected Element _element;
    protected String _indent = "";
    protected IdentityHashMap<Object, Element> _elements = new IdentityHashMap();
    protected int _lastObjectId;

    public XMLExporter(OutputStream out) {
        this._out = out;
    }

    @Override
    public void writeObject(Object object) throws IOException {
        if (this._document == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                this._document = builder.newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new IOException("Error creating XML document [error=" + e + "].");
            }
            this._element = this._document.createElement("java");
            this._document.appendChild(this._element);
            this._element.setAttribute("version", VERSION);
            this._element.setAttribute("class", XMLImporter.class.getName());
            this.appendln();
        }
        this.write("object", object, Object.class);
    }

    @Override
    public void write(String name, boolean value) throws IOException {
        this.setValue(name, Boolean.toString(value));
    }

    @Override
    public void write(String name, byte value) throws IOException {
        this.setValue(name, Byte.toString(value));
    }

    @Override
    public void write(String name, char value) throws IOException {
        this.setValue(name, Character.toString(value));
    }

    @Override
    public void write(String name, double value) throws IOException {
        this.setValue(name, Double.toString(value));
    }

    @Override
    public void write(String name, float value) throws IOException {
        this.setValue(name, Float.toString(value));
    }

    @Override
    public void write(String name, int value) throws IOException {
        this.setValue(name, Integer.toString(value));
    }

    @Override
    public void write(String name, long value) throws IOException {
        this.setValue(name, Long.toString(value));
    }

    @Override
    public void write(String name, short value) throws IOException {
        this.setValue(name, Short.toString(value));
    }

    @Override
    public <T> void write(String name, T value, Class<T> clazz) throws IOException {
        for (Node node = this._element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !node.getNodeName().equals(name)) continue;
            Element child = (Element)node;
            child.setTextContent(null);
            this.write(child, value, clazz);
            return;
        }
        this.append(name, value, clazz);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this._out.close();
    }

    @Override
    public void finish() throws IOException {
        DOMImplementationLS impl = (DOMImplementationLS)((Object)this._document.getImplementation());
        LSOutput lsout = impl.createLSOutput();
        lsout.setByteStream(this._out);
        LSSerializer serializer = impl.createLSSerializer();
        serializer.write(this._document, lsout);
    }

    protected <T> void append(String name, T value, Class<T> clazz) throws IOException {
        this.appendIndent();
        Element child = this._document.createElement(name);
        this._element.appendChild(child);
        this.write(child, value, clazz);
        this.appendln();
    }

    protected void write(Element element, Object value, Class<?> clazz) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof Class || value instanceof Double || value instanceof Enum || value instanceof Float || value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof String || value instanceof File) {
            this.writeValue(element, value, clazz);
            return;
        }
        Element previous = this._elements.get(value);
        if (previous != null) {
            String id = previous.getAttribute("id");
            if (id.length() == 0) {
                id = Integer.toString(++this._lastObjectId);
                previous.setAttribute("id", id);
            }
            element.setAttribute("ref", id);
        } else {
            this._elements.put(value, element);
            this.writeValue(element, value, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeValue(Element element, Object value, Class<?> clazz) throws IOException {
        block10: {
            Stringifier stringifier;
            Class<?> cclazz = XMLExporter.getClass(value);
            if (cclazz != clazz) {
                element.setAttribute("class", cclazz.getName());
            }
            if ((stringifier = Stringifier.getStringifier(cclazz)) != null) {
                String str = stringifier.toString(value);
                element.appendChild(str.length() == 0 ? this._document.createComment("empty") : this._document.createTextNode(str));
                return;
            }
            String oindent = this._indent;
            Element oelement = this._element;
            this._element = element;
            this._indent = this._indent + "  ";
            try {
                this.appendln();
                Object outer = ReflectionUtil.getOuter(value);
                if (outer != null) {
                    this.write("outer", outer, Object.class);
                }
                if (value instanceof Exportable) {
                    this.writeFields((Exportable)value);
                    break block10;
                }
                if (value instanceof Object[]) {
                    Class<?> ctype = cclazz.getComponentType();
                    this.writeEntries((Object[])value, ctype);
                    break block10;
                }
                if (value instanceof Collection) {
                    this.writeEntries((Collection)value);
                    break block10;
                }
                if (value instanceof Map) {
                    this.writeEntries((Map)value);
                    break block10;
                }
                throw new IOException("Value is not exportable [class=" + cclazz + "].");
            }
            finally {
                this._indent = oindent;
                this.appendIndent();
                this._element = oelement;
            }
        }
    }

    protected <T> void writeEntries(T[] array, Class<T> ctype) throws IOException {
        for (T entry : array) {
            this.append("entry", entry, ctype);
        }
    }

    protected void writeEntries(Collection collection) throws IOException {
        for (Object entry : collection) {
            this.append("entry", entry, Object.class);
        }
    }

    protected void writeEntries(Map<?, ?> map) throws IOException {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.append("key", entry.getKey(), Object.class);
            this.append("value", entry.getValue(), Object.class);
        }
    }

    protected void setValue(String name, String value) {
        for (Node node = this._element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !node.getNodeName().equals(name)) continue;
            Element child = (Element)node;
            child.setTextContent(null);
            child.appendChild(this._document.createTextNode(value));
            return;
        }
        this.appendIndent();
        Element child = this._document.createElement(name);
        this._element.appendChild(child);
        child.appendChild(this._document.createTextNode(value));
        this.appendln();
    }

    protected void appendIndent() {
        this._element.appendChild(this._document.createTextNode(this._indent));
    }

    protected void appendln() {
        this._element.appendChild(this._document.createTextNode("\n"));
    }
}

