/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.editor.Log;
import com.threerings.editor.Property;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.swing.BasePropertyEditor;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.editor.swing.TreeEditorPanel;
import com.threerings.editor.util.EditorContext;
import com.threerings.util.DeepUtil;
import com.threerings.util.ReflectionUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ObjectPanel
extends BasePropertyEditor
implements ActionListener,
ChangeListener {
    protected EditorContext _ctx;
    protected JComboBox _box;
    protected BaseEditorPanel _panel;
    protected Object _outer;
    protected Class<?>[] _types;
    protected Object[] _values;
    protected Object _lvalue;

    public ObjectPanel(EditorContext ctx, String tlabel, Class<?>[] types, Property[] ancestors, Object outer) {
        this(ctx, tlabel, types, ancestors, outer, false);
    }

    public ObjectPanel(EditorContext ctx, String tlabel, Class<?>[] types, Property[] ancestors, Object outer, boolean omitColumns) {
        this._ctx = ctx;
        this._msgmgr = ctx.getMessageManager();
        this._msgs = this._msgmgr.getBundle("editor.default");
        this._outer = outer;
        this._types = types;
        this.setBackground(this.getBackgroundColor(ancestors));
        this.setLayout((LayoutManager)new VGroupLayout(GroupLayout.NONE, GroupLayout.STRETCH, 5, GroupLayout.TOP));
        if (this._types.length > 1) {
            JPanel tpanel = new JPanel();
            tpanel.setBackground(null);
            this.add(tpanel);
            tpanel.add(new JLabel(this.getLabel(tlabel) + ":"));
            String[] labels = new String[this._types.length];
            for (int ii = 0; ii < this._types.length; ++ii) {
                labels[ii] = this.getLabel(this._types[ii]);
            }
            this._box = new JComboBox<String>(labels);
            tpanel.add(this._box);
            this._box.addActionListener(this);
            this._values = new Object[this._types.length];
        }
        this._panel = new EditorPanel(this._ctx, EditorPanel.CategoryMode.PANELS, ancestors, omitColumns);
        this.add((Component)((Object)this._panel));
        this._panel.addChangeListener(this);
    }

    public void setOuter(Object outer) {
        this._outer = outer;
    }

    public void setValue(Object value) {
        int tidx = this.getTypeIndex(value);
        if (tidx == -1) {
            Log.log.warning((Object)"Wrong type for object panel.", new Object[]{"value", value, "types", this._types});
            return;
        }
        if (this._box != null) {
            Arrays.fill(this._values, null);
            this._values[tidx] = value;
            this._box.removeActionListener(this);
            this._box.setSelectedIndex(tidx);
            this._box.addActionListener(this);
        }
        this._lvalue = value;
        if (this._panel.getObject() == this._lvalue) {
            this._panel.update();
        } else {
            this._panel.setObject(value);
        }
    }

    public Object getValue() {
        return this._panel.getObject();
    }

    @Override
    public void setTreeModeEnabled(boolean enabled) {
        BaseEditorPanel opanel = this._panel;
        this.remove((Component)((Object)opanel));
        this._panel = enabled ? new TreeEditorPanel(this._ctx, opanel.getAncestors(), opanel.getOmitColumns()) : new EditorPanel(this._ctx, EditorPanel.CategoryMode.PANELS, opanel.getAncestors(), opanel.getOmitColumns());
        this.add((Component)((Object)this._panel));
        this._panel.addChangeListener(this);
        this._panel.setObject(opanel.getObject());
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int idx = this._box.getSelectedIndex();
        Object value = null;
        Class<?> type = this._types[idx];
        if (type != null) {
            value = this._values[idx];
            if (value == null) {
                try {
                    this._values[idx] = value = this.newInstance(type);
                }
                catch (Exception e) {
                    Log.log.warning((Object)("Failed to create instance [type=" + type + "]."), new Object[]{e});
                }
            }
            if (this._lvalue != null && value != null) {
                DeepUtil.transfer(this._lvalue, value);
            }
        }
        this._panel.setObject(value);
        if (value != null) {
            this._lvalue = value;
        }
        this.fireStateChanged();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireStateChanged();
    }

    @Override
    protected String getMousePath(Point pt) {
        return this._panel.getMousePath();
    }

    protected int getTypeIndex(Object value) {
        Class<?> type = value == null ? null : value.getClass();
        for (int ii = 0; ii < this._types.length; ++ii) {
            if (this._types[ii] != type) continue;
            return ii;
        }
        return -1;
    }

    protected Object newInstance(Class<?> type) throws Exception {
        if (this._lvalue != null) {
            boolean inner = ReflectionUtil.isInner(type);
            this._lvalue.getClass();
            Constructor<?> cctor = null;
            Class<?> cptype = null;
            for (Constructor<?> ctor : type.getConstructors()) {
                Class<?>[] ptypes = ctor.getParameterTypes();
                if (!inner ? ptypes.length != 1 : ptypes.length != 2 || !ptypes[0].isInstance(this._outer)) continue;
                Class<?> ptype = ptypes[ptypes.length - 1];
                if (!ptype.isInstance(this._lvalue) || cctor != null && !cptype.isAssignableFrom(ptype)) continue;
                cctor = ctor;
                cptype = ptype;
            }
            if (cctor != null) {
                return inner ? cctor.newInstance(this._outer, this._lvalue) : cctor.newInstance(this._lvalue);
            }
        }
        return ReflectionUtil.newInstance(type, this._outer);
    }
}

