/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor;

import com.samskivert.util.ClassUtil;
import com.samskivert.util.Config;
import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Introspector;
import com.threerings.editor.Log;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Property
extends DeepObject {
    protected String _name;
    @DeepOmit
    protected HashMap<Class<?>, Class<?>[]> _argumentTypes;
    @DeepOmit
    protected HashMap<Class<?>, Type[]> _genericArgumentTypes;
    protected static HashMap<String, Class<?>[]> _configTypes = new HashMap();

    public String getName() {
        return this._name;
    }

    public boolean shouldTranslateName() {
        return true;
    }

    public String getColorName() {
        return this._name;
    }

    public Class<?>[] getSubtypes() {
        return this.getSubtypes(this.getType());
    }

    public Class<?>[] getComponentSubtypes() {
        return this.getSubtypes(this.getComponentType());
    }

    public String getTypeLabel() {
        return this.getTypeLabel(this.getType());
    }

    public String getComponentTypeLabel() {
        return this.getTypeLabel(this.getComponentType());
    }

    public String getMessageBundle() {
        return Introspector.getMessageBundle(this.getMember().getDeclaringClass());
    }

    public abstract Member getMember();

    public Object getMemberObject(Object object) {
        return object;
    }

    public abstract Class<?> getType();

    public abstract Type getGenericType();

    public Class<?> getComponentType() {
        Class<?> type = this.getType();
        if (type.isArray()) {
            return type.getComponentType();
        }
        if (Collection.class.isAssignableFrom(type)) {
            return this.getArgumentType(Collection.class);
        }
        return null;
    }

    public Type getGenericComponentType() {
        Class<?> type = this.getType();
        Type gtype = this.getGenericType();
        if (gtype instanceof GenericArrayType) {
            return ((GenericArrayType)gtype).getGenericComponentType();
        }
        if (type.isArray()) {
            return type.getComponentType();
        }
        if (Collection.class.isAssignableFrom(type)) {
            return this.getGenericArgumentType(Collection.class);
        }
        return null;
    }

    public Class<?> getArgumentType(Class<?> clazz) {
        Class<?>[] types = this.getArgumentTypes(clazz);
        return types == null || types.length == 0 ? null : types[0];
    }

    public Class<?>[] getArgumentTypes(Class<?> clazz) {
        Type[] types;
        Class<?>[] classes;
        if (this._argumentTypes == null) {
            this._argumentTypes = new HashMap(0);
        }
        if ((classes = this._argumentTypes.get(clazz)) == null && (types = this.getGenericArgumentTypes(clazz)) != null) {
            classes = new Class[types.length];
            this._argumentTypes.put(clazz, classes);
            for (int ii = 0; ii < classes.length; ++ii) {
                classes[ii] = this.getTypeClass(types[ii]);
            }
        }
        return classes;
    }

    public Type getGenericArgumentType(Class<?> clazz) {
        Type[] types = this.getGenericArgumentTypes(clazz);
        return types == null || types.length == 0 ? null : types[0];
    }

    public Type[] getGenericArgumentTypes(Class<?> clazz) {
        Type[] types;
        if (this._genericArgumentTypes == null) {
            this._genericArgumentTypes = new HashMap(0);
        }
        if ((types = this._genericArgumentTypes.get(clazz)) == null) {
            types = Property.getTypeArguments(this.getGenericType(), clazz);
            this._genericArgumentTypes.put(clazz, types);
        }
        return types;
    }

    public boolean isLegalValue(Object value) {
        return this.isLegalValue(this.getType(), value);
    }

    public boolean isLegalComponentValue(Object value) {
        return this.isLegalValue(this.getComponentType(), value);
    }

    public String getMode() {
        return this.getAnnotation().mode();
    }

    public String getUnits() {
        return this.getAnnotation().units();
    }

    public double getMinimum() {
        return this.getAnnotation().min();
    }

    public double getMaximum() {
        return this.getAnnotation().max();
    }

    public double getStep() {
        return this.getAnnotation().step();
    }

    public double getScale() {
        return this.getAnnotation().scale();
    }

    public int getMinSize() {
        return this.getAnnotation().minsize();
    }

    public int getMaxSize() {
        return this.getAnnotation().maxsize();
    }

    public Editable getAnnotation() {
        return this.getAnnotation(Editable.class);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getAnnotation(clazz) != null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return ((AnnotatedElement)((Object)this.getMember())).getAnnotation(clazz);
    }

    public boolean getBoolean(Object object) {
        return (Boolean)this.get(object);
    }

    public byte getByte(Object object) {
        return (Byte)this.get(object);
    }

    public char getChar(Object object) {
        return ((Character)this.get(object)).charValue();
    }

    public double getDouble(Object object) {
        return (Double)this.get(object);
    }

    public float getFloat(Object object) {
        return ((Float)this.get(object)).floatValue();
    }

    public int getInt(Object object) {
        return (Integer)this.get(object);
    }

    public long getLong(Object object) {
        return (Long)this.get(object);
    }

    public short getShort(Object object) {
        return (Short)this.get(object);
    }

    public abstract Object get(Object var1);

    public void setBoolean(Object object, boolean value) {
        this.set(object, value);
    }

    public void setByte(Object object, byte value) {
        this.set(object, value);
    }

    public void setChar(Object object, char value) {
        this.set(object, Character.valueOf(value));
    }

    public void setDouble(Object object, double value) {
        this.set(object, value);
    }

    public void setFloat(Object object, float value) {
        this.set(object, Float.valueOf(value));
    }

    public void setInt(Object object, int value) {
        this.set(object, value);
    }

    public void setLong(Object object, long value) {
        this.set(object, value);
    }

    public void setShort(Object object, short value) {
        this.set(object, value);
    }

    public abstract void set(Object var1, Object var2);

    @Override
    public String toString() {
        return this._name;
    }

    protected String getTypeLabel(Class<?> type) {
        EditorTypes annotation = this.getEditorTypes(type);
        return annotation == null ? "type" : annotation.label();
    }

    protected Class<?>[] getSubtypes(Class<?> type) {
        Class<?>[] ctypes;
        String key;
        EditorTypes ownAnnotation;
        EditorTypes annotation;
        ArrayList types = new ArrayList();
        boolean nullable = this.getAnnotation().nullable();
        if (nullable) {
            types.add(null);
        }
        EditorTypes editorTypes = annotation = (ownAnnotation = this.getAnnotation(EditorTypes.class)) == null ? type.getAnnotation(EditorTypes.class) : ownAnnotation;
        if (annotation != null) {
            Property.addSubtypes(annotation, types);
        }
        String string = key = annotation == null ? type.getName() : annotation.key();
        if (StringUtil.isBlank((String)key)) {
            if (annotation == ownAnnotation) {
                Member member = this.getMember();
                key = member.getDeclaringClass().getName() + "." + member.getName();
            } else {
                key = type.getName();
            }
        }
        if ((ctypes = _configTypes.get(key)) != null) {
            Collections.addAll(types, ctypes);
        }
        if (types.size() == (nullable ? 1 : 0)) {
            types.add(type);
        }
        return types.toArray(new Class[types.size()]);
    }

    protected EditorTypes getEditorTypes(Class<?> type) {
        EditorTypes annotation = this.getAnnotation(EditorTypes.class);
        return annotation == null ? type.getAnnotation(EditorTypes.class) : annotation;
    }

    protected static Type[] getTypeArguments(Type type, Class<?> clazz) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            return Property.getTypeArguments((Class)ptype.getRawType(), ptype.getActualTypeArguments(), clazz);
        }
        if (type instanceof Class) {
            return Property.getTypeArguments((Class)type, null, clazz);
        }
        return null;
    }

    protected static Type[] getTypeArguments(Class<?> type, Type[] args, Class<?> clazz) {
        if (type == clazz) {
            return args;
        }
        TypeVariable[] params = type.getTypeParameters();
        for (Type iface : type.getGenericInterfaces()) {
            Type[] result = Property.getTypeArguments(iface, params, args, clazz);
            if (result == null) continue;
            return result;
        }
        return Property.getTypeArguments(type.getGenericSuperclass(), params, args, clazz);
    }

    protected static Type[] getTypeArguments(Type type, TypeVariable[] params, Type[] values, Class<?> clazz) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            for (int ii = 0; ii < args.length; ++ii) {
                int idx;
                Type arg = args[ii];
                if (!(arg instanceof TypeVariable) || (idx = ListUtil.indexOf((Object[])params, (Object)arg)) == -1) continue;
                args[ii] = values[idx];
            }
            return Property.getTypeArguments((Class)ptype.getRawType(), args, clazz);
        }
        if (type instanceof Class) {
            return Property.getTypeArguments((Class)type, null, clazz);
        }
        return null;
    }

    protected Class<?> getTypeClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Class<?> cclass = this.getTypeClass(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(cclass, 0).getClass();
        }
        return null;
    }

    protected boolean isLegalValue(Class<?> type, Object value) {
        if (type.isPrimitive()) {
            if (value == null) {
                return false;
            }
            type = ClassUtil.objectEquivalentOf(type);
        }
        if (value != null && !type.isInstance(value)) {
            return false;
        }
        Editable annotation = this.getAnnotation();
        return value != null || annotation.nullable();
    }

    protected static void addSubtypes(EditorTypes annotation, Collection<Class<?>> types) {
        for (Class<?> sclazz : annotation.value()) {
            if (sclazz.getAnnotation(EditorTypes.class) == annotation) {
                types.add(sclazz);
                continue;
            }
            Property.addSubtypes(sclazz, types);
        }
    }

    protected static void addSubtypes(Class<?> clazz, Collection<Class<?>> types) {
        EditorTypes annotation = clazz.getAnnotation(EditorTypes.class);
        if (annotation == null) {
            types.add(clazz);
        } else {
            Property.addSubtypes(annotation, types);
        }
    }

    static {
        Config config = new Config("/rsrc/config/editor/type");
        Iterator it = config.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            ArrayList classes = new ArrayList();
            for (String cname : config.getValue(key, new String[0])) {
                try {
                    Property.addSubtypes(Class.forName(cname), classes);
                }
                catch (ClassNotFoundException e) {
                    Log.log.warning((Object)"Missing type config class.", new Object[]{"class", cname, e});
                }
            }
            _configTypes.put(key, classes.toArray(new Class[classes.size()]));
        }
    }
}

