/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.swing;

import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.swing.ConfigTree;
import com.threerings.config.swing.ConfigTreeNode;
import com.threerings.editor.Introspector;
import com.threerings.resource.ResourceManager;
import com.threerings.util.MessageBundle;
import com.threerings.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public abstract class ConfigChooser
extends JPanel {
    protected static Preferences _prefs = Preferences.userNodeForPackage(ConfigChooser.class);

    public static ConfigChooser createInstance(MessageManager msgmgr, ConfigManager cfgmgr, Class<?> clazz) {
        return ConfigChooser.createInstance(msgmgr, cfgmgr, clazz, null);
    }

    public static ConfigChooser createInstance(MessageManager msgmgr, ConfigManager cfgmgr, Class<?> clazz, String config) {
        ConfigChooser chooser;
        ConfigChooser configChooser = chooser = cfgmgr.isResourceClass(clazz) ? new ResourceChooser(msgmgr, cfgmgr.getResourceManager(), clazz) : new TreeChooser(msgmgr, cfgmgr, clazz);
        if (config != null) {
            chooser.setSelectedConfig(config);
        }
        return chooser;
    }

    public abstract boolean showDialog(Component var1);

    public abstract void setSelectedConfig(String var1);

    public abstract String getSelectedConfig();

    protected String getLabel(MessageManager msgmgr, Class<?> clazz, String type) {
        String key;
        MessageBundle msgs = msgmgr.getBundle(Introspector.getMessageBundle(clazz));
        return msgs.exists(key = "m." + type) ? msgs.get(key) : type;
    }

    protected static class TreeChooser
    extends ConfigChooser {
        protected MessageBundle _msgs;
        protected String _label;
        protected ConfigGroup[] _groups;
        protected JButton _ok;
        protected JButton _cancel;
        protected String _selected;

        public TreeChooser(MessageManager msgmgr, ConfigManager cfgmgr, Class<?> clazz) {
            this._msgs = msgmgr.getBundle("config");
            this._label = this.getLabel(msgmgr, clazz, ConfigGroup.getName(clazz));
            Class<?> cclass = clazz;
            this._groups = cfgmgr.getGroups(cclass);
            this.setLayout(new BorderLayout());
            JPanel bpanel = new JPanel();
            this.add((Component)bpanel, "South");
            this._ok = new JButton(this._msgs.get("m.ok"));
            bpanel.add(this._ok);
            this._cancel = new JButton(this._msgs.get("m.cancel"));
            bpanel.add(this._cancel);
        }

        @Override
        public boolean showDialog(Component parent) {
            Component root = SwingUtilities.getRoot(parent);
            String title = this._msgs.get("m.select_config", new String[]{this._label});
            final JDialog dialog = root instanceof Dialog ? new JDialog((Dialog)root, title, true) : new JDialog((Frame)(root instanceof Frame ? root : null), title, true);
            dialog.add((Component)this, "Center");
            final ConfigTree tree = new ConfigTree(this._groups);
            JScrollPane pane = new JScrollPane(tree);
            this.add((Component)pane, "Center");
            final boolean[] result = new boolean[1];
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() == TreeChooser.this._ok) {
                        TreeChooser.this._selected = tree.getSelectedNode().getName();
                        result[0] = true;
                    }
                    dialog.setVisible(false);
                }
            };
            this._ok.addActionListener(al);
            this._cancel.addActionListener(al);
            tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent event) {
                    ConfigTreeNode node = tree.getSelectedNode();
                    TreeChooser.this._ok.setEnabled(node != null && node.getConfig() != null);
                }
            });
            this._ok.setEnabled(false);
            tree.setSelectedNode(this._selected);
            dialog.setSize(300, 400);
            dialog.setLocationRelativeTo(parent);
            dialog.setVisible(true);
            this._ok.removeActionListener(al);
            this._cancel.removeActionListener(al);
            this.remove(pane);
            tree.dispose();
            dialog.dispose();
            return result[0];
        }

        @Override
        public void setSelectedConfig(String config) {
            this._selected = config;
        }

        @Override
        public String getSelectedConfig() {
            return this._selected;
        }
    }

    protected static class ResourceChooser
    extends ConfigChooser {
        protected ResourceManager _rsrcmgr;
        protected JFileChooser _chooser;
        protected String _prefdir;

        public ResourceChooser(MessageManager msgmgr, ResourceManager rsrcmgr, Class<?> clazz) {
            this._rsrcmgr = rsrcmgr;
            final MessageBundle msgs = msgmgr.getBundle("config");
            String ddir = rsrcmgr.getResourceFile("").toString();
            String type = ConfigGroup.getName(clazz);
            final String label = this.getLabel(msgmgr, clazz, type);
            this._prefdir = type + "_dir";
            this._chooser = new JFileChooser(_prefs.get(this._prefdir, ddir));
            this._chooser.setDialogTitle(msgs.get("m.select_config", new String[]{label}));
            this._chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || StringUtil.toUSLowerCase((String)file.getName()).endsWith(".dat");
                }

                @Override
                public String getDescription() {
                    return msgs.get("m.config_files", new String[]{label});
                }
            });
        }

        @Override
        public boolean showDialog(Component parent) {
            boolean approved = this._chooser.showOpenDialog(parent) == 0;
            _prefs.put(this._prefdir, this._chooser.getCurrentDirectory().toString());
            return approved;
        }

        @Override
        public void setSelectedConfig(String config) {
            this._chooser.setSelectedFile(config == null ? null : this._rsrcmgr.getResourceFile(config));
        }

        @Override
        public String getSelectedConfig() {
            File file = this._chooser.getSelectedFile();
            return file == null ? null : this._rsrcmgr.getResourcePath(file);
        }
    }
}

