/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.threerings.ClydeLog;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakObserverSet<T> {
    protected LinkedHashSet<ObserverRef<T>> _set = new LinkedHashSet();
    protected ObserverRef<T>[] _snap;
    protected boolean _dirty = true;

    public static <T> WeakObserverSet<T> newSet() {
        return new WeakObserverSet<T>();
    }

    public boolean add(T observer) {
        if (this._set.add(new ObserverRef<T>(observer))) {
            this._dirty = true;
            return true;
        }
        ClydeLog.log.warning((Object)"Observer attempted to observe set it's already observing!", new Object[]{"observer", observer, new Exception()});
        return false;
    }

    public boolean remove(T observer) {
        boolean removed = this._set.remove(new ObserverRef<T>(observer));
        if (removed) {
            this._dirty = true;
        }
        return removed;
    }

    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    public void apply(ObserverOp<T> obop) {
        int ocount = this._set.size();
        if (ocount == 0) {
            return;
        }
        if (this._dirty) {
            if (this._snap == null || this._snap.length < ocount || this._snap.length > ocount << 3) {
                ObserverRef[] snap = new ObserverRef[ocount];
                this._snap = snap;
            }
            int idx = 0;
            Iterator it = this._set.iterator();
            while (it.hasNext()) {
                ObserverRef ref = (ObserverRef)it.next();
                if (ref.get() != null) {
                    this._snap[idx++] = ref;
                    continue;
                }
                it.remove();
            }
            ocount = idx;
            this._dirty = false;
        }
        for (int ii = 0; ii < ocount; ++ii) {
            Object observer = this._snap[ii].get();
            if (observer != null) {
                if (WeakObserverSet.checkedApply(obop, observer)) continue;
                this.remove(observer);
                continue;
            }
            this._dirty = true;
        }
    }

    public String toString() {
        return this._set.toString();
    }

    protected static <T> boolean checkedApply(ObserverOp<T> obop, T obs) {
        try {
            return obop.apply(obs);
        }
        catch (Throwable thrown) {
            ClydeLog.log.warning((Object)"ObserverOp choked during notification", new Object[]{"op", obop, "obs", obs, thrown});
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ObserverRef<T>
    extends WeakReference<T> {
        public ObserverRef(T referent) {
            super(referent);
        }

        public int hashCode() {
            return System.identityHashCode(this.get());
        }

        public boolean equals(Object other) {
            return this.get() == ((ObserverRef)other).get();
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ObserverOp<T> {
        public boolean apply(T var1);
    }
}

