/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.threerings.math.Vector2f;
import com.threerings.tudey.data.InputFrame;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.Pawn;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.util.ActiveAdvancer;
import com.threerings.tudey.util.ActorAdvancer;

public class PawnAdvancer
extends ActiveAdvancer {
    protected Pawn _pawn;
    protected InputFrame _frame;
    protected Shape _swept;

    public PawnAdvancer(ActorAdvancer.Environment environment, Pawn pawn, int timestamp) {
        super(environment, pawn, timestamp);
    }

    public void advance(InputFrame frame) {
        this._frame = frame;
        this.advance(frame.getTimestamp());
    }

    public void init(Actor actor, int timestamp) {
        super.init(actor, timestamp);
        this._pawn = (Pawn)actor;
        this._frame = null;
    }

    protected void step(float elapsed) {
        super.step(elapsed);
        if (this._frame != null) {
            this.updateInput();
        }
    }

    protected void takeSubsteps(float elapsed) {
        Vector2f ftrans;
        Vector2f ptrans;
        float distance;
        if (this._frame == null || this._timestamp != this._frame.getTimestamp() || this._frame.getTranslation() == null || this.ignoreInputPosition()) {
            super.takeSubsteps(elapsed);
            return;
        }
        if (!this.canMove()) {
            this._active.clear(2);
        }
        if ((distance = (ptrans = this._pawn.getTranslation()).distance(ftrans = this._frame.getTranslation())) == 0.0f) {
            return;
        }
        if (distance > this._pawn.getSpeed() * elapsed + 0.5f) {
            super.takeSubsteps(elapsed);
            return;
        }
        this.updateShape();
        this._swept = this._shape.sweep(ftrans.subtract(ptrans, this._penetration), this._swept);
        if (this._environment.collides(this._pawn, this._swept)) {
            super.takeSubsteps(elapsed);
            return;
        }
        ptrans.set(ftrans);
        this._pawn.setDirty(true);
    }

    protected boolean ignoreInputPosition() {
        return false;
    }

    protected void updateInput() {
        ActiveAdvancer.Activity activity = this.getActivity();
        if (activity != null) {
            activity.updateInput();
        }
        if (this.canRotate()) {
            this.updateRotation();
        }
        if (this._frame.isSet(1) && this.canMove()) {
            this._pawn.setDirection(this._frame.getDirection());
            this._pawn.set(2);
        } else {
            this._pawn.clear(2);
        }
    }

    protected void updateRotation() {
        this._pawn.setRotation(this._frame.getRotation());
    }
}

