/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.samskivert.util.HashIntSet;
import com.samskivert.util.Interator;
import com.samskivert.util.RandomUtil;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.Direction;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordSet
extends AbstractSet<Coord> {
    protected HashIntSet _coords = new HashIntSet(8, Coord.EMPTY);

    public CoordSet(Collection<Coord> collection) {
        this.addAll(collection);
    }

    public CoordSet(Rectangle region) {
        this.addAll(region);
    }

    public CoordSet(int x, int y, int width, int height) {
        this.addAll(x, y, width, height);
    }

    public CoordSet() {
    }

    public boolean addAll(Rectangle region) {
        return this.addAll(region.x, region.y, region.width, region.height);
    }

    public boolean addAll(int x, int y, int width, int height) {
        boolean changed = false;
        int yymax = y + height;
        for (int yy = y; yy < yymax; ++yy) {
            int xxmax = x + width;
            for (int xx = x; xx < xxmax; ++xx) {
                changed |= this.add(xx, yy);
            }
        }
        return changed;
    }

    public boolean add(int x, int y) {
        return this._coords.add(Coord.encode(x, y));
    }

    public boolean removeAll(Rectangle region) {
        return this.removeAll(region.x, region.y, region.width, region.height);
    }

    public boolean removeAll(int x, int y, int width, int height) {
        boolean changed = false;
        int yymax = y + height;
        for (int yy = y; yy < yymax; ++yy) {
            int xxmax = x + width;
            for (int xx = x; xx < xxmax; ++xx) {
                changed |= this.remove(xx, yy);
            }
        }
        return changed;
    }

    public boolean remove(int x, int y) {
        return this._coords.remove(Coord.encode(x, y));
    }

    public boolean containsAll(Rectangle region) {
        return this.containsAll(region.x, region.y, region.width, region.height);
    }

    public boolean containsAll(int x, int y, int width, int height) {
        int yymax = y + height;
        for (int yy = y; yy < yymax; ++yy) {
            int xxmax = x + width;
            for (int xx = x; xx < xxmax; ++xx) {
                if (this.contains(xx, yy)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean contains(int x, int y) {
        return this._coords.contains(Coord.encode(x, y));
    }

    public Coord pickRandom() {
        return this.pickRandom(1, 1);
    }

    public Coord pickRandom(Coord result) {
        return this.pickRandom(1, 1, result);
    }

    public Coord pickRandom(int width, int height) {
        return this.pickRandom(width, height, new Coord());
    }

    public Coord pickRandom(int width, int height, Coord result) {
        if (width == 1 && height == 1) {
            Interator it = this._coords.interator();
            int nn = RandomUtil.getInt((int)this.size());
            for (int ii = 0; ii < nn; ++ii) {
                it.nextInt();
            }
            return result.set(it.nextInt());
        }
        CoordSet origins = new CoordSet();
        for (Coord coord : this) {
            if (!this.containsAll(coord.x, coord.y, width, height)) continue;
            origins.add(coord);
        }
        return origins.pickRandom(result);
    }

    public Rectangle getLargestRegion(Rectangle result) {
        result.set(0, 0, 0, 0);
        for (Coord coord : this) {
            int maxWidth = Integer.MAX_VALUE;
            int yy = coord.y;
            while (this.contains(coord.x, yy)) {
                int width;
                int height = yy - coord.y + 1;
                for (width = 1; width < maxWidth && this.contains(coord.x + width, yy); ++width) {
                }
                maxWidth = width;
                if (width * height > result.getArea()) {
                    result.set(coord.x, coord.y, width, height);
                }
                ++yy;
            }
        }
        return result;
    }

    public CoordSet getBorder() {
        return this.getBorder(new CoordSet());
    }

    public CoordSet getBorder(CoordSet result) {
        for (Coord coord : this) {
            for (Direction dir : Direction.values()) {
                int y;
                int x = coord.x + dir.getX();
                if (this.contains(x, y = coord.y + dir.getY())) continue;
                result.add(x, y);
            }
        }
        return result;
    }

    public CoordSet getCardinalBorder() {
        return this.getCardinalBorder(new CoordSet());
    }

    public CoordSet getCardinalBorder(CoordSet result) {
        for (Coord coord : this) {
            for (Direction dir : Direction.CARDINAL_VALUES) {
                int y;
                int x = coord.x + dir.getX();
                if (this.contains(x, y = coord.y + dir.getY())) continue;
                result.add(x, y);
            }
        }
        return result;
    }

    @Override
    public boolean add(Coord coord) {
        return this._coords.add(coord.encode());
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Coord && this._coords.remove(((Coord)object).encode());
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Coord && this._coords.contains(((Coord)object).encode());
    }

    @Override
    public int size() {
        return this._coords.size();
    }

    @Override
    public Iterator<Coord> iterator() {
        return new Iterator<Coord>(){
            protected Interator _it;
            protected Coord _dummy;
            {
                this._it = CoordSet.this._coords.interator();
                this._dummy = new Coord();
            }

            @Override
            public boolean hasNext() {
                return this._it.hasNext();
            }

            @Override
            public Coord next() {
                return this._dummy.set(this._it.nextInt());
            }

            @Override
            public void remove() {
                this._it.remove();
            }
        };
    }
}

