/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.math.Vector3f;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.client.util.RectangleElement;
import com.threerings.tudey.config.WallConfig;
import com.threerings.tudey.tools.ConfigTool;
import com.threerings.tudey.tools.EditorTool;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.CoordSet;
import com.threerings.tudey.util.TilePainter;
import com.threerings.tudey.util.TudeySceneMetrics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WallBrush
extends ConfigTool<WallConfig> {
    protected RectangleElement _inner;
    protected RectangleElement _outer;
    protected boolean _cursorVisible;
    protected EditorTool.DirectionalConstraint _constraint;
    protected Coord _location = new Coord();
    protected int _rotation;
    protected Rectangle _lastPainted = new Rectangle();
    protected Vector3f _isect = new Vector3f();

    public WallBrush(SceneEditor editor) {
        super(editor, WallConfig.class, new WallReference());
    }

    @Override
    public void init() {
        this._inner = new RectangleElement((GlContext)this._editor, true);
        this._inner.getColor().set(1.0f, 1.0f, 0.0f, 1.0f);
        this._outer = new RectangleElement((GlContext)this._editor, true);
        this._outer.getColor().set(0.5f, 0.5f, 0.0f, 1.0f);
    }

    @Override
    public void tick(float elapsed) {
        this.updateCursor();
    }

    @Override
    public void composite() {
        if (this._cursorVisible) {
            this._inner.composite();
            this._outer.composite();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        boolean erase;
        int button = event.getButton();
        boolean paint = button == 1;
        boolean bl = erase = button == 3;
        if ((paint || erase) && this._cursorVisible) {
            this.paintWall(erase, true);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this._cursorVisible) {
            this._rotation = this._rotation + event.getWheelRotation() & 3;
        }
    }

    protected void updateCursor() {
        this._cursorVisible = this.getMousePlaneIntersection(this._isect) && !this._editor.isSpecialDown();
        if (!this._cursorVisible) {
            return;
        }
        WallReference wref = (WallReference)this._eref;
        int iwidth = TudeySceneMetrics.getTileWidth(wref.width, wref.height, this._rotation);
        int iheight = TudeySceneMetrics.getTileHeight(wref.width, wref.height, this._rotation);
        int owidth = iwidth + 2;
        int oheight = iheight + 2;
        int x = Math.round(this._isect.x - (float)iwidth * 0.5f);
        int y = Math.round(this._isect.y - (float)iheight * 0.5f);
        if (this._editor.isShiftDown()) {
            if (this._constraint == EditorTool.DirectionalConstraint.HORIZONTAL) {
                y = this._location.y;
            } else if (this._constraint == EditorTool.DirectionalConstraint.VERTICAL) {
                x = this._location.x;
            } else if (x != this._location.x && y == this._location.y) {
                this._constraint = EditorTool.DirectionalConstraint.HORIZONTAL;
            } else if (x == this._location.x && y != this._location.y) {
                this._constraint = EditorTool.DirectionalConstraint.VERTICAL;
            }
        } else {
            this._constraint = null;
        }
        this._location.set(x, y);
        this._inner.getRegion().set(x, y, iwidth, iheight);
        this._outer.getRegion().set(x - 1, y - 1, owidth, oheight);
        int elevation = this._editor.getGrid().getElevation();
        this._inner.setElevation(elevation);
        this._outer.setElevation(elevation);
        boolean paint = this._editor.isFirstButtonDown();
        boolean erase = this._editor.isThirdButtonDown();
        if ((paint || erase) && !this._inner.getRegion().equals(this._lastPainted)) {
            this.paintWall(erase, false);
        }
    }

    protected void paintWall(boolean erase, boolean revise) {
        TilePainter painter = new TilePainter(this._editor.getConfigManager(), this._scene, this._editor);
        Rectangle region = this._inner.getRegion();
        painter.paintWall(new CoordSet(region), this._eref.getReference(), this._editor.getGrid().getElevation(), erase, revise);
        this._lastPainted.set(region);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class WallReference
    extends ConfigTool.EditableReference<WallConfig> {
        @Editable(nullable=true)
        public ConfigReference<WallConfig> wall;
        @Editable(min=1.0, hgroup="d")
        public int width = 1;
        @Editable(min=1.0, hgroup="d")
        public int height = 1;

        protected WallReference() {
        }

        @Override
        public ConfigReference<WallConfig> getReference() {
            return this.wall;
        }

        @Override
        public void setReference(ConfigReference<WallConfig> ref) {
            this.wall = ref;
        }
    }
}

